#include "stdio.h"
#include "stdlib.h"
#include "math.h"

#define V(A) A[0]
#define S(A) A[1]
#define M(A) A[2]
#define N(A) A[3]
#define H(A) A[4]

#define W(A) A[5]
#define Q(A) A[6]

#define mNap(A) A[5]
#define hf(A) A[6]
#define hs(A) A[7]
#define mKs(A) A[8]

#define SR(A) A[5]
#define SA(A) A[6]
#define SB(A) A[7]

#define MAXNUMBEROFCELLS 100
#define MAXDIM 10
#define MAXNETWORKSIZE 10
#define MAXINPUTS 10

#define DONT_REPORT 0
#define REPORT_VOLTAGE 1
#define REPORT_ALL 2


extern double TANH(double x);
extern double EXP(double x);
extern double THETA(double x);
extern void makeTables();
extern double normalrnd();


#define SPIKE_VOLTAGE 0		// Voltage above this is considered as spike
#define DVC 0.1			// delta V to trigger report

#define UP   2
#define MED  0.8
#define DOWN 0.1


class Neuron{
 public:
  int numberOfCells;                    // number of cells in population
  double x[MAXNUMBEROFCELLS][MAXDIM];   // dynamic variables [#of cell][# of var]
  double g_int_syn;                     // Synaptic conductance within the population
  double g_int_elc;                     // Electric conductance within the population
  double g_int_slf;                     // Self autapse conductance within the population

  int numberOfInputs;        		// number of inputs to the population 
  Neuron* inputs[MAXINPUTS]; 		// array of pointers to presynaptic cells
  double g_ext_syn[MAXINPUTS]; 		// corresponding conductances 
  double g_ext_elc[MAXINPUTS]; 		// corresponding conductances 

  int need_report;			// flag that shows that voltage has changed significantly

  double total_s;                       //sum of all s-variables over population 
  double total_v;                       //sum of all v-variables over population 
  double sum_gsyn_totals;		//sum of g_int_syn*total_s over inputs
  double sum_gsyn_totals_erev;	    	//sum of g_int_syn*total_s*e_rev over inputs
  double sum_gelc_totalv;		//sum of g_ext_elc*total_v over inputs
  double sum_gelc_nofcells;		//sum of g_ext_elc*numberofcells over inputs

  double I_app;                         //Applied current;
  double C;                             //Membrane capacitance;
  double VMin, VMax;                    //Min and Max voltage
  double I_ion;                         //The sum of ion currents
  double E_rev;                         //Reversal potential
  double als, bes;                      //Synapse raise and decay times 
  double Vth, Vsl;			//Synapse sigmoidal params (Vthreshold and Vslope)

  double v_rep[MAXNUMBEROFCELLS];	//last reported volteage of the ith cell
  int spike_flag[MAXNUMBEROFCELLS];	//spiking flag for the ith cell;
  double spike_time[MAXNUMBEROFCELLS];   //time of the last spike of the i-th cell


 
  Neuron(int n) {
    numberOfInputs = 0;
    numberOfCells = n;
    init();
    I_app = 0;
    I_ion = 0;
    C    = 1;
    VMin = -120;
    VMax = 120;
    g_int_syn = 0;
    g_int_elc = 0;
    g_int_slf = 0;
    E_rev = -20;
    als  =  20;
    bes  =  0.33;
    Vth = 0;
    Vsl = 0.5;
    need_report = 1;
  }

  void setHeterogeneity(double sd);
  void init();
  void correct_voltage(double x[]);
  void track_spikes(int i, double time);
  double getperiod(int i, double dt);
  virtual void f(double x[], double y[]);
  virtual void cycle(double time, double dt);
  void report(FILE *f, int report_mode);
  void reset();
  void letitgo(int i, int m, double dt);
  virtual void desynchronize(int n, double dt);
  void RungeKutta(double x[], double dt);
  void addSynapseFrom(Neuron *presynaptic, double g_syn);
  void addSynapseFrom(Neuron *presynaptic, double g_syn, double g_elc);
  void save(char *filename);
  void load(char *filename);
  double getdecaytime(double dt);
};

class Network {
 private:
  int networkSize;
 public:
  double time;
  double vat;
  int report_mode;
  FILE *outfile;
  

  Neuron* neurons[MAXNETWORKSIZE];
  Network() {
    time = 0;
    networkSize=0;
    report_mode =0;
    outfile=stdout;
  };
  
  void addElement(Neuron *neuron);
  void cycle(double dt);
  void report();
  void reset();
  void getprc(Neuron *presynaptic, int i, Neuron *postsynaptic, int j, double dt, double tau, double *delta, double *phi);
  void getprc1(Neuron *presynaptic, int i, Neuron *postsynaptic, int j, double dt, double tau, double *delta, double *phi);
  void getprc2(Neuron *presynaptic, int i, Neuron *postsynaptic, int j, double dt, double tau, double *delta, double *phi);
//  void gettrace(double dt);
  void run(int n, double dt);
  void set_outfile(char *filename);
};
