#include <cstdlib>
#include <iostream>

using namespace std;

#include <cstdlib>
#include <iostream>
#include "math.h"

#include "models.h"

using namespace std;


int main(int argc, char *argv[])
{
    int i,j,k,n;
    double dt = 0.005;		// Time step used in simulations
    double gIO=0.5;		// Max gIO synaptic conductance
    int n_points = 100;
    double tau, dtau, phi, delta,T;
    char *pc;
    FILE *output;
    double prc[10000];		// Spike time response storage array
    double t[10000];		// Perturbation time storage array
    double res[5000][10];	// Resulting array of PRC
    int M=128;
    int N=10;			// Number of PRC curves to generate (see below)

    makeTables();  // Tablulates exponential and other function (for speedup)

    for(i=1;i<argc;i++) {
        pc = argv[i];
        if(*pc != '-') continue;
        if(*(pc+1) == 'g') {
           sscanf(argv[++i], "%lf", &gIO);
        }
    }


    Network my_network;		// Network object declared

    WangBuzsakiBasket I(1);	// A Wang-Buzsaki basket cell declared (see models.h for cell types)
    my_network.addElement(&I);	// Added to the network
    I.I_app = 0.16;		// Applied drive is such that the I cell is not spiking
    I.load("i_init_cond0");	// Loading initial conditions for this cell

    SaragaOLM O(1);		// A Saraga OLM cell declared here
    my_network.addElement(&O);	// Added to the network
    O.I_app = -4.7; 		// Applied drive is such that the O cell spikes at ~ 7 Hz 
    O.load("o_init_cond0");	// Initial conditions loaded
    
    
    O.addSynapseFrom(&I,gIO);	// Now the I cell is connected to the O cell with a synapse (conductance = gIO)
 
    my_network.reset();		// Network variables are reset
      
    my_network.report_mode=DONT_REPORT;	// By default the script will print cell voltages to STDOUT. This line is to suppress these reports
    T = O.getperiod(0,dt);   	// Measure the period of a free-running O-cell
    
    O.letitgo(0,(int)((4*T-15)/dt),dt);	// Let O cell run for 4 periods and save the initial conditions 5 ms prior to the last spike 
    O.save("o_init_cond1");

    fprintf(stderr,"Free period = %2.2lf\n",T);
              
    dtau=T/150; // This is the increment of time between iterations of PRC measurement
    
    prc[0]=T;
    t[0] = 0;
   
    // The following loop measures a family of PRCs, with the synaptic strengths varying uniformely from 0 to gIO
    for(n=1;n<=N;n++) {

        O.g_ext_syn[0]= gIO*n/N;		// Set the synaptic conductance I->O to be n/N of the max conductance (gIO)
        fprintf(stderr,"g=%2.2lf\n",gIO*n/N);

        k=0;	// 	This is an index of the current PRC datapoint

	// This loop goes over a uniform grid of perturbation times (from 0 to T)
        for(tau=0;;tau+=dtau) {
            my_network.reset();			// Start a new measurement
            O.load("o_init_cond1");		// Reset the cells
            I.load("i_init_cond0");
            my_network.getprc2(&I, 0, &O, 0, dt, tau, &delta, &phi); // Compute the perturbed spike time phi
            if(delta<0 && k==0) continue;	// Ignore stimuli before the first spike of the O cell
            if(delta<0 && k>1) break;		
            if(delta>phi) break;		// Ignore stimuli after the end time point (T)
            if(delta<=t[k-1]) break;
            t[k]= delta;

            prc[k] = phi;			// Store the value of phi in an array and increment pointer
            k++; 
            fprintf(stderr,".");
        }
	fprintf(stderr,"\n");

	// The loop below converts times to phases and makes the grid uniform
        for(j=0;j<M;j++) {
            delta = (double)j*t[k-1]/M; 
            for(i=0;i<k-1;i++) {
                if(t[i]<=delta && delta<t[i+1]) {
                    phi = prc[i] - prc[k-1] + (prc[i+1]-prc[i])*(delta-t[i])/(t[i+1]-t[i]);
                    res[j][n] = phi/prc[k-1];
                    break;
                }
            }
        }
	res[M][n]=0.0;
    }

    // This script stores the values of PRC in the corresponding output file
    // The first column is time; the other columns are the values of PRC for each of the conductance values
    output = fopen("strc_IO.out","w");
    for(j=0;j<=M;j++) {
        fprintf(output,"%2.4lf\t\t",(double)j/M);
        for(n=1;n<=N;n++) {
            fprintf(output,"%2.4lf\t",res[j][n]);
        }
        fprintf(output,"\n");
    }
    fclose(output);    


}
