#include <cstdlib>
#include <iostream>

using namespace std;

#include <cstdlib>
#include <iostream>
#include "math.h"

#include "models.h"

using namespace std;


int main(int argc, char *argv[])
{
    int i,j,k,n;
    double dt = 0.005;
    double gOE=0.002;
    int n_points = 100;
    double tau, dtau, phi, delta,T;
    char *pc;
    FILE *output;
    double prc[10000];
    double t[10000];
    double res[5000][10];
    int M=128;
    int N=10;
    
    makeTables();  // Tablulates exponential and other function (for speedup)

    for(i=1;i<argc;i++) {
        pc = argv[i];
        if(*pc != '-') continue;
        if(*(pc+1) == 'g') {
           sscanf(argv[++i], "%lf", &gOE);
        }
    }


    Network my_network;

    SaragaOLM O(1);
    my_network.addElement(&O);
    O.I_app = -20; // O cell shut up
    O.load("o_init_cond0");
   
    OlufsenEcell E(1);
    my_network.addElement(&E);
    E.I_app = 0.137; // E cell spiking at ~ ms
    E.load("e_init_cond0");
 
    
    E.addSynapseFrom(&O,gOE);
 
    my_network.reset();
    my_network.report_mode=DONT_REPORT;

   
    T = E.getperiod(0,dt);
    
    E.letitgo(0,(int)((4*T-15)/dt),dt);
    E.save("e_init_cond1"); // drive it to 5 ms before the next spike and save
    fprintf(stderr,"Free period = %2.2lf\n",T);
              
    dtau=T/150;
    prc[0]=T;
    t[0] = 0;
   
    for(n=1;n<=N;n++) {
        E.g_ext_syn[0]= gOE*n/N;
        k=0;
        fprintf(stderr,"g=%2.4lf\n",gOE*n/N);
        for(tau=0;;tau+=dtau) {
            my_network.reset();
            E.load("e_init_cond1");
            O.load("o_init_cond0");
            my_network.getprc1(&O, 0, &E, 0, dt, tau, &delta, &phi);
            if(delta<0 && tau<T) continue;
            if(delta>phi) break;
            if(delta<=t[k-1]) break;
            t[k]= delta;
            prc[k] = phi;
            k++; 
            fprintf(stderr,".");
        }
	fprintf(stderr,"\n");
        for(j=0;j<M;j++) {
            delta = (double)j*t[k-1]/M; 
            for(i=0;i<k-1;i++) {
                if(t[i]<=delta && delta<t[i+1]) {
                    phi = prc[i] - prc[k-1] + (prc[i+1]-prc[i])*(delta-t[i])/(t[i+1]-t[i]);
                    res[j][n] = phi/prc[k-1];
                    break;
                }
            }
        }
	res[M][n]=0.0;

    }

    output = fopen("strc_OE.out","w");
    for(j=0;j<=M;j++) {
        fprintf(output,"%2.4lf\t\t",(double)j/M);
        for(n=1;n<=N;n++) {
            fprintf(output,"%2.4lf\t",res[j][n]);
        }
        fprintf(output,"\n");
    }
    fclose(output);    


}
