#include <cstdlib>
#include <iostream>

using namespace std;

#include <cstdlib>
#include <iostream>
#include "math.h"

#include "models.h"

using namespace std;


int main(int argc, char *argv[])
{
    int i,j,k,n;
    double dt = 0.005;
    double gOO=0.3;
    int n_points = 100;
    double tau, dtau, phi, delta,T;
    char *pc;
    FILE *output;
    double prc[10000];
    double t[10000];
    double res[5000][10];
    int M=128;
    int N=10;
    

    

    makeTables();  // Tablulates exponential and other function (for speedup)

    Network my_network;

    SaragaOLM O1(1);
    my_network.addElement(&O1);
    O1.I_app = -20; // I cell shut up
    O1.load("o_init_cond0");
   
    SaragaOLM O2(1);
    my_network.addElement(&O2);
    O2.I_app = -4.7; // O cell spiking at ~300 ms
    O2.load("o_init_cond0");
 
    
    O2.addSynapseFrom(&O1,gOO);
  
    my_network.reset();
    my_network.report_mode = DONT_REPORT;
    T = O2.getperiod(0,dt);
    
    O2.letitgo(0,(int)((4*T-15)/dt),dt);
    O2.save("o_init_cond1"); // drive it to 5 ms before the next spike and save
    fprintf(stderr,"Free period = %2.2lf\n",T);
              
    dtau=T/150;
    prc[0]=T;
    t[0] = 0;
   
    for(n=1;n<=N;n++) {
      O2.g_ext_syn[0]= gOO*n/N;
      k=0;
      fprintf(stderr,"g=%2.2lf\n",gOO*n/N);

      for(tau=0;;tau+=dtau) {
          my_network.reset();
          O1.load("o_init_cond0");
          O2.load("o_init_cond1");
          my_network.getprc1(&O1, 0, &O2, 0, dt, tau, &delta, &phi);
          if(delta<0) continue;
          if(delta>phi) break;
          if(delta<=t[k-1]) break;
          t[k]= delta;
          prc[k] = phi;
          k++; 
          fprintf(stderr,".");
      }
      for(j=0;j<M;j++) {
        delta = (double)j*t[k-1]/M; 
        for(i=0;i<k-1;i++) {
            if(t[i]<=delta && delta<t[i+1]) {
                phi = prc[i] - prc[k-1] + (prc[i+1]-prc[i])*(delta-t[i])/(t[i+1]-t[i]);
                res[j][n] = phi/prc[k-1];
                break;
            }
        }
      }
      res[M][n]=0.0;
      fprintf(stderr,"\n");
   }

   output = fopen("strc_OO.out","w");
   for(j=0;j<=M;j++) {
       fprintf(output,"%2.4lf\t\t",(double)j/M);
       for(n=1;n<=N;n++) {
           fprintf(output,"%2.4lf\t",res[j][n]);
       }
       fprintf(output,"\n");
   }
   fclose(output);    


}
