#include <cstdlib>
#include <iostream>

using namespace std;

#include <cstdlib>
#include <iostream>
#include "math.h"

#include "models.h"

using namespace std;


int main(int argc, char *argv[])
{
    int i,j,k,n;
    double dt = 0.005;
    double gIO=0.20;
    double gEO=0.20;
    int n_points = 100;
    double tau, dtau, phi, delta,T;
    char *pc;
    FILE *output;
    double prc[10000];
    double t[10000];
    double res[5000][10];
    int M=128;
    int N=10;
    

    makeTables();  // Tablulates exponential and other function (for speedup)


    Network my_network;

    OlufsenEcell E(1);
    my_network.addElement(&E);
    E.I_app = 0; // E cell shut up
    E.load("e_init_cond0");

    WangBuzsakiBasket I(1);
    my_network.addElement(&I);
    I.I_app = 0.1; // I cell shut up
    I.load("i_init_cond0");
   
    SaragaOLM O(1);
    my_network.addElement(&O);
    O.I_app = -4.7; // O cell spiking at ~300 ms
    //O.load("o_init_cond0");
 
    E.addSynapseFrom(&I,0.40);
    I.addSynapseFrom(&E,0.20);
    I.g_int_slf=0.30;
    
    O.addSynapseFrom(&I,gIO);
    O.addSynapseFrom(&E,gEO);
 
    my_network.reset();
    my_network.report_mode=DONT_REPORT;
    T = O.getperiod(0,dt);

       
    O.letitgo(0,(int)((4*T-15)/dt),dt);
    O.save("o_init_cond1"); // drive it to 5 ms before the next spike and save
    fprintf(stderr,"Free period = %2.2lf\n",T);
    
    
              
    dtau=T/150;
    prc[0]=T;
    t[0] = 0;
   
    for(n=1;n<=N;n++) {
      O.g_ext_syn[1]= gEO*n/N;
      k=0;
      fprintf(stderr,"g=%2.2lf\n",gEO*n/N);
      for(tau=0;;tau+=dtau) {
          my_network.reset();
          O.load("o_init_cond1");
          E.load("e_init_cond0");
          I.load("i_init_cond0");
          my_network.getprc(&E, 0, &O, 0, dt, tau, &delta, &phi);
          if(delta<0 && k==0) continue;
          if(delta<0 && k>1) break;
          if(delta>phi) break;
          if(delta<=t[k-1]) break;
          t[k]= delta;
          prc[k] = phi;
          fprintf(stderr,".");
          k++; 
      }
      fprintf(stderr,"\n");

      for(j=0;j<M;j++) {
        delta = (double)j*t[k-1]/M; 
        for(i=0;i<k-1;i++) {
            if(t[i]<=delta && delta<t[i+1]) {
                phi = prc[i] - prc[k-1] + (prc[i+1]-prc[i])*(delta-t[i])/(t[i+1]-t[i]);
                res[j][n] = phi/prc[k-1];
                break;
            }
        }
      }
      res[M][n]=0.0;
   }

   output = fopen("strc_EIO.out","w");
   for(j=0;j<=M;j++) {
       fprintf(output,"%2.4lf\t\t",(double)j/M);
       for(n=0;n<=N;n++) {
           fprintf(output,"%2.4lf\t",res[j][n]);
       }
       fprintf(output,"\n");
   }
   fclose(output);    


}
