#include "tables.h"

double TANH(double x) {
  int i;
  double d;
  i = (int)(MAXPOINTS*(x - TAB0)/(TAB1-TAB0));
  if(i<0||i>=MAXPOINTS-1) {
    //    fprintf(stderr, "TANH: tabulation out of range");
    return((exp(x)-exp(-x))/(exp(x)+exp(-x)));
  }
  else {
    d = (TAB1-TAB0)/MAXPOINTS;
    return(tanhTAB[i]+(x - TAB0 - i*d)*(tanhTAB[i+1] - tanhTAB[i])/d);
  }
} 

double EXP(double x) {
  int i;
  double d;
  i = (int)(MAXPOINTS*(x - TAB0)/(TAB1-TAB0));
  if(i<0||i>=MAXPOINTS-1) {
    // fprintf(stderr, "EXP: tabulation out of range");
    return(exp(x));
  }
  else {
    d = (TAB1-TAB0)/MAXPOINTS;
    return(expTAB[i]+(x - TAB0 - i*d)*(expTAB[i+1] - expTAB[i])/d);
  }
} 

double THETA(double x) {
  int i;
  double d;
  i = (int)(MAXPOINTS*(x - TAB0)/(TAB1-TAB0));
  if(i<0||i>=MAXPOINTS-1) {
    // fprintf(stderr, "THETA: tabulation out of range");
    return((x==0) ? 0 : x/(1-exp(-x)));
  }
  else {
    d = (TAB1-TAB0)/MAXPOINTS;
    return(thetaTAB[i]+(x - TAB0 - i*d)*(thetaTAB[i+1] - thetaTAB[i])/d);
  }
} 

void makeTables() {
  int i;
  double x;
  for(i=0;i<MAXPOINTS;i++) {
    x = (TAB1-TAB0)*i/MAXPOINTS+TAB0;
    tanhTAB[i] = (exp(x)-exp(-x))/(exp(x)+exp(-x));
    expTAB[i] = exp(x);
    thetaTAB[i] = (x==0) ? 0 : x/(1-exp(-x));
  }
}

double rnd() {
  return((double)rand()/RAND_MAX);
}


double normalrnd() {
  int i;
  double s=0;
  int numberOfTrials = 50;
  for(i=0;i<numberOfTrials;i++) {
    s+=rnd();
  }
  return((s - 0.5*numberOfTrials)/sqrt(numberOfTrials/12));
}

