##Meta data!!! 

dataset_locations = [
    '/512/200/traub.h5',
    '/512/100/traub.h5',
    '/512/50/traub.h5',
    '/512/25/traub.h5',
    '/512/12_5/all/traub.h5',
    '/512/8/traub.h5',
    '/512/4/traub.h5',
    '/512/2/traub.h5',
    '/512/200_awake0/traub.h5',
    '/512/100_awake0/traub.h5',
    '/512/50_awake0/traub.h5',
    '/512/25_awake0/traub.h5',
    '/512/12_5_awake0/traub.h5',
    '/512/8_awake0/traub.h5',
    '/512/4_awake0/traub.h5',
    '/512/2_awake0/traub.h5',
    '/512/12_5/pop23_pyr/traub.h5',
    '/512/12_5/pop4/traub.h5',
    '/512/12_5/pop5_pyr/traub.h5',
    '/512/12_5/pop6_pyr/traub.h5',
    '/512/12_5/puste/traub.h5',
    '/512/12_5_uncor_02/traub.h5',
    '/512/kick/traub.h5',
    '/small_awake05/1/traub_syn.h5',
    '/small_awake05/2/traub_syn.h5',
    '/small_awake05/3/traub_syn.h5',
    '/small_awake05/4/traub_syn.h5',
    '/small_awake05/6/traub_syn.h5',
]

dataset_title = ['Oscillatory 200Hz', 
                 'Oscillatory 100Hz', 
                 'Oscillatory 50Hz', 
                 'Oscillatory 25Hz', 
                 'Oscillatory 12.5Hz', 
                 'Oscillatory 8Hz',
                 'Oscillatory 4Hz',
                 'Oscillatory 2Hz',
                 'Oscillatory 200Hz no depol',
                 'Oscillatory 100Hz no depol', 
                 'Oscillatory 50Hz no depol', 
                 'Oscillatory 25Hz no depol', 
                 'Oscillatory 12.5Hz no depol', 
                 'Oscillatory 8Hz no depol',
                 'Oscillatory 4Hz no depol',
                 'Oscillatory 2Hz no depol',
                 'Oscillatory 12.5Hz input pop23', 
                 'Oscillatory 12.5Hz input pop4',
                 'Oscillatory 12.5Hz input pop5',
                 'Oscillatory 12.5Hz input pop6',
                 'Oscillatory 12.5Hz no input',
                 'Oscillatory 12.5Hz input 20% of TCR',
                 'Whisker deflection',
                 'Whisker deflection 10% model',
                 'Whisker deflection passive currents',
                 'Whisker deflection passive soma & axon',
                 'Whisker deflection passive axon',
                 'Whisker deflection blocked Na current']


dataset_description = [
    'Size:100%; Stop(ms):700; Stim.Delay(ms):100; Stim.duration(ms):600; depol_tuft(nA):1; depol_nontuft(nA):0.75',
    'Size:100%; Stop(ms):700; Stim.Delay(ms):100; Stim.duration(ms):600; depol_tuft(nA):1; depol_nontuft(nA):0.75',
    'Size:100%; Stop(ms):700; Stim.Delay(ms):100; Stim.duration(ms):600; depol_tuft(nA):1; depol_nontuft(nA):0.75',
    'Size:100%; Stop(ms):700; Stim.Delay(ms):100; Stim.duration(ms):600; depol_tuft(nA):1; depol_nontuft(nA):0.75',
    'Size:100%; Stop(ms):690; Stim.Delay(ms):100; Stim.duration(ms):600; depol_tuft(nA):1; depol_nontuft(nA):0.75',
    'Size:100%; Stop(ms):700; Stim.Delay(ms):100; Stim.duration(ms):600; depol_tuft(nA):1; depol_nontuft(nA):0.75',
    'Size:100%; Stop(ms):700; Stim.Delay(ms):100; Stim.duration(ms):600; depol_tuft(nA):1; depol_nontuft(nA):0.75',
    'Size:100%; Stop(ms):700; Stim.Delay(ms):100; Stim.duration(ms):600; depol_tuft(nA):1; depol_nontuft(nA):0.75',
    'Size:100%; Stop(ms):700; Stim.Delay(ms):100; Stim.duration(ms):600; depol_tuft(nA):0; depol_nontuft(nA):0',
    'Size:100%; Stop(ms):700; Stim.Delay(ms):100; Stim.duration(ms):600; depol_tuft(nA):0; depol_nontuft(nA):0',
    'Size:100%; Stop(ms):700; Stim.Delay(ms):100; Stim.duration(ms):600; depol_tuft(nA):0; depol_nontuft(nA):0',
    'Size:100%; Stop(ms):700; Stim.Delay(ms):100; Stim.duration(ms):600; depol_tuft(nA):0; depol_nontuft(nA):0', 
    'Size:100%; Stop(ms):700; Stim.Delay(ms):100; Stim.duration(ms):600; depol_tuft(nA):0; depol_nontuft(nA):0',
    'Size:100%; Stop(ms):700; Stim.Delay(ms):100; Stim.duration(ms):600; depol_tuft(nA):0; depol_nontuft(nA):0',
    'Size:100%; Stop(ms):700; Stim.Delay(ms):100; Stim.duration(ms):600; depol_tuft(nA):0; depol_nontuft(nA):0',
    'Size:100%; Stop(ms):700; Stim.Delay(ms):100; Stim.duration(ms):600; depol_tuft(nA):0; depol_nontuft(nA):0',
    'Size:100%; Stop(ms):690; Stim.Delay(ms):100; Stim.duration(ms):600; depol_tuft(nA):1; depol_nontuft(nA):0.75',
    'Size:100%; Stop(ms):690; Stim.Delay(ms):100; Stim.duration(ms):600; depol_tuft(nA):1; depol_nontuft(nA):0.75',
    'Size:100%; Stop(ms):690; Stim.Delay(ms):100; Stim.duration(ms):600; depol_tuft(nA):1; depol_nontuft(nA):0.75',
    'Size:100%; Stop(ms):690; Stim.Delay(ms):100; Stim.duration(ms):600; depol_tuft(nA):1; depol_nontuft(nA):0.75',
    'Size:100%; Stop(ms):690; Stim.Delay(ms):100; Stim.duration(ms):600; depol_tuft(nA):1; depol_nontuft(nA):0.75',
    'Size:100%; Stop(ms):700; Stim.Delay(ms):100; Stim.duration(ms):600; depol_tuft(nA):1; depol_nontuft(nA):0.75',
    'Size:100%; Stop(ms):210; Stim.Delay(ms):70; Stim.duration(ms):2; depol_tuft(nA):1; depol_nontuft(nA):0.75', #### 23!
    'Size:10%; Stop(ms):600; Stim.Delay(ms):300; Stim.duration(ms):2; depol_tuft(nA):0.5; depol_nontuft(nA):0.375',
    'Size:10%; Stop(ms):600; Stim.Delay(ms):300; Stim.duration(ms):2; depol_tuft(nA):0.5; depol_nontuft(nA):0.375',
    'Size:10%; Stop(ms):600; Stim.Delay(ms):300; Stim.duration(ms):2; depol_tuft(nA):0.5; depol_nontuft(nA):0.375',
    'Size:10%; Stop(ms):600; Stim.Delay(ms):300; Stim.duration(ms):2; depol_tuft(nA):0.5; depol_nontuft(nA):0.375',
    'Size:10%; Stop(ms):600; Stim.Delay(ms):300; Stim.duration(ms):2; depol_tuft(nA):0.5; depol_nontuft(nA):0.375']
   
dataset_starttime = [
'2014-05-16 04:37',
'2014-05-15 12:53',
'2014-05-13 22:43',
'2014-05-20 12:48',
'2014-04-27 12:16',
'2014-05-22 02:21',
'2014-05-20 12:44',
'2014-05-20 12:51',
'2014-05-30 17:21',
'2014-05-30 14:00',
'2014-05-30 09:03',
'2014-05-30 04:07',
'2014-05-28 13:28',
'2014-05-29 23:19',
'2014-05-29 09:38',
'2014-05-28 15:50',
'2014-05-12 12:54',
'2014-04-30 23:09',
'2014-05-09 23:50',
'2014-05-09 11:07',
'2014-04-30 16:15',
'2014-06-04 14:24',
'2014-08-08 16:44',
'2014-07-28 11:19',
'2014-08-07 08:33',
'2014-08-05 08:13',
'2014-08-04 16:28',
'2014-08-06 16:26']

dataset_endtime = [
'2014-05-17 12:07',
'2014-05-16 21:24',
'2014-05-15 12:52',
'2014-05-22 01:19',
'2014-04-28 21:57',
'2014-05-23 06:52',
'2014-05-21 17:25',
'2014-05-21 18:13',
'2014-05-31 14:57',
'2014-05-31 14:24',
'2014-05-31 10:43',
'2014-05-31 04:33',
'2014-05-29 11:34',
'2014-05-30 18:53',
'2014-05-30 04:46',
'2014-05-29 10:23',
'2014-05-13 10:07',
'2014-05-01 14:03',
'2014-05-10 16:08',
'2014-05-09 23:48',
'2014-04-30 19:13',
'2014-06-05 17:00',
'2014-08-09 01:47',
'2014-07-28 23:29',
'2014-08-07 15:37',
'2014-08-05 15:55',
'2014-08-01 12:29',
'2014-08-06 23:53']

import h5py as h5
from time import strftime

def get_metadata(dataset_number):
    details_template = { 'title': dataset_title[dataset_number],
                         'description': dataset_description[dataset_number],
                         'creator' : 'Helena Glabska',
                         'contributor': 'Daniel Wojcik, Chaitanya Chintaluri',
                         'contact' : 'd.wojcik@nencki.gov.pl',
                         'created': strftime("%Y-%m-%d %H:%M:%S"),
                         'license' : 'ODbL 1.0',
                         'rights' : 'Copyright, Daniel K. Wojcik',
                         'tstart' : dataset_starttime[dataset_number],
                         'tend' : dataset_endtime[dataset_number],
                         'software' : 'Neuron 7.3, h5py',
                         'method' : 'CVODE, Crank-Nicholson, global dt',
                         'URL' : 'https://github.com/hglabska/Thalamocortical_imem',
                         'nsdf_version' : 1.0
                         }
    return details_template
                 

with open("ODbLv1_0.txt", "r") as myfile:
    license_ = myfile.read()
str_type = h5.new_vlen(str)

all_datasets = range(28)
all_datasets.remove(0)

for dataset_number in all_datasets:
    path = '/media/cchintaluri/ed1076b7-6eda-45b5-a12b-ec0b1b69dafa/hela_data/'
    dataset_path = dataset_locations[dataset_number]
    h = h5.File(path + dataset_path, 'a')

    #META DATA
    metadata_dict = get_metadata(dataset_number)
    for key, vals in metadata_dict.iteritems():
        h.attrs.create(key, vals)

    #LICENSE    
    ds = h.create_dataset('/model/filecontents/LICENSE', shape=(1,), dtype=str_type)
    ds[:] = license_

    #URL
    ds = h.create_dataset('/model/filecontents/url', shape=(1,), dtype=str_type)
    ds[:] = 'https://github.com/hglabska/Thalamocortical_imem'

    #README
    ds = h.create_dataset('/model/filecontents/README', shape=(1,), dtype=str_type)
    ds[:] = 'Copyright, Daniel K. Wojcik (d.wojcik@nencki.gov.pl)\n\n\n LICENSE: ODbL 1.0 license\n\n This dataset is made available under the Open Database License: http://opendatacommons.org/licenses/odbl/1.0/. Any rights in individual contents of the database are licensed under the Database Contents License: http://opendatacommons.org/licenses/dbcl/1.0/'

    h.close()
    print 'Finished', dataset_path
