/*********************************************************************
 * A specification for the data structure which contains information
 * about the simulation environment.
 * Mike True, 8/20/06
 *********************************************************************/

#ifndef STIMH
    #include "stimulus.h"
    #define STIMH 1
#endif

#include <stdio.h>
#include <stdlib.h>

#define MAX_STIMULI 20
#define MAX_STATES 20
#define MAX_REPORTS 20
#define MAX_FILENAME_SIZE 40
#define CELL_REPORTS_ENABLED 1

struct Param
{
    float simBegin;			        //simulation start time
    float simEnd;			        //simulation end time
    float dt;				        //simulation time step
    int iter;				        //number of steps per output dump
    int size;     			        //the size of cell array (an n x n grid)
    int stimNum;  			        //the number of stimuli
    Stimulus stimuli[MAX_STIMULI];  //the stimulus records
    float dd; 			            //the neighboring cell distance
    float Cm; 				        //the cell capacitance
    float D; 				        //diffusion coefficient

    char* inputFileName;		    //filename for input
    char* outputFileName;		    //filename for output
    char* logFileName;		        //filename for log

    char* stateFileName;            //The source state info file for all states
    FILE* stateFiles[MAX_STATES];   //File pointers for state files
    double stateTimes[MAX_STATES];  //The time for each state dump
    char* stateFileNames[MAX_STATES];//The output location for each state
    int useStateFile;               //A flag for states being turned on
    int stateNum;                   //The number of state files
    
    int loadFromState;              //A flag that indicates load from state
    char* loadStateFileName;        //The source state file to load from
    
    /* HA coefficients */ 
    double alphaX0;
    double alphaY0;
    double alphaZ0;
    
    double alphaY1;
    double alphaZ1;
    
    double alphaX2;
    double alphaY2;
    double alphaZ2;
    
    double alphaX3;
    double alphaY3;
    double alphaZ3;
    
    double vO;
    double vT;
    double vS;
    double vR;
    double vW;
    double rp;
    
    double initVX;
    double initVY;
    double initVZ;
    
    double guessUpstroke;
    double guessPlateau;
               
    #if CELL_REPORTS_ENABLED
    char* cellReportFileName;		//filename for cell reports
    int cellReportsOn;			    //whether to print reports
    int cellReportsX[MAX_REPORTS];  //xPos list of cells to report
    int cellReportsY[MAX_REPORTS];  //yPos list of cells to report
    char* cellReportFileNames[MAX_REPORTS];
    int reportNum;
    FILE* cellReportFiles[MAX_REPORTS];
    #endif
};

typedef struct Param Param;

/* Prototypes */

void readHACoefficients(Param *param, char *fileName);
void processCommandLineArgs(Param *param, char** argv, int argn);
void readParam(Param *param, FILE *fp);
void readCellReportInfo(Param *param, FILE* fp);
void readStateInfo(Param *param, FILE* fp);
