/*********************************************************************
 * A series of operations which handle the construction of the 
 * simulation environment from the given set of input files.
 * Mike True, 8/20/06
 *********************************************************************/

#ifndef PARAMH
    #include "param.h"
    #define PARAMH 1
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void processCommandLineArgs(Param *p, char** argv, int argn)
{
    int i;
    for(i=1; i<argn-1; i++)
    {
        if(strncmp(argv[i], "-i", 3) == 0)
	    {
	        i++;
            p->inputFileName = argv[i]; 
	    }
        else if(strncmp(argv[i], "-o", 3) == 0)
	    {
            i++;
            p->outputFileName = argv[i];
	    }
	    else if(strncmp(argv[i], "-l", 3) == 0)
	    {
            i++;
            p->logFileName = argv[i];     
        }
        /* This option specifies that the HA coefficients are to be read in */
        if(strncmp(argv[i], "-a", 3) == 0)
	    {
	        i++;
            readHACoefficients(p, argv[i]); 
	    }        
        #if CELL_REPORTS_ENABLED
	    else if(strncmp(argv[i], "-r", 3) == 0)
	    {
            i++;
            p->cellReportsOn = 1;
            p->cellReportFileName = argv[i];
	    }
	    #endif
    }
}

/* This function loads in HA coefficients from a file */
void readHACoefficients(Param *param, char *fileName)
{
    FILE *fp = fopen(fileName, "r");        
    if(fp == NULL)
    {
        return;
    }
    fscanf(fp, "%lf %lf %lf", &param->alphaX0, &param->alphaY0, &param->alphaZ0);
    fscanf(fp, "%lf %lf", &param->alphaY1, &param->alphaZ1);
    fscanf(fp, "%lf %lf %lf", &param->alphaX2, &param->alphaY2, &param->alphaZ2);
    fscanf(fp, "%lf %lf %lf", &param->alphaX3, &param->alphaY3, &param->alphaZ3);
    fscanf(fp, "%lf %lf %lf %lf %lf", &param->vO, &param->vT, &param->vS, 
      &param->vR, &param->rp);
    fscanf(fp, "%lf %lf %lf", &param->initVX, &param->initVY, &param->initVZ);        
}

/* This function reads in all of the basic parameter information */
void readParam(Param *param, FILE* fp)
{
    int i;
    //Read in all general information
    fscanf
	(
	    fp,
	    "%d %d %f %f %f %f %f %f %d", 
	    &param->size, 
	    &param->stimNum, 
	    &param->dd, 
	    &param->Cm, 
	    &param->D, 
	    &param->simBegin, 
	    &param->simEnd, 
	    &param->dt,
	    &param->iter
	);

    //Read in all information about a particular stimulus
    for(i=0;i<param->stimNum;i++)
	fscanf
	    (
		fp, 
		"%f  %f  %d %d  %d  %d  %f", 
		&param->stimuli[i].begin,
		&param->stimuli[i].end,
		&param->stimuli[i].upper,
		&param->stimuli[i].lower,
		&param->stimuli[i].left,
		&param->stimuli[i].right,
		&param->stimuli[i].amp
	    );
    #if CELL_REPORTS_ENABLED
    param->reportNum = 0;
    #endif
}

#if CELL_REPORTS_ENABLED
/* This function reads in all reports information */
void readCellReportInfo(Param *param, FILE* fp)
{
    int i=0, inv = 0;
    if(fp == NULL)
    {
        printf("Error while opening report data...\n");
        exit(1);
    }

    //Read in all general information
    fscanf
        (
            fp,
            "%d",
            &param->reportNum
        );
                
    for(i=0;i<param->reportNum;i++)
    {
        fscanf
            ( 
                fp,
                "%d %d",
                &param->cellReportsX[i-inv],
                &param->cellReportsY[i-inv]                
            );
        param->cellReportFileNames[i] =
          (char *)malloc(sizeof(char) * MAX_FILENAME_SIZE);
        fscanf   
            (
                fp,
                "%s",
                param->cellReportFileNames[i-inv]
            );

        if(param->cellReportsX[i-inv] < 0 || 
          param->cellReportsX[i-inv] >= param->size ||
          param->cellReportsY[i-inv] < 0 || 
          param->cellReportsY[i-inv] >= param->size)
	    {
            inv++;
	    }
        else
        {
            param->cellReportFiles[i-inv] = 
              fopen(param->cellReportFileNames[i-inv],
              "w");
        }
    }
    param->reportNum = param->reportNum - inv;
    fclose(fp);
}
#endif
