/*********************************************************************
 * An implementation of operations on event objects for our 
 * simulation.
 * Mike True, 8/20/06
 *********************************************************************/

#ifndef EVENTH
    #include "event.h"
    #define EVENTH 1
#endif

/* Create a new event */
Event* createEvent(int type, double time, Cell* cell)
{
    Event *newEvent;
    newEvent = (Event *)malloc(sizeof(Event));
    newEvent->type = type;
    newEvent->time = time;
    newEvent->cell = cell;
    newEvent->priority = NORMAL_PRIORITY;
    return newEvent;
}

/* Bring an event back from disk */
Event* importEvent(FILE *fp, Cell ***cells)
{
    Event *event = (Event *)malloc(sizeof(Event));
    int x, y, ty;
    double tm;
    /* Read in the cell coordinates (if necessary), type, and time */    
    fscanf(fp, "%d %d %d %lf\n", &x, &y,
      &ty, &tm); 
    if(ty == STATE_TRANSITION)
        event->cell = cells[x][y];
    else
        event->cell = NULL;
    event->type = ty;
    event->time = tm;
    return event;
}

/* Save an event back to disk */
void exportEvent(FILE *fp, Event *event)
{
    /* Output the x/y positions (if necessary), the type, and time */
    if(event->type == STATE_TRANSITION)
        fprintf(fp, "%d %d %d %f\n", event->cell->xPos, event->cell->yPos,
          event->type, event->time); 
    else
        fprintf(fp, "%d %d %d %f\n", -1, -1, event->type, event->time); 
}

/* A function used on a newly created event to augment it with stimulus info
   (if it is a stimulus event) */
void provideStimulusInfo(Event* ev, int left, int right, int top, int bot, 
  float amt)
{
    ev->priority = STIMULUS_PRIORITY;
    if(left > right)
    {
        int temp = right;
	right = left;
	left = temp;
    }
    ev->left = left;
    ev->right = right;
    ev->top = top;
    ev->bottom = bot;
    ev->amount = amt;
}
    
/* Destroy this event */
void destroyEvent(Event *event)
{
    free(event);
}
