/*********************************************************************
 * A specification for the data structure which contains information
 * about a given cell.
 * Mike True, 8/20/06
 *********************************************************************/

#ifndef PARAMH
    #include "param.h"
    #define PARAMH 1  
#endif

#define RESTING_STATE 0
#define STIMULATED_STATE 1
#define UPSTROKE_STATE 2
#define PLATEAU_STATE 3
#define ALPHA_X0 -0.025
#define ALPHA_Y0 -0.07
#define ALPHA_Z0 -0.2
#define ALPHA_Y1 -0.07
#define ALPHA_Z1 -0.2
#define ALPHA_X2 250
#define ALPHA_Y2 200
#define ALPHA_Z2 125
#define ALPHA_X3 -0.025
#define ALPHA_Y3 -0.07
#define ALPHA_Z3 -0.2
#define GUESS_2 0.01        //Newton approx, state 2
#define GUESS_3 78.2	    //Newton approx, state 3
#define ACCURACY 0.001	    //Newton variance
#define INIT_Vx_VAL 0
#define INIT_Vy_VAL 0
#define INIT_Vz_VAL 0
#define INIT_Vn_VAL 0
#define VT 30.0             //Threshold voltage of exictation
#define VO 120.0            //Overshoot voltage
#define VR 20.0             //The last voltage before excitation
#define VS 5e-4             //The voltage for stimulation
#define RP -80e-3           //The resting potential
#define VW -83.9e-3         //The wakeup/sleep threshold
#define ALERT_NEIGHBORS 1
#define PUT_TO_SLEEP 2
#define NO_ALERT 0
#define UPSTROKE_ALERT 4
#define ALLOW_CELLS_TO_SLEEP 0

struct Cell
{
    int state;
    int xPos;
    int yPos;
    double time_enter;
    double time_exit;
    double time_cur;
    double time_old;
    double Vx_old;
    double Vy_old;
    double Vz_old;
    double V_old;
    double Vx_cur;
    double Vy_cur;
    double Vz_cur;
    double V_cur;
    double Vn;
    double I_stim;
    int awake;
};

typedef struct Cell Cell;

/* Prototypes */

double newton(double, double, double, double, double, double, double, double);
void initializeParamWithDefaults(Param *p);
Cell* createCell(double creationTime, int x, int y, Param *p);
void destroyCell(Cell* cell);
double getVoltage(Cell* cell, double time);
double getCurrent(Cell *cell, Param *param);
int updateVoltage(Cell *cell, Cell *left, Cell *right, Cell *up, Cell *down, 
  Param *p, double time, FILE *log);
double updateState(Cell *cell, Param *p);
double beginUpstroke(Cell *cell, Param *p);
void putCellToSleep(Cell *cell);
int notifyCell(Cell *cell, double time, Param *p);

