/*********************************************************************
 * A specification for a min heap pri. queue where a lower time for an
 * event corresponds to a higher priority.
 * Mike True, 9/29/05
 *********************************************************************/

#ifndef EVENTH
    #include "event.h"
    #define EVENTH 1
#endif

struct Heap
{
    Event **heap;     /* The heap is an array of events */
    int size;         /* The number of events currently on the heap */
    int capacity;     /* The size of the array */
};

typedef struct Heap Heap;

/* Prototypes */

Heap* createHeap(int initCapacity);   
void destroyHeap(Heap *heap);
void expandHeap(Heap *heap, int newCapacity);
void insert(Heap *heap, Event *event);
Event* removeNext(Heap *heap);
double getNextTime(Heap *heap);
Heap* importHeap(FILE *fp, Cell ***cells);
void exportHeap(FILE *fp, Heap *heap);

