/*********************************************************************
 * A specification for a list of events that can vary in size.
 * Mike True, 8/20/06
 *********************************************************************/

#ifndef EVENTH
    #include "event.h"
    #define EVENTH 1
#endif

struct List
{
    Event **list;     /* The list is implemented by a circular array */
    int size;         /* The number of events on the list */
    int capacity;     /* The size of the array */
    int front;        /* The next element to be removed */
    int back;         /* The position before the next insert position */
    double time;      /* The time of all events on this list */
};

typedef struct List List;

/* Prototypes */

List* createList(int initCapacity);   
void destroyList(List *list);
void expandList(List *list, int newCapacity);
void addToTail(List *list, Event *event);
Event* removeFromHead(List *list);
double getTime(List *list);
void exportList(FILE *fp, List *list);
List* importList(FILE *fp, Cell ***cells);
