/*********************************************************************
 * An specialized version of a priority queue with one min-heap 
 * component and two linked-list components.  A lower time for an
 * event corresponds to a higher priority.
 * Mike True, 8/20/06
 *********************************************************************/

#ifndef EVENTH
    #include "event.h"
    #define EVENTH 1
#endif
#ifndef HEAPH
    #include "heap.h"
    #define HEAPH 1
#endif
#ifndef LISTH
    #include "list.h"
    #define LISTH 1
#endif

#define SOURCE_HEAP 0
#define SOURCE_LIST 1

struct Queue
{
    Heap *heap;          /* The heap component */
    List *now, *later;   /* The two list components */
    int listsEmpty;      /* A flag set if the lists are both empty */
    int nextSource;      /* A flag indicating the source of the next event */
};

typedef struct Queue Queue;

/* Prototypes */

Queue* createQueue(int initCapacity);   
void destroyQueue(Queue *queue);
void expandQueue(Queue *queue, int newCapacity);
void enqueue(Queue *queue, Event *event);
Event* dequeue(Queue *queue);
double peekNextTime(Queue *queue);
Queue* importQueue(FILE *fp, Cell ***cells);
void exportQueue(FILE *fp, Queue *queue);
