/*********************************************************************
 * A specification for the data structure which contains information
 * about a specific event.
 * Mike True, 8/20/06
 *********************************************************************/

#ifndef CELLH
    #include "cell.h"
    #define CELLH 1
#endif

#define STATE_TRANSITION 0
#define QUERY_NEIGHBORS 1
#define DUMP_AP_TO_FILE 2
#define STIMULUS_ON 3
#define STIMULUS_OFF 4
#define SAVE_SYSTEM_STATE 5
#define NORMAL_PRIORITY 0
#define STIMULUS_PRIORITY 1

struct Event
{
    int type;              /* The type of event */
    int priority;          /* The priority (the secondary Pri. Q criterion) */
    int stateNum;          /* The next state number (used for transitions) */
    double time;           /* The time (the primary Pri. Q criterion) */
    Cell *cell;            /* The cell this event applies to (if one exists) */

    /* Stimulus information */
    int left;
    int right;
    int top;
    int bottom;
    float amount;          /* The strength of the stimulus */
};

typedef struct Event Event;

/* Prototypes */

void provideStimulusInfo(Event* ev, int left, int right, int top, int bot, 
  float amt);
Event* createEvent(int type, double time, Cell* cell);
void destroyEvent(Event *event);
Event* importEvent(FILE *fp, Cell ***cells);
void exportEvent(FILE *fp, Event *event);
