/*********************************************************************
 * A specification for the data structure which contains information
 * about a given cell.
 * Mike True, 8/20/06
 *********************************************************************/

#ifndef PARAMH
    #include "param.h"
    #define PARAMH 1  
#endif

/* States */
#define RESTING_STATE 0
#define STIMULATED_STATE 1
#define UPSTROKE_STATE 2
#define PLATEAU_STATE 3
/* Constants */
#define ACCURACY 0.001	    //Newton variance
#define INIT_Vn_VAL 0
/* Alert Codes */
#define ALERT_NEIGHBORS 1
#define PUT_TO_SLEEP 2
#define NO_ALERT 0
#define UPSTROKE_ALERT 4
#define ALLOW_CELLS_TO_SLEEP 0
/* Default HA coefficient values */
#define ALPHA_X0 -0.025
#define ALPHA_Y0 -0.07
#define ALPHA_Z0 -0.2
#define ALPHA_Y1 -0.07
#define ALPHA_Z1 -0.2
#define ALPHA_X2 250
#define ALPHA_Y2 200
#define ALPHA_Z2 125
#define ALPHA_X3 -0.025
#define ALPHA_Y3 -0.07
#define ALPHA_Z3 -0.2
#define GUESS_2 0.01        //Newton approx, state 2
#define GUESS_3 78.2	    //Newton approx, state 3
#define INIT_Vx_VAL 0
#define INIT_Vy_VAL 0
#define INIT_Vz_VAL 0
#define VT 30.0             //Threshold voltage of exictation
#define VO 120.0            //Overshoot voltage
#define VR 20.0             //The last voltage before excitation
#define VS 5e-4             //The voltage for stimulation
#define RP -80e-3           //The resting potential
#define VW -83.9e-3         //The wakeup/sleep threshold

struct Cell
{
    int state;               //The current state
    int xPos;                //The x coordinate
    int yPos;                //The y coordinate
    double time_enter;       //Time a state is entered
    double time_exit;        //Time a state will be left
    double time_cur;         //Time for "current time step"
    double time_old;         //Time for "previous time step"
    double Vx_old;           //Previous Vx
    double Vy_old;           //Previous Vy
    double Vz_old;           //Previous Vz
    double V_old;            //Previous V
    double Vx_cur;           //Current Vx
    double Vy_cur;           //Current Vy
    double Vz_cur;           //Current Vz
    double V_cur;            //Current V
    double Vn;               //State memory element Vn
    double I_stim;           //Amount of external stimulus applied
    int awake;               //Flag for if cell is asleep/awake
};

typedef struct Cell Cell;

/* Prototypes */

double newton(double, double, double, double, double, double, double, double, 
  double, double);
Cell* createCell(double creationTime, int x, int y, Param *p);
void destroyCell(Cell* cell);
double getVoltage(Cell* cell, double time, Param *p);
double getCurrent(Cell *cell, Param *param);
int updateVoltage(Cell *cell, Cell *left, Cell *right, Cell *up, Cell *down, 
  Param *p, double time, FILE *log);
double updateState(Cell *cell, Param *p);
double beginUpstroke(Cell *cell, Param *p);
void putCellToSleep(Cell *cell);
int notifyCell(Cell *cell, double time, Param *p);
void exportCell(FILE *fp, Cell *cell);
Cell* importCell(FILE *fp);
void initializeParamWithDefaults(Param *p);

