// genesis
//
// 	Cell morphology file for GENESIS.
// 	Written by cvapp (http://www.neuro.soton.ac.uk/cells/#software).
// 	End of cvapp-generated header file.
// 	bg0121b_512.p 
//	Original version by Jesse Hanson
//	Soma size corrected 10/07/04 by J. Edgerton
// 	Axon hillock and nodes of ranvier added 06/25/2004 by J. Edgerton
//	Axon hillock & axon taken from Mitral Cell model,
//	Shen et al (1999), J Neurophysiol. 82: 3006-3020
// 	Axon initial segment divided into 20 segments 07/09/2004 by J. Edgerton.
// 	Dendritic diameter subdivisions added 09/30/2004 by J. Edgerton.
//	Each dendritic prototype now has 2 defining variables:
//		d = distance from soma, with segments as follows:
//			d0 = 0-25 microns from soma
//			d25 = >25 to 50 microns
//			d50 = >50 to 100 microns
//			all remaining divisions are 100 microns long, 
//				e.g. d100 means 100 < d <= 200 microns from soma.
//		dia = diameter rating:
//			dia0 = < 0.5 microns
//			dia1 = 0.5 to 1 micron
//			dia2 = > 1 micron
//			CaHVA density is scaled based on diameter rating according to
//				Hanson & Smith, 2002.
//			Once a dendrite crosses the line between two ratings, it cannot
//				go back to a higher rating again even if the diam thickens.
//			If a transition occurs for a short stretch but the majority of
//				the dendrite distal to that stretch is at the previous level, 
//				ignore the transition.
//			In cases where it is oscillating around a transition, make the
//				transition occur where the compartment and 3 of the next 4
//				are at the new level.

*absolute
*asymmetric
*cartesisan

*origin 0       0       0
*set_global RA       	{RA}
*set_global EREST_ACT   {EREST_ACT}

*set_compt_param RM	{RM_sd}
*set_compt_param CM	{CM}
*set_compt_param ELEAK	{ELEAK_sd}

*compt /library/GP_soma
soma            none            0       0       0      13.4 

*compt /library/GP_axHill
axHill		soma		5	0	0	4.75

*set_compt_param RM       	{RM_ax}
*set_compt_param ELEAK		{ELEAK_ax}

*compt /library/GP_axIS
axIS[0]		axHill		7	0	0	1.5
axIS[1]		axIS[0]		9	0	0	1.5
axIS[2]		axIS[1]		11	0	0	1.5
axIS[3]		axIS[2]		13	0	0	1.5
axIS[4]		axIS[3]		15	0	0	1.5
axIS[5]		axIS[4]		17	0	0	1.5
axIS[6]		axIS[5]		19	0	0	1.5
axIS[7]		axIS[6]		21	0	0	1.5
axIS[8]		axIS[7]		23	0	0	1.5
axIS[9]		axIS[8]		25	0	0	1.5

*set_compt_param RM       	{RM_my}
*set_compt_param CM       	{CM_my}

*compt /library/GP_axIN
axIN[0]		axIS[9]		0	75	0	1.5
axIN[1]		axIN[0]		0	125	0	1.5
axIN[2]		axIN[1]		0	175	0	1.5
axIN[3]		axIN[2]		0	225	0	1.5
axIN[4]		axIN[3]		0	275	0	1.5
axIN[5]		axIN[4]		0	325	0	1.5
axIN[6]		axIN[5]		0	375	0	1.5
axIN[7]		axIN[6]		0	425	0	1.5
axIN[8]		axIN[7]		0	475	0	1.5
axIN[9]		axIN[8]		0	525	0	1.5
axIN[10]	axIN[9]		0	575	0	1.5
axIN[11]	axIN[10]	0	625	0	1.5
axIN[12]	axIN[11]	0	675	0	1.5
axIN[13]	axIN[12]	0	725	0	1.5
axIN[14]	axIN[13]	0	775	0	1.5
axIN[15]	axIN[14]	0	825	0	1.5
axIN[16]	axIN[15]	0	875	0	1.5
axIN[17]	axIN[16]	0	925	0	1.5
axIN[18]	axIN[17]	0	975	0	1.5
axIN[19]	axIN[18]	0	1025	0	1.5

*set_compt_param RM       	{RM_ax}
*set_compt_param CM       	{CM}
*set_compt_param ELEAK		{ELEAK_ax}

*compt /library/GP_axNode
axNode[0]	axIN[19]	0	1026	0	1

*set_compt_param RM       	{RM_my}
*set_compt_param CM       	{CM_my}

*compt /library/GP_axIN
axIN[20]	axNode[0]	0	1076	0	1.5
axIN[21]	axIN[20]	0	1126	0	1.5
axIN[22]	axIN[21]	0	1176	0	1.5
axIN[23]	axIN[22]	0	1226	0	1.5
axIN[24]	axIN[23]	0	1276	0	1.5
axIN[25]	axIN[24]	0	1326	0	1.5
axIN[26]	axIN[25]	0	1376	0	1.5
axIN[27]	axIN[26]	0	1426	0	1.5
axIN[28]	axIN[27]	0	1476	0	1.5
axIN[29]	axIN[28]	0	1526	0	1.5
axIN[30]	axIN[29]	0	1576	0	1.5
axIN[31]	axIN[30]	0	1626	0	1.5
axIN[32]	axIN[31]	0	1676	0	1.5
axIN[33]	axIN[32]	0	1726	0	1.5
axIN[34]	axIN[33]	0	1776	0	1.5
axIN[35]	axIN[34]	0	1826	0	1.5
axIN[36]	axIN[35]	0	1876	0	1.5
axIN[37]	axIN[36]	0	1926	0	1.5
axIN[38]	axIN[37]	0	1976	0	1.5
axIN[39]	axIN[38]	0	2026	0	1.5

*set_compt_param RM       	{RM_ax}
*set_compt_param CM       	{CM}

*compt /library/GP_axNode
axNode[1]	axIN[39]	0	2027	0	1

*set_compt_param RM       	{RM_my}
*set_compt_param CM       	{CM_my}

*compt /library/GP_axIN
axIN[40]	axNode[1]	0	2077	0	1.5
axIN[41]	axIN[40]	0	2127	0	1.5
axIN[42]	axIN[41]	0	2177	0	1.5
axIN[43]	axIN[42]	0	2227	0	1.5
axIN[44]	axIN[43]	0	2277	0	1.5
axIN[45]	axIN[44]	0	2327	0	1.5
axIN[46]	axIN[45]	0	2377	0	1.5
axIN[47]	axIN[46]	0	2427	0	1.5
axIN[48]	axIN[47]	0	2477	0	1.5
axIN[49]	axIN[48]	0	2527	0	1.5
axIN[50]	axIN[49]	0	2577	0	1.5
axIN[51]	axIN[50]	0	2627	0	1.5
axIN[52]	axIN[51]	0	2677	0	1.5
axIN[53]	axIN[52]	0	2727	0	1.5
axIN[54]	axIN[53]	0	2777	0	1.5
axIN[55]	axIN[54]	0	2827	0	1.5
axIN[56]	axIN[55]	0	2877	0	1.5
axIN[57]	axIN[56]	0	2927	0	1.5
axIN[58]	axIN[57]	0	2977	0	1.5
axIN[59]	axIN[58]	0	3027	0	1.5


*set_compt_param RM       	{RM_sd}
*set_compt_param CM       	{CM}
*set_compt_param ELEAK		{ELEAK_sd}

*compt /library/GP_dendrite_d0_dia2
p0b1[0]  soma  -2.164  3.156  2.15  1.509 
p0b1[1]  p0b1[0]  -2.89  8.651  1.844  1.171 
p0b1[2]  p0b1[1]  -5.58  13.82  0.11  1.63 
p0b1b1[0]  p0b1[2]  -10.550  16.800  2.49  1.652 

*compt /library/GP_dendrite_d25_dia2
p0b1b1[1]  p0b1b1[0]  -16.862  18.715  2.826  1.297 
p0b1b1[2]  p0b1b1[1]  -23.522  20.919  2.95  1.221 
p0b1b1[3]  p0b1b1[2]  -29.799  21.653  2.95  1.262 
p0b1b1[4]  p0b1b1[3]  -35.144  24.473  4.105  1.199 

*compt /library/GP_dendrite_d50_dia2
p0b1b1[5]  p0b1b1[4]  -40.398  27.904  5.202  1.158 
p0b1b1[6]  p0b1b1[5]  -45.417  30.338  6.46  1.290 
p0b1b1[7]  p0b1b1[6]  -51.600  31.502  7.37  1.160 
p0b1b1[8]  p0b1b1[7]  -54.165  37.197  7.14  1.180 
p0b1b1[9]  p0b1b1[8]  -59.632  38.205  10.496  1.136 
p0b1b1[10]  p0b1b1[9]  -59.902  42.377  13.755  1.392 
p0b1b1[11]  p0b1b1[10]  -65.99  45.137  14.215  1.101 
p0b1b1[12]  p0b1b1[11]  -65.47  49.421  16.677  1.61 

*compt /library/GP_dendrite_d100_dia2
p0b1b1[13]  p0b1b1[12]  -70.93  48.260  20.64  1.05 
p0b1b1b1[0]  p0b1b1[13]  -74.625  53.181  22.527  1.271 
p0b1b1b1[1]  p0b1b1b1[0]  -78.664  56.606  24.95  1.276 
p0b1b1b1[2]  p0b1b1b1[1]  -81.540  57.736  28.636  1.545 
p0b1b1b1[3]  p0b1b1b1[2]  -85.700  56.330  30.96  1.4 
p0b1b1b2[0]  p0b1b1[13]  -77.543  48.943  22.942  1.059 

*compt /library/GP_dendrite_d100_dia1
p0b1b1b2[1]  p0b1b1b2[0]  -84.100  48.49  22.79  0.973 
p0b1b1b2[2]  p0b1b1b2[1]  -90.572  47.570  22.79  0.950 
p0b1b1b2[3]  p0b1b1b2[2]  -95.289  43.154  21.791  0.95 
p0b1b1b2[4]  p0b1b1b2[3]  -100.975  39.78  21.43  0.938 
p0b1b1b2[5]  p0b1b1b2[4]  -105.545  35.900  21.89  1.033 
p0b1b1b2[6]  p0b1b1b2[5]  -111.319  32.895  22.11  0.953 
p0b1b1b2[7]  p0b1b1b2[6]  -116.184  29.498  22.11  1.047 
p0b1b1b2[8]  p0b1b1b2[7]  -121.402  26.774  21.684  1.052 
p0b1b1b2[9]  p0b1b1b2[8]  -126.901  23.089  21.411  0.937 
p0b1b1b2[10]  p0b1b1b2[9]  -132.324  19.310  21.21  0.939 
p0b1b1b2[11]  p0b1b1b2[10]  -135.107  13.876  21.317  1.017 
p0b1b1b2[12]  p0b1b1b2[11]  -138.196  8.418  21.55  0.99 
p0b1b1b2[13]  p0b1b1b2[12]  -142.983  4.904  21.852  1.044 
p0b1b1b2[14]  p0b1b1b2[13]  -145.091  -0.731  21.851  1.032 

*compt /library/GP_dendrite_d200_dia1
p0b1b1b2[15]  p0b1b1b2[14]  -146.516  -6.828  22.11  0.991 
p0b1b1b2[16]  p0b1b1b2[15]  -147.968  -13.197  22.602  0.948 
p0b1b1b2[17]  p0b1b1b2[16]  -151.076  -18.352  23.25  1.026 
p0b1b1b2[18]  p0b1b1b2[17]  -154.931  -23.492  23.25  0.967 
p0b1b1b2[19]  p0b1b1b2[18]  -160.660  -25.861  23.461  1.001 
p0b1b1b2[20]  p0b1b1b2[19]  -165.020  -29.822  24.38  1.042 
p0b1b1b2[21]  p0b1b1b2[20]  -169.760  -34.21  24.38  0.93 
p0b1b1b2b1[0]  p0b1b1b2[21]  -173.421  -38.819  25.4  0.959 
p0b1b1b2b1[1]  p0b1b1b2b1[0]  -176.887  -43.812  25.4  0.942 
p0b1b1b2b1[2]  p0b1b1b2b1[1]  -180.839  -48.327  25.825  0.952 
p0b1b1b2b1[3]  p0b1b1b2b1[2]  -183.955  -53.538  26.42  0.939 
p0b1b1b2b1[4]  p0b1b1b2b1[3]  -186.913  -58.742  26.42  0.957 
p0b1b1b2b1[5]  p0b1b1b2b1[4]  -190.13  -63.717  25.97  0.964 
p0b1b1b2b1[6]  p0b1b1b2b1[5]  -191.188  -68.522  23.964  1.078 
p0b1b1b2b1[7]  p0b1b1b2b1[6]  -191.689  -74.279  24.057  0.991 
p0b1b1b2b1[8]  p0b1b1b2b1[7]  -195.065  -79.128  24.065  0.969 

*compt /library/GP_dendrite_d300_dia1
p0b1b1b2b1[9]  p0b1b1b2b1[8]  -197.09  -84.670  22.91  0.93 
p0b1b1b2b1b1[0]  p0b1b1b2b1[9]  -199.016  -89.514  21.763  1.208 
p0b1b1b2b1b1[1]  p0b1b1b2b1b1[0]  -198.679  -92.996  21.061  1.467 
p0b1b1b2b1b1[2]  p0b1b1b2b1b1[1]  -201.62  -96.190  23.47  1.16 
p0b1b1b2b1b1b1[0]  p0b1b1b2b1b1[2]  -198.907  -96.838  23.262  1.468 
p0b1b1b2b1b1b1[1]  p0b1b1b2b1b1b1[0]  -195.81  -97.110  23.25  0.93 
p0b1b1b2b1b1b2[0]  p0b1b1b2b1b1[2]  -199.485  -100.524  23.59  0.931 
p0b1b1b2b1b1b2[1]  p0b1b1b2b1b1b2[0]  -197.44  -103.100  20.3  0.93 
p0b1b1b2b1b2[0]  p0b1b1b2b1[9]  -201.007  -89.205  23.13  0.932 
p0b1b1b2b1b2[1]  p0b1b1b2b1b2[0]  -205.265  -92.302  22.86  0.868 
p0b1b1b2b1b2[2]  p0b1b1b2b1b2[1]  -208.956  -96.415  21.693  0.81 
p0b1b1b2b1b2[3]  p0b1b1b2b1b2[2]  -212.291  -100.495  21.015  0.861 
p0b1b1b2b1b2[4]  p0b1b1b2b1b2[3]  -214.41  -105.520  21.09  0.81 

*compt /library/GP_dendrite_d200_dia1
p0b1b1b2b2[0]  p0b1b1b2[21]  -173.756  -35.194  27.78  0.708 
p0b1b1b2b2[1]  p0b1b1b2b2[0]  -178.890  -35.31  27.809  0.736 
p0b1b1b2b2[2]  p0b1b1b2b2[1]  -181.804  -38.933  29.705  0.753 
p0b1b1b2b2[3]  p0b1b1b2b2[2]  -184.476  -43.097  30.28  0.759 
p0b1b1b2b2[4]  p0b1b1b2b2[3]  -185.227  -48.154  31.845  0.707 
p0b1b1b2b2[5]  p0b1b1b2b2[4]  -185.766  -53.088  33.294  0.731 
p0b1b1b2b2[6]  p0b1b1b2b2[5]  -183.879  -55.252  37.391  0.755 
p0b1b1b2b2[7]  p0b1b1b2b2[6]  -181.714  -57.604  38.44  1.123 
p0b1b1b2b2[8]  p0b1b1b2b2[7]  -181.034  -62.890  38.761  0.708 
p0b1b1b2b2[9]  p0b1b1b2b2[8]  -181.62  -67.51  36.97  0.7 

*compt /library/GP_dendrite_d0_dia1
p0b1b2[0]  p0b1[2]  -4.42  18.910  4.076  0.948 

*compt /library/GP_dendrite_d25_dia1
p0b1b2[1]  p0b1b2[0]  -3.346  24.763  3.074  1.030 
p0b1b2[2]  p0b1b2[1]  -3.262  30.215  4.885  1.082 
p0b1b2[3]  p0b1b2[2]  1.433  34.773  4.464  0.948 
p0b1b2[4]  p0b1b2[3]  3.415  40.376  3.97  1.042 

*compt /library/GP_dendrite_d50_dia1
p0b1b2[5]  p0b1b2[4]  4.905  46.199  3.97  1.034 
p0b1b2[6]  p0b1b2[5]  5.871  52.731  3.97  0.941 
p0b1b2[7]  p0b1b2[6]  6.228  58.958  3.899  0.996 
p0b1b2[8]  p0b1b2[7]  6.260  65.419  3.86  0.962 
p0b1b2[9]  p0b1b2[8]  8.888  71.094  2.897  0.982 
p0b1b2[10]  p0b1b2[9]  11.998  76.390  2.72  1.012 
p0b1b2[11]  p0b1b2[10]  13.182  82.192  3.97  1.027 
p0b1b2[12]  p0b1b2[11]  15.779  88.085  3.97  0.965 

*compt /library/GP_dendrite_d100_dia1
p0b1b2[13]  p0b1b2[12]  19.707  93.466  3.97  0.933 
p0b1b2[14]  p0b1b2[13]  23.264  98.863  4.35  0.911 
p0b1b2[15]  p0b1b2[14]  27.077  103.624  5.56  0.812 
p0b1b2[16]  p0b1b2[15]  29.437  109.229  5.904  0.83 
p0b1b2[17]  p0b1b2[16]  31.186  114.556  8.387  0.824 
p0b1b2[18]  p0b1b2[17]  34.381  119.236  10.024  0.730 

*compt /library/GP_dendrite_d100_dia0
p0b1b2[19]  p0b1b2[18]  36.198  122.971  7.82  0.49 
p0b1b2[20]  p0b1b2[19]  38.421  126.413  7.82  0.350 
p0b1b2[21]  p0b1b2[20]  40.941  129.605  7.82  0.353 
p0b1b2[22]  p0b1b2[21]  43.763  132.574  7.82  0.350 
p0b1b2[23]  p0b1b2[22]  46.291  135.776  7.664  0.352 
p0b1b2[24]  p0b1b2[23]  48.419  139.212  6.973  0.350 
p0b1b2[25]  p0b1b2[24]  50.453  142.622  5.965  0.350 
p0b1b2[26]  p0b1b2[25]  52.456  146.022  4.853  0.350 
p0b1b2[27]  p0b1b2[26]  53.797  149.705  3.875  0.355 
p0b1b2[28]  p0b1b2[27]  55.234  153.392  2.95  0.353 
p0b1b2[29]  p0b1b2[28]  57.504  156.807  2.95  0.350 
p0b1b2[30]  p0b1b2[29]  59.241  160.481  2.788  0.353 
p0b1b2[31]  p0b1b2[30]  60.577  164.286  2.048  0.35 
p0b1b2[32]  p0b1b2[31]  62.116  168.006  1.47  0.353 
p0b1b2[33]  p0b1b2[32]  64.386  171.421  1.47  0.350 

*compt /library/GP_dendrite_d200_dia0
p0b1b2[34]  p0b1b2[33]  65.69  174.280  -0.91  0.35 

*compt /library/GP_dendrite_d0_dia2
p1[1]  soma  -5.188  -6.596  -0.171  1.525 
p1[2]  p1[1]  -10.893  -12.319  0.450  1.423 
p1[3]  p1[2]  -18.294  -14.638  0.450  1.465 

*compt /library/GP_dendrite_d25_dia2
p1[4]  p1[3]  -24.459  -16.889  1.180  1.527 
p1[5]  p1[4]  -30.7  -16.113  1.360  1.603 
p1[6]  p1[5]  -36.806  -19.34  1.360  1.460 

*compt /library/GP_dendrite_d50_dia2
p1[7]  p1[6]  -44.182  -19.099  1.360  1.366 
p1[8]  p1[7]  -51.035  -20.545  2.150  1.431 
p1[9]  p1[8]  -57.481  -23.147  2.150  1.451 
p1[10]  p1[9]  -64.150  -22.440  2.150  1.504 
p1[11]  p1[10]  -70.297  -24.102  2.150  1.584 
p1[12]  p1[11]  -77.466  -26.739  2.150  1.320 
p1[13]  p1[12]  -82.637  -31.131  2.150  1.486 

*compt /library/GP_dendrite_d100_dia2
p1[14]  p1[13]  -90.04  -31.91  2.150  1.355 
p1[15]  p1[14]  -96.083  -31.653  6.383  1.366 
p1[16]  p1[15]  -102.519  -32.347  10.06  1.355 
p1[17]  p1[16]  -109.879  -32.672  10.624  1.365 
p1[18]  p1[17]  -115.712  -35.766  9.886  1.518 
p1[19]  p1[18]  -120.568  -40.77  11  1.428 
p1[20]  p1[19]  -127.003  -42.281  11.367  1.523 
p1[21]  p1[20]  -133.200  -46.65  12.263  1.321 
p1[22]  p1[21]  -140.68  -46.254  13.27  1.334 
p1[23]  p1[22]  -147.9  -49.19  13.720  1.28 
p1b1[0]  p1[23]  -154.606  -50.064  14.510  1.388 
p1b1[1]  p1b1[0]  -160.500  -50.568  15.530  1.422 
p1b1[2]  p1b1[1]  -165.259  -51.609  18.951  1.244 
p1b1[3]  p1b1[2]  -171.390  -51.95  20.98  1.05 
p1b1b1[0]  p1b1[3]  -169.65  -54.6  23.02  1.05 
p1b1b2[0]  p1b1[3]  -175.395  -52.154  26.135  1.092 

*compt /library/GP_dendrite_d200_dia2
p1b1b2[1]  p1b1b2[0]  -176.525  -56.085  31.037  1.117 
p1b1b2[2]  p1b1b2[1]  -180.978  -60.238  33.064  1.111 
p1b1b2[3]  p1b1b2[2]  -178.284  -63.763  36.037  1.335 
p1b1b2[4]  p1b1b2[3]  -182.574  -65.914  37.31  1.063 
p1b1b2[5]  p1b1b2[4]  -182.170  -69.732  35.634  1.153 
p1b1b2[6]  p1b1b2[5]  -184.930  -73.761  38.67  0.840 
p1b1b2[7]  p1b1b2[6]  -189.064  -74.220  40.37  1.46 
p1b1b2[8]  p1b1b2[7]  -187.641  -76.937  44.79  0.971 
p1b1b2[9]  p1b1b2[8]  -192.576  -76.348  47.511  1.448 
p1b1b2[10]  p1b1b2[9]  -195.201  -77.298  54.442  1.608 
p1b1b2[11]  p1b1b2[10]  -199.358  -76.457  57.72  2.042 
p1b1b2[12]  p1b1b2[11]  -200.525  -78.994  62.779  1.234 
p1b1b2[13]  p1b1b2[12]  -205.201  -80.113  63.755  1.415 

*compt /library/GP_dendrite_d200_dia1
p1b1b2[14]  p1b1b2[13]  -209.3  -81.440  67.47  0.81 
p1b1b2b1[0]  p1b1b2[14]  -214.466  -82.499  67.59  0.843 
p1b1b2b1[1]  p1b1b2b1[0]  -219.268  -82.872  67.838  0.738 
p1b1b2b1[2]  p1b1b2b1[1]  -221.390  -82.820  70.53  0.47 
p1b1b2b2[0]  p1b1b2[14]  -205.128  -81.405  67.462  0.472 
p1b1b2b2[1]  p1b1b2b2[0]  -201.993  -82.552  68.423  0.567 
p1b1b2b2[2]  p1b1b2b2[1]  -200.492  -85.685  70.686  0.517 
p1b1b2b2[3]  p1b1b2b2[2]  -203.37  -87.89  73.03  1.16 

*compt /library/GP_dendrite_d100_dia1
p1b2[0]  p1[23]  -152.013  -50.735  16.827  0.723 
p1b2[1]  p1b2[0]  -155.114  -53.972  19.417  0.751 
p1b2[2]  p1b2[1]  -158.165  -57.432  20.718  0.811 
p1b2[3]  p1b2[2]  -163.127  -58.774  22.061  0.732 
p1b2[4]  p1b2[3]  -166.194  -61.86  21.307  0.881 
p1b2[5]  p1b2[4]  -171.258  -62.003  22.359  0.745 

*compt /library/GP_dendrite_d200_dia1
p1b2[6]  p1b2[5]  -174.184  -65.814  22.68  0.562 
p1b2[7]  p1b2[6]  -176.169  -69.165  23.86  0.526 
p1b2[8]  p1b2[7]  -176.324  -73.605  23.111  0.475 
p1b2[9]  p1b2[8]  -177.025  -77.422  24.286  0.528 
p1b2[10]  p1b2[9]  -179.190  -79.259  21.458  0.534 

*compt /library/GP_dendrite_d200_dia0
p1b2[11]  p1b2[10]  -181.884  -82.878  21.66  0.474 
p1b2[12]  p1b2[11]  -180.694  -86.546  23.357  0.508 
p1b2[13]  p1b2[12]  -181.16  -91.12  22.91  0.47 
p1b2b1[0]  p1b2[13]  -179.470  -94.604  25.060  0.494 
p1b2b1[1]  p1b2b1[0]  -178.49  -99.108  25.060  0.474 
p1b2b1[2]  p1b2b1[1]  -175.394  -101.228  25.060  0.583 
p1b2b1[3]  p1b2b1[2]  -173.302  -105.299  25.060  0.478 
p1b2b1[4]  p1b2b1[3]  -170.892  -108.679  25.060  0.527 
p1b2b1[5]  p1b2b1[4]  -167.59  -111.931  25.060  0.472 
p1b2b1[6]  p1b2b1[5]  -163.25  -113.7  25.060  0.47 
p1b2b1b1[0]  p1b2b1[6]  -159.055  -114.444  24.157  0.47 
p1b2b1b1[1]  p1b2b1b1[0]  -155  -114.73  22.68  0.47 
p1b2b1b2[0]  p1b2b1[6]  -164.935  -117.031  25.494  0.47 
p1b2b1b2[1]  p1b2b1b2[0]  -167.124  -120.049  25.630  0.473 
p1b2b1b2[2]  p1b2b1b2[1]  -168.326  -123.508  25.630  0.482 
p1b2b1b2[3]  p1b2b1b2[2]  -167.56  -127.06  25.85  0.47 
p1b2b2[0]  p1b2[13]  -182.837  -93.227  23.619  0.761 
p1b2b2[1]  p1b2b2[0]  -183.721  -97.250  25.462  0.470 
p1b2b2[2]  p1b2b2[1]  -184.605  -101.516  26.19  0.480 
p1b2b2[3]  p1b2b2[2]  -187.143  -105.113  26.19  0.482 
p1b2b2[4]  p1b2b2[3]  -191.129  -107.158  26.19  0.473 
p1b2b2[5]  p1b2b2[4]  -195.299  -108.665  26.19  0.478 
p1b2b2[6]  p1b2b2[5]  -199.506  -110.153  26.462  0.474 
p1b2b2[7]  p1b2b2[6]  -203.443  -112.1  27.351  0.473 
p1b2b2[8]  p1b2b2[7]  -207.221  -114.151  28.721  0.47 
p1b2b2[9]  p1b2b2[8]  -211.059  -116.252  29.824  0.470 
p1b2b2[10]  p1b2b2[9]  -214.293  -117.257  30.05  0.3 
p1b2b2[11]  p1b2b2[10]  -217.37  -117.963  30.05  0.230 
p1b2b2[12]  p1b2b2[11]  -220.468  -118.251  30.126  0.233 
p1b2b2[13]  p1b2b2[12]  -223.02  -119.46  31.640  0.23 

*compt /library/GP_dendrite_d0_dia2
p2b2[0]  soma  -0.527  -7.066  4.6  2.31 
p2b2[1]  p2b2[0]  -8.486  -9.719  7.37  2.117 

*compt /library/GP_dendrite_d25_dia2
p2b2[2]  p2b2[1]  -11.100  -18.706  7.37  1.898 
p2b2[3]  p2b2[2]  -17.084  -24.616  10.824  1.954 
p2b2[4]  p2b2[3]  -22.79  -28.831  13.933  2.294 

*compt /library/GP_dendrite_d50_dia2
p2b2[5]  p2b2[4]  -28.201  -35.646  14.096  2.041 
p2b2[6]  p2b2[5]  -35.417  -40.649  15.128  2.01 
p2b2b1[1]  p2b2[6]  -41.143  -45.404  17.69  1.521 
p2b2b1[2]  p2b2b1[1]  -47.975  -48.083  19.113  1.540 
p2b2b1[3]  p2b2b1[2]  -52.448  -54.357  20.237  1.479 

*compt /library/GP_dendrite_d50_dia1
p2b2b1b1[1]  p2b2b1[3]  -58.443  -55.077  20.528  0.714 
p2b2b1b1[2]  p2b2b1b1[1]  -62.497  -58.221  22.622  0.734 

*compt /library/GP_dendrite_d100_dia1
p2b2b1b1[3]  p2b2b1b1[2]  -67.402  -59.498  24.176  0.768 
p2b2b1b1[4]  p2b2b1b1[3]  -72.917  -59.141  24.879  0.730 
p2b2b1b1[5]  p2b2b1b1[4]  -78.197  -59.905  25.858  0.750 
p2b2b1b1[6]  p2b2b1b1[5]  -82.361  -58.419  27.900  0.835 
p2b2b1b1[7]  p2b2b1b1[6]  -86.497  -56.798  28.24  0.913 
p2b2b1b1[8]  p2b2b1b1[7]  -90.298  -58.285  30.758  0.848 
p2b2b1b1[9]  p2b2b1b1[8]  -95.58  -57.529  31.376  0.758 
p2b2b1b1[10]  p2b2b1b1[9]  -100.301  -56.599  33.434  0.777 
p2b2b1b1[11]  p2b2b1b1[10]  -104.675  -56.359  36.433  0.766 
p2b2b1b1[12]  p2b2b1b1[11]  -109.042  -56.024  37.760  0.737 

*compt /library/GP_dendrite_d100_dia0
p2b2b1b1[13]  p2b2b1b1[12]  -113.518  -55.787  37.760  0.43 
p2b2b1b1[14]  p2b2b1b1[13]  -115.608  -55.083  39.299  0.535 
p2b2b1b1[15]  p2b2b1b1[14]  -118.87  -55.274  39.92  0.433 
p2b2b1b1[16]  p2b2b1b1[15]  -122.790  -56.506  39.92  0.350 
p2b2b1b1[17]  p2b2b1b1[16]  -126.215  -54.612  39.92  0.368 
p2b2b1b1[18]  p2b2b1b1[17]  -130.197  -53.779  40.333  0.352 
p2b2b1b1[19]  p2b2b1b1[18]  -134.170  -53.078  41.116  0.35 
p2b2b1b1[20]  p2b2b1b1[19]  -138.156  -52.391  41.812  0.350 
p2b2b1b1[21]  p2b2b1b1[20]  -141.646  -50.702  42.07  0.370 
p2b2b1b1[22]  p2b2b1b1[21]  -145.285  -49.357  42.07  0.371 
p2b2b1b1[23]  p2b2b1b1[22]  -149.204  -48.686  42.164  0.362 
p2b2b1b1[24]  p2b2b1b1[23]  -153.166  -48.288  42.300  0.361 
p2b2b1b1[25]  p2b2b1b1[24]  -156.848  -46.532  42.300  0.353 

*compt /library/GP_dendrite_d200_dia0
p2b2b1b1[26]  p2b2b1b1[25]  -160.661  -45.011  42.300  0.350 
p2b2b1b1[27]  p2b2b1b1[26]  -163.395  -42.374  42.300  0.379 
p2b2b1b1[28]  p2b2b1b1[27]  -166.579  -39.8  42.241  0.351 
p2b2b1b1[29]  p2b2b1b1[28]  -169.191  -36.659  41.784  0.350 
p2b2b1b1[30]  p2b2b1b1[29]  -171.856  -33.631  41.730  0.357 
p2b2b1b1[31]  p2b2b1b1[30]  -174.551  -31.204  41.730  0.397 
p2b2b1b1[32]  p2b2b1b1[31]  -178.4  -30.180  41.730  0.361 
p2b2b1b1[33]  p2b2b1b1[32]  -180.03  -28.065  44.265  0.391 
p2b2b1b1[34]  p2b2b1b1[33]  -182.078  -26.858  47.476  0.360 
p2b2b1b1[35]  p2b2b1b1[34]  -184.348  -25.145  49.900  0.385 
p2b2b1b1[36]  p2b2b1b1[35]  -187.841  -23.464  49.588  0.37 
p2b2b1b1[37]  p2b2b1b1[36]  -191.39  -21.411  49.56  0.351 
p2b2b1b1[38]  p2b2b1b1[37]  -194.493  -18.798  49.268  0.354 
p2b2b1b1[39]  p2b2b1b1[38]  -197.497  -16.039  48.764  0.35 
p2b2b1b1[40]  p2b2b1b1[39]  -198.912  -12.225  48.760  0.354 
p2b2b1b1[41]  p2b2b1b1[40]  -201.962  -9.611  48.760  0.358 
p2b2b1b1[42]  p2b2b1b1[41]  -203.981  -6.530  50.094  0.367 
p2b2b1b1[43]  p2b2b1b1[42]  -205.454  -3.164  51.923  0.350 
p2b2b1b1[44]  p2b2b1b1[43]  -206.078  0.634  52.937  0.361 
p2b2b1b1[45]  p2b2b1b1[44]  -207.392  4.151  54.608  0.35 
p2b2b1b1[46]  p2b2b1b1[45]  -207.279  7.482  57.27  0.35 

*compt /library/GP_dendrite_d50_dia2
p2b2b1b2[0]  p2b2b1[3]  -57.530  -60.259  20.3  1.478 
p2b2b1b2[1]  p2b2b1b2[0]  -60.92  -67.469  20.3  1.445 

*compt /library/GP_dendrite_d100_dia2
p2b2b1b2[2]  p2b2b1b2[1]  -65.461  -73.955  20.3  1.454 
p2b2b1b2[3]  p2b2b1b2[2]  -71.229  -79.695  20.3  1.415 
p2b2b1b2[4]  p2b2b1b2[3]  -75.012  -86.453  21.084  1.479 
p2b2b1b2[5]  p2b2b1b2[4]  -78.557  -93.442  22.45  1.447 
p2b2b1b2[6]  p2b2b1b2[5]  -78.580  -99.197  25.86  1.721 
p2b2b1b2[7]  p2b2b1b2[6]  -83.244  -104.525  26.88  1.61 
p2b2b1b2[8]  p2b2b1b2[7]  -90.885  -106.792  27.953  1.432 

*compt /library/GP_dendrite_d100_dia1
p2b2b1b2b1[1]  p2b2b1b2[8]  -94.173  -112.577  32.09  0.741 
p2b2b1b2b1[2]  p2b2b1b2b1[1]  -93.253  -118.673  32.09  0.803 
p2b2b1b2b1[3]  p2b2b1b2b1[2]  -92.058  -124.386  32.09  0.871 
p2b2b1b2b1[4]  p2b2b1b2b1[3]  -95.129  -127.883  34.812  0.769 
p2b2b1b2b1[5]  p2b2b1b2b1[4]  -94.186  -133.585  35.5  0.702 
p2b2b1b2b1[6]  p2b2b1b2b1[5]  -93.839  -139.263  35.5  0.718 
p2b2b1b2b1[7]  p2b2b1b2b1[6]  -94.247  -143.845  36.005  0.883 

*compt /library/GP_dendrite_d200_dia1
p2b2b1b2b1[8]  p2b2b1b2b1[7]  -92.942  -148.417  38.220  0.779 
p2b2b1b2b1[9]  p2b2b1b2b1[8]  -93.439  -154.118  38.330  0.714 
p2b2b1b2b1[10]  p2b2b1b2b1[9]  -93.792  -159.276  38.330  0.790 
p2b2b1b2b1[11]  p2b2b1b2b1[10]  -91.912  -163.898  38.631  0.817 
p2b2b1b2b1[12]  p2b2b1b2b1[11]  -91.598  -169.455  38.900  0.733 
p2b2b1b2b1[13]  p2b2b1b2b1[12]  -89.172  -174.687  38.900  0.709 
p2b2b1b2b1[14]  p2b2b1b2b1[13]  -87.541  -180.111  38.983  0.721 
p2b2b1b2b1[15]  p2b2b1b2b1[14]  -85.883  -185.525  39.35  0.720 
p2b2b1b2b1[16]  p2b2b1b2b1[15]  -88.857  -190.548  39.353  0.700 
p2b2b1b2b1[17]  p2b2b1b2b1[16]  -91.282  -195.672  40.746  0.7 
p2b2b1b2b1[18]  p2b2b1b2b1[17]  -93.515  -200.901  41.368  0.714 
p2b2b1b2b1[19]  p2b2b1b2b1[18]  -95.999  -206.053  42.159  0.708 
p2b2b1b2b1[20]  p2b2b1b2b1[19]  -99.239  -210.790  42.817  0.707 
p2b2b1b2b1[21]  p2b2b1b2b1[20]  -103.107  -215.02  43.924  0.7 
p2b2b1b2b1[22]  p2b2b1b2b1[21]  -106.783  -219.324  44.68  0.715 
p2b2b1b2b1[23]  p2b2b1b2b1[22]  -109.097  -224.452  45.844  0.711 
p2b2b1b2b1[24]  p2b2b1b2b1[23]  -110.068  -230.06  46.557  0.712 
p2b2b1b2b1[25]  p2b2b1b2b1[24]  -110.084  -235.740  46.658  0.719 

*compt /library/GP_dendrite_d300_dia1
p2b2b1b2b1[26]  p2b2b1b2b1[25]  -110.279  -241.395  47.548  0.713 
p2b2b1b2b1[27]  p2b2b1b2b1[26]  -110.718  -247.100  48.146  0.710 
p2b2b1b2b1[28]  p2b2b1b2b1[27]  -110.812  -252.910  48.322  0.703 
p2b2b1b2b1[29]  p2b2b1b2b1[28]  -111.409  -258.680  48.977  0.7 
p2b2b1b2b1[30]  p2b2b1b2b1[29]  -112.851  -264.315  49.1  0.702 
p2b2b1b2b1[31]  p2b2b1b2b1[30]  -112.991  -270.083  49.1  0.708 
p2b2b1b2b1[32]  p2b2b1b2b1[31]  -112.515  -275.819  48.421  0.705 
p2b2b1b2b1[33]  p2b2b1b2b1[32]  -112.009  -281.464  47.32  0.708 
p2b2b1b2b1[34]  p2b2b1b2b1[33]  -112.206  -287.088  48.869  0.700 
p2b2b1b2b1[35]  p2b2b1b2b1[34]  -113.272  -292.385  50.983  0.704 
p2b2b1b2b1[36]  p2b2b1b2b1[35]  -112.804  -297.743  51.540  0.623 
p2b2b1b2b1[37]  p2b2b1b2b1[36]  -112.770  -302.805  51.6  0.560 
p2b2b1b2b1[38]  p2b2b1b2b1[37]  -113.228  -307.527  51.6  0.474 
p2b2b1b2b1[39]  p2b2b1b2b1[38]  -112.102  -311.512  51.658  0.543 
p2b2b1b2b1[40]  p2b2b1b2b1[39]  -112.479  -315.103  50.339  0.585 

*compt /library/GP_dendrite_d300_dia0
p2b2b1b2b1[41]  p2b2b1b2b1[40]  -113.854  -319.685  50.28  0.470 
p2b2b1b2b1[42]  p2b2b1b2b1[41]  -115.246  -324.035  50.24  0.435 
p2b2b1b2b1[43]  p2b2b1b2b1[42]  -116.632  -327.921  50.24  0.350 
p2b2b1b2b1[44]  p2b2b1b2b1[43]  -117.664  -331.918  50.24  0.35 

*compt /library/GP_dendrite_d400_dia0
p2b2b1b2b1[45]  p2b2b1b2b1[44]  -119.175  -335.684  49.520  0.351 
p2b2b1b2b1[46]  p2b2b1b2b1[45]  -120.209  -339.656  49.079  0.35 
p2b2b1b2b1[47]  p2b2b1b2b1[46]  -121.242  -343.628  48.638  0.35 
p2b2b1b2b1[48]  p2b2b1b2b1[47]  -121.244  -347.554  47.922  0.362 
p2b2b1b2b1[49]  p2b2b1b2b1[48]  -121.084  -351.515  47.400  0.361 
p2b2b1b2b1[50]  p2b2b1b2b1[49]  -121.917  -355.557  47.400  0.350 
p2b2b1b2b1[51]  p2b2b1b2b1[50]  -122.947  -359.554  47.400  0.35 
p2b2b1b2b1[52]  p2b2b1b2b1[51]  -122.719  -363.338  47.996  0.376 
p2b2b1b2b1[53]  p2b2b1b2b1[52]  -123.075  -367.248  47.524  0.365 
p2b2b1b2b1[54]  p2b2b1b2b1[53]  -124.028  -371.208  46.969  0.352 
p2b2b1b2b1[55]  p2b2b1b2b1[54]  -125.273  -375.137  46.754  0.350 
p2b2b1b2b1[56]  p2b2b1b2b1[55]  -126.548  -379.052  46.458  0.350 
p2b2b1b2b1[57]  p2b2b1b2b1[56]  -127.829  -382.963  46.146  0.350 
p2b2b1b2b1[58]  p2b2b1b2b1[57]  -130.480  -385.880  46.04  0.366 
p2b2b1b2b1[59]  p2b2b1b2b1[58]  -133.578  -388.530  46.04  0.354 
p2b2b1b2b1[60]  p2b2b1b2b1[59]  -136.143  -391.676  46.04  0.356 
p2b2b1b2b1[61]  p2b2b1b2b1[60]  -138.645  -394.888  45.904  0.355 
p2b2b1b2b1[62]  p2b2b1b2b1[61]  -141.438  -397.924  45.81  0.350 
p2b2b1b2b1[63]  p2b2b1b2b1[62]  -144.235  -400.959  45.81  0.35 
p2b2b1b2b1[64]  p2b2b1b2b1[63]  -147.033  -403.994  45.81  0.35 
p2b2b1b2b1[65]  p2b2b1b2b1[64]  -149.830  -407.029  45.81  0.350 
p2b2b1b2b1[66]  p2b2b1b2b1[65]  -153.504  -408.883  45.81  0.351 
p2b2b1b2b1[67]  p2b2b1b2b1[66]  -157.001  -411.052  45.81  0.351 
p2b2b1b2b1[68]  p2b2b1b2b1[67]  -160.251  -413.502  45.81  0.355 
p2b2b1b2b1[69]  p2b2b1b2b1[68]  -163.266  -416.321  45.81  0.350 

*compt /library/GP_dendrite_d500_dia0
p2b2b1b2b1[70]  p2b2b1b2b1[69]  -166.132  -419.269  45.81  0.351 
p2b2b1b2b1[71]  p2b2b1b2b1[70]  -168.498  -422.652  45.81  0.350 
p2b2b1b2b1[72]  p2b2b1b2b1[71]  -169.920  -425.503  46.971  0.247 
p2b2b1b2b1[73]  p2b2b1b2b1[72]  -171.239  -428.295  48.259  0.23 
p2b2b1b2b1[74]  p2b2b1b2b1[73]  -172.736  -431.276  48.31  0.231 
p2b2b1b2b1[75]  p2b2b1b2b1[74]  -175.184  -433.515  48.31  0.232 
p2b2b1b2b1[76]  p2b2b1b2b1[75]  -177.756  -435.655  48.31  0.23 
p2b2b1b2b1[77]  p2b2b1b2b1[76]  -179.491  -437.910  49.531  0.249 
p2b2b1b2b1[78]  p2b2b1b2b1[77]  -180.624  -440.245  51.632  0.230 
p2b2b1b2b1[79]  p2b2b1b2b1[78]  -181.687  -443.227  52.715  0.230 
p2b2b1b2b1[80]  p2b2b1b2b1[79]  -182.75  -446.21  53.798  0.230 
p2b2b1b2b1[81]  p2b2b1b2b1[80]  -184.192  -448.796  55.68  0.23 

*compt /library/GP_dendrite_d100_dia2
p2b2b1b2b2[0]  p2b2b1b2[8]  -94.316  -112.956  30.73  1.672 

*compt /library/GP_dendrite_d100_dia0
p2b2b1b2b2b1[1]  p2b2b1b2b2[0]  -99.376  -115.429  33.055  0.497 
p2b2b1b2b2b1[2]  p2b2b1b2b2b1[1]  -103.505  -115.767  34.838  0.495 
p2b2b1b2b2b1[3]  p2b2b1b2b2b1[2]  -107.752  -117.719  35.38  0.474 
p2b2b1b2b2b1[4]  p2b2b1b2b2b1[3]  -112.018  -119.801  35.38  0.470 
p2b2b1b2b2b1[5]  p2b2b1b2b2b1[4]  -116.408  -120.421  35.38  0.503 
p2b2b1b2b2b1[6]  p2b2b1b2b2b1[5]  -121.123  -120.593  35.381  0.473 
p2b2b1b2b2b1[7]  p2b2b1b2b2b1[6]  -125.323  -119.864  37.468  0.470 

*compt /library/GP_dendrite_d200_dia0
p2b2b1b2b2b1[8]  p2b2b1b2b2b1[7]  -129.553  -119.962  39.306  0.484 
p2b2b1b2b2b1[9]  p2b2b1b2b2b1[8]  -134.112  -119.908  39.800  0.486 
p2b2b1b2b2b1[10]  p2b2b1b2b2b1[9]  -137.641  -122.987  40.279  0.474 
p2b2b1b2b2b1[11]  p2b2b1b2b2b1[10]  -141.132  -126.164  40.773  0.470 
p2b2b1b2b2b1[12]  p2b2b1b2b2b1[11]  -145.378  -127.967  41.620  0.476 
p2b2b1b2b2b1[13]  p2b2b1b2b2b1[12]  -149.493  -129.969  41.620  0.488 
p2b2b1b2b2b1[14]  p2b2b1b2b2b1[13]  -153.357  -132.380  41.821  0.489 
p2b2b1b2b2b1[15]  p2b2b1b2b2b1[14]  -157.251  -134.193  42.388  0.515 
p2b2b1b2b2b1[16]  p2b2b1b2b2b1[15]  -161.322  -135.382  43.772  0.500 
p2b2b1b2b2b1[17]  p2b2b1b2b2b1[16]  -165.671  -136.374  44.112  0.499 
p2b2b1b2b2b1[18]  p2b2b1b2b2b1[17]  -169.975  -137.761  44.34  0.493 
p2b2b1b2b2b1[19]  p2b2b1b2b2b1[18]  -173.498  -140.417  45.979  0.474 
p2b2b1b2b2b1[20]  p2b2b1b2b2b1[19]  -177.195  -142.262  46.49  0.386 
p2b2b1b2b2b1[21]  p2b2b1b2b2b1[20]  -180.909  -143.749  46.49  0.358 
p2b2b1b2b2b1[22]  p2b2b1b2b2b1[21]  -183.893  -146.357  46.643  0.361 
p2b2b1b2b2b1[23]  p2b2b1b2b2b1[22]  -187.216  -145.685  48.760  0.359 
p2b2b1b2b2b1[24]  p2b2b1b2b2b1[23]  -191.058  -144.752  49.56  0.355 
p2b2b1b2b2b1[25]  p2b2b1b2b2b1[24]  -195.014  -144.875  49.095  0.36 
p2b2b1b2b2b1[26]  p2b2b1b2b2b1[25]  -198.377  -145.391  48.012  0.402 
p2b2b1b2b2b1[27]  p2b2b1b2b2b1[26]  -201.186  -145.334  50.339  0.393 
p2b2b1b2b2b1[28]  p2b2b1b2b2b1[27]  -204.926  -146.865  50.580  0.354 
p2b2b1b2b2b1[29]  p2b2b1b2b2b1[28]  -206.999  -146.694  53.603  0.391 
p2b2b1b2b2b1[30]  p2b2b1b2b2b1[29]  -209.930  -147.085  55.935  0.381 
p2b2b1b2b2b1[31]  p2b2b1b2b2b1[30]  -213.263  -146.177  57.102  0.393 

*compt /library/GP_dendrite_d300_dia0
p2b2b1b2b2b1[32]  p2b2b1b2b2b1[31]  -216.069  -146.188  58.874  0.432 
p2b2b1b2b2b1[33]  p2b2b1b2b2b1[32]  -217.715  -143.648  59.378  0.467 
p2b2b1b2b2b1[34]  p2b2b1b2b2b1[33]  -220.412  -141.674  61.920  0.35 

*compt /library/GP_dendrite_d100_dia2
p2b2b1b2b2b2[0]  p2b2b1b2b2[0]  -100.548  -113.826  30.73  1.586 
p2b2b1b2b2b2[1]  p2b2b1b2b2b2[0]  -106.141  -113.702  30.73  1.608 
p2b2b1b2b2b2[2]  p2b2b1b2b2b2[1]  -110.707  -115.492  28.914  1.192 

*compt /library/GP_dendrite_d100_dia1
p2b2b1b2b2b2[3]  p2b2b1b2b2b2[2]  -112.73  -121.157  26.481  0.961 
p2b2b1b2b2b2[4]  p2b2b1b2b2b2[3]  -113.429  -127.57  25.202  0.948 
p2b2b1b2b2b2[5]  p2b2b1b2b2b2[4]  -113.641  -133.978  23.7  0.947 

*compt /library/GP_dendrite_d200_dia1
p2b2b1b2b2b2[6]  p2b2b1b2b2b2[5]  -113.57  -140.039  22.410  1.006 
p2b2b1b2b2b2[7]  p2b2b1b2b2b2[6]  -117.591  -145.044  20.710  0.939 
p2b2b1b2b2b2[8]  p2b2b1b2b2b2[7]  -119.127  -150.944  18.840  0.978 
p2b2b1b2b2b2[9]  p2b2b1b2b2b2[8]  -120.621  -148.084  17.99  1.391 
p2b2b1b2b2b2[10]  p2b2b1b2b2b2[9]  -122.092  -152.204  16.044  0.850 
p2b2b1b2b2b2[11]  p2b2b1b2b2b2[10]  -124.486  -157.161  14.74  0.72 
p2b2b1b2b2b2[12]  p2b2b1b2b2b2[11]  -125.415  -162.201  12.920  0.748 
p2b2b1b2b2b2[13]  p2b2b1b2b2b2[12]  -122.703  -165.349  11.135  0.953 
p2b2b1b2b2b2b1[1]  p2b2b1b2b2b2[13]  -127.655  -167.444  10.318  0.741 
p2b2b1b2b2b2b1[2]  p2b2b1b2b2b2b1[1]  -132.591  -169.290  10.09  0.758 
p2b2b1b2b2b2b1[3]  p2b2b1b2b2b2b1[2]  -136.002  -173.192  10.09  0.630 
p2b2b1b2b2b2b1[4]  p2b2b1b2b2b2b1[3]  -135.475  -177.786  10.09  0.476 
p2b2b1b2b2b2b1[5]  p2b2b1b2b2b2b1[4]  -135.261  -182.216  10.09  0.496 
p2b2b1b2b2b2b1[6]  p2b2b1b2b2b2b1[5]  -136.772  -186.415  10.110  0.493 
p2b2b1b2b2b2b1[7]  p2b2b1b2b2b2b1[6]  -138.728  -189.897  12.367  0.479 
p2b2b1b2b2b2b1[8]  p2b2b1b2b2b2b1[7]  -140.24  -192.021  16.1  0.47 
p2b2b1b2b2b2b2[0]  p2b2b1b2b2b2[13]  -120.870  -170.290  9.87  0.885 
p2b2b1b2b2b2b2[1]  p2b2b1b2b2b2b2[0]  -120.185  -174.850  8.05  0.821 
p2b2b1b2b2b2b2[2]  p2b2b1b2b2b2b2[1]  -119.885  -179.439  7.463  0.878 
p2b2b1b2b2b2b2[3]  p2b2b1b2b2b2b2[2]  -122.701  -184.331  6.366  0.708 
p2b2b1b2b2b2b2[4]  p2b2b1b2b2b2b2[3]  -122.179  -189.559  6.24  0.775 
p2b2b1b2b2b2b2[5]  p2b2b1b2b2b2b2[4]  -119.875  -194.376  6.24  0.762 
p2b2b1b2b2b2b2[6]  p2b2b1b2b2b2b2[5]  -116.219  -197.384  6.24  0.86 
p2b2b1b2b2b2b2[7]  p2b2b1b2b2b2b2[6]  -113.127  -202.029  6.24  0.73 
p2b2b1b2b2b2b2[8]  p2b2b1b2b2b2b2[7]  -107.621  -203.792  6.24  0.704 
p2b2b1b2b2b2b2b1[1]  p2b2b1b2b2b2b2[8]  -105.537  -209.149  6.946  0.702 

*compt /library/GP_dendrite_d300_dia1
p2b2b1b2b2b2b2b1[2]  p2b2b1b2b2b2b2b1[1]  -105.346  -214.524  7.264  0.721 
p2b2b1b2b2b2b2b1[3]  p2b2b1b2b2b2b2b1[2]  -104.508  -219.340  8.426  0.774 
p2b2b1b2b2b2b2b1[4]  p2b2b1b2b2b2b2b1[3]  -101.635  -223.317  9.446  0.776 
p2b2b1b2b2b2b2b1[5]  p2b2b1b2b2b2b2b1[4]  -100.607  -228.565  9.446  0.7 

*compt /library/GP_dendrite_d200_dia1
p2b2b1b2b2b2b2b2[0]  p2b2b1b2b2b2b2[8]  -102.713  -205.995  6.836  0.752 

*compt /library/GP_dendrite_d300_dia1
p2b2b1b2b2b2b2b2[1]  p2b2b1b2b2b2b2b2[0]  -97.184  -206.408  7.94  0.963 
p2b2b1b2b2b2b2b2[2]  p2b2b1b2b2b2b2b2[1]  -91.632  -207.037  9.98  0.7 

*compt /library/GP_dendrite_d50_dia2
p2b2b2[0]  p2b2[6]  -36.507  -48.577  15.2  2.031 
p2b2b2[1]  p2b2b2[0]  -35.646  -56.650  17.115  1.558 
p2b2b2[2]  p2b2b2[1]  -32.293  -63.418  18.26  1.441 
p2b2b2[3]  p2b2b2[2]  -32.15  -69.894  20.211  1.499 
p2b2b2[4]  p2b2b2[3]  -30.789  -76.382  20.75  1.525 

*compt /library/GP_dendrite_d100_dia2
p2b2b2[5]  p2b2b2[4]  -27.104  -82.122  21.508  1.478 
p2b2b2[6]  p2b2b2[5]  -29.293  -87.860  23.357  1.581 
p2b2b2[7]  p2b2b2[6]  -28.396  -95.204  24.04  1.365 
p2b2b2[8]  p2b2b2[7]  -26.51  -102.395  25.349  1.344 
p2b2b2[9]  p2b2b2[8]  -27.726  -109.29  26.859  1.416 
p2b2b2[10]  p2b2b2[9]  -27.605  -116.684  28.8  1.327 
p2b2b2[11]  p2b2b2[10]  -28.075  -122.783  30.185  1.444 
p2b2b2[12]  p2b2b2[11]  -29.641  -127.521  32.043  1.415 
p2b2b2[13]  p2b2b2[12]  -28.43  -133.648  33.969  1.153 
p2b2b2[14]  p2b2b2[13]  -27.393  -138.516  36.013  1.401 
p2b2b2[15]  p2b2b2[14]  -24.211  -144.246  38.781  1.059 
p2b2b2[16]  p2b2b2[15]  -25.582  -150.508  40.750  1.124 
p2b2b2[17]  p2b2b2[16]  -29.340  -156.248  42.07  1.079 
p2b2b2[18]  p2b2b2[17]  -28.102  -162.68  43.350  1.129 
p2b2b2[19]  p2b2b2[18]  -26.547  -169.105  43.825  1.137 

*compt /library/GP_dendrite_d200_dia2
p2b2b2[20]  p2b2b2[19]  -23.539  -174.417  44.910  1.02 

*compt /library/GP_dendrite_d200_dia1
p2b2b2[21]  p2b2b2[20]  -21.734  -179.959  46.021  0.861 
p2b2b2[22]  p2b2b2[21]  -19.465  -185.242  47.646  0.854 
p2b2b2[23]  p2b2b2[22]  -16.195  -190.504  47.74  0.824 
p2b2b2[24]  p2b2b2[23]  -11.088  -194.021  47.74  0.823 
p2b2b2[25]  p2b2b2[24]  -7.248  -198.444  47.74  0.872 
p2b2b2[26]  p2b2b2[25]  -4.688  -203.511  47.202  0.895 
p2b2b2[27]  p2b2b2[26]  -2.719  -208.878  46.95  0.744 
p2b2b2[28]  p2b2b2[27]  -3.085  -214.162  45.223  0.736 
p2b2b2[29]  p2b2b2[28]  -4.591  -219.316  42.928  0.702 
p2b2b2[30]  p2b2b2[29]  -3.475  -223.931  40.14  0.745 
p2b2b2[31]  p2b2b2[30]  -1.05  -228.673  39.154  0.757 
p2b2b2[32]  p2b2b2[31]  -0.430  -233.461  36.521  0.746 
p2b2b2[33]  p2b2b2[32]  0.734  -236.48  33.122  0.874 
p2b2b2[34]  p2b2b2[33]  -0.529  -241.232  31.41  0.788 
p2b2b2[35]  p2b2b2[34]  -1.695  -245.720  29.389  0.811 
p2b2b2[36]  p2b2b2[35]  1.139  -248.379  26.422  0.839 

*compt /library/GP_dendrite_d300_dia1
p2b2b2[37]  p2b2b2[36]  3.564  -252.715  24.602  0.775 
p2b2b2[38]  p2b2b2[37]  2.738  -254.964  22.842  1.38 
p2b2b2[39]  p2b2b2[38]  6.517  -258.771  21.433  0.74 
p2b2b2[40]  p2b2b2[39]  5.964  -262.538  18.113  0.812 
p2b2b2[41]  p2b2b2[40]  7.904  -266.727  16.278  0.826 
p2b2b2[42]  p2b2b2[41]  12.849  -266.807  13.821  0.743 
p2b2b2[43]  p2b2b2[42]  12.468  -271.823  12.168  0.775 
p2b2b2[44]  p2b2b2[43]  12.857  -276.770  10.633  0.79 
p2b2b2[45]  p2b2b2[44]  11.660  -280.928  8.465  0.847 
p2b2b2[46]  p2b2b2[45]  8.677  -284.504  5.796  0.764 
p2b2b2b1[1]  p2b2b2[46]  7.040  -289.626  5.031  0.76 
p2b2b2b1[2]  p2b2b2b1[1]  8.393  -294.782  4.519  0.736 
p2b2b2b1[3]  p2b2b2b1[2]  7.067  -299.541  3.269  0.773 
p2b2b2b1[4]  p2b2b2b1[3]  7.530  -305.043  2.646  0.709 
p2b2b2b1[5]  p2b2b2b1[4]  6.188  -310.420  2.029  0.707 
p2b2b2b1[6]  p2b2b2b1[5]  7.258  -315.650  1.388  0.733 
p2b2b2b1[7]  p2b2b2b1[6]  6.148  -320.92  0.55  0.723 
p2b2b2b1[8]  p2b2b2b1[7]  8.562  -323.887  0.209  1.026 
p2b2b2b1[9]  p2b2b2b1[8]  10.016  -327.829  -1.484  0.87 
p2b2b2b1[10]  p2b2b2b1[9]  11.194  -330.72  -6.038  0.714 

*compt /library/GP_dendrite_d400_dia1
p2b2b2b1b1[1]  p2b2b2b1[10]  12.910  -332.171  -6.286  0.644 
p2b2b2b1b1[2]  p2b2b2b1b1[1]  15.783  -333.712  -6.889  0.436 
p2b2b2b1b1[3]  p2b2b2b1b1[2]  19.914  -333.482  -6.889  0.35 
p2b2b2b1b2[0]  p2b2b2b1[10]  11.144  -335.342  -6.319  0.851 
p2b2b2b1b2[1]  p2b2b2b1b2[0]  15.789  -334.998  -8.569  0.762 
p2b2b2b1b2[2]  p2b2b2b1b2[1]  19.368  -332.005  -9.465  0.829 
p2b2b2b1b2[3]  p2b2b2b1b2[2]  24.641  -333.836  -9.771  0.705 
p2b2b2b1b2[4]  p2b2b2b1b2[3]  26.314  -337.874  -10.833  0.876 
p2b2b2b1b2[5]  p2b2b2b1b2[4]  25.882  -340.065  -13.061  1.233 
p2b2b2b1b2[6]  p2b2b2b1b2[5]  25.525  -343.450  -13.061  0.35 

*compt /library/GP_dendrite_d300_dia1
p2b2b2b2[0]  p2b2b2[46]  8.352  -289.611  5.089  0.820 
p2b2b2b2[1]  p2b2b2b2[0]  3.345  -292.604  4.760  1.117 
p2b2b2b2[2]  p2b2b2b2[1]  0.759  -297.051  4.760  0.618 
p2b2b2b2[3]  p2b2b2b2[2]  -2.293  -299.725  2.267  0.65 
p2b2b2b2[4]  p2b2b2b2[3]  -5.165  -299.424  -0.68  0.75 
p2b2b2b2[5]  p2b2b2b2[4]  -6.495  -295.602  -2.031  0.725 
p2b2b2b2[6]  p2b2b2b2[5]  -11.081  -297.877  -2.95  0.595 
p2b2b2b2[7]  p2b2b2b2[6]  -15.658  -300.440  -2.96  0.59 
p2b2b2b2[8]  p2b2b2b2[7]  -20.535  -302.324  -3.4  0.59 
p2b2b2b2[9]  p2b2b2b2[8]  -23.356  -305.914  -4.125  0.669 

*compt /library/GP_dendrite_d400_dia1
p2b2b2b2[10]  p2b2b2b2[9]  -27.992  -308.283  -4.19  0.594 
p2b2b2b2[11]  p2b2b2b2[10]  -31.354  -307.22  -0.910  0.642 
p2b2b2b2[12]  p2b2b2b2[11]  -36.662  -306.998  -0.539  0.581 
p2b2b2b2[13]  p2b2b2b2[12]  -41.675  -306.578  -0.092  0.613 
p2b2b2b2[14]  p2b2b2b2[13]  -46.514  -307.765  0.032  0.621 
p2b2b2b2[15]  p2b2b2b2[14]  -50.208  -310.281  1.020  0.676 
p2b2b2b2[16]  p2b2b2b2[15]  -55.066  -312.197  1.343  0.591 
p2b2b2b2[17]  p2b2b2b2[16]  -60.142  -313.437  2.125  0.586 
p2b2b2b2[18]  p2b2b2b2[17]  -65.361  -314.173  2.284  0.587

*compt /library/GP_dendrite_d400_dia0
p2b2b2b2[19]  p2b2b2b2[18]  -68.209  -315.390  4.464  0.370 
p2b2b2b2[20]  p2b2b2b2[19]  -70.958  -315.883  5.67  0.254 
p2b2b2b2[21]  p2b2b2b2[20]  -73.775  -317.572  5.67  0.235 
p2b2b2b2[22]  p2b2b2b2[21]  -77.32  -318.28  5.67  0.23 
