// 	genesis
//
// 	Cell morphology file for GENESIS.
// 	Written by cvapp (http://www.neuro.soton.ac.uk/cells/#software).
//
//	GP4 = cell BG0123A
// 	Axon hillock and nodes of ranvier added 06/25/2004 by J. Edgerton
//	Axon hillock & axon taken from Mitral Cell model,
//	Shen et al (1999), J Neurophysiol. 82: 3006-3020
// 	Axon initial segment divided into 20 segments 07/09/2004 by J. Edgerton.
// 	Dendritic diameter subdivisions added 09/30/2004 by J. Edgerton.
//	Each dendritic prototype now has 2 defining variables:
//		d = distance from soma, with segments as follows:
//			d0 = 0-25 microns from soma
//			d25 = >25 to 50 microns
//			d50 = >50 to 100 microns
//			all remaining divisions are 100 microns long, 
//				e.g. d100 means 100 < d <= 200 microns from soma.
//		dia = diameter rating:
//			dia0 = < 0.5 microns
//			dia1 = 0.5 to 1 micron
//			dia2 = > 1 micron
//			CaHVA density is scaled based on diameter rating according to
//				Hanson & Smith, 2002.
//			Once a dendrite crosses the line between two ratings, it cannot
//				go back to a higher rating again even if the diam thickens.
//			If a transition occurs for a short stretch but the majority of
//				the dendrite distal to that stretch is at the previous level, 
//				ignore the transition.
//			In cases where it is oscillating around a transition, make the
//				transition occur where the compartment and 3 of the next 4
//				are at the new level.

*absolute
*asymmetric
*cartesisan

*lambda_warn .001 .01 --> check electrotonic lengths

*origin 0       0       0
*set_global RA       	{RA}
*set_global EREST_ACT   {EREST_ACT}

*set_compt_param RM	{RM_sd}
*set_compt_param CM	{CM}
*set_compt_param ELEAK	{ELEAK_sd}

*compt /library/GP_soma
soma  none    0  0  0  9.6 

*compt /library/GP_axHill
axHill		soma		5	0	0	4.75

*set_compt_param RM       	{RM_ax}
*set_compt_param ELEAK		{ELEAK_ax}

*compt /library/GP_axIS
axIS[0]		axHill		7	0	0	1.5
axIS[1]		axIS[0]		9	0	0	1.5
axIS[2]		axIS[1]		11	0	0	1.5
axIS[3]		axIS[2]		13	0	0	1.5
axIS[4]		axIS[3]		15	0	0	1.5
axIS[5]		axIS[4]		17	0	0	1.5
axIS[6]		axIS[5]		19	0	0	1.5
axIS[7]		axIS[6]		21	0	0	1.5
axIS[8]		axIS[7]		23	0	0	1.5
axIS[9]		axIS[8]		25	0	0	1.5

*set_compt_param RM       	{RM_my}
*set_compt_param CM       	{CM_my}

*compt /library/GP_axIN
axIN[0]		axIS[9]		0	75	0	1.5
axIN[1]		axIN[0]		0	125	0	1.5
axIN[2]		axIN[1]		0	175	0	1.5
axIN[3]		axIN[2]		0	225	0	1.5
axIN[4]		axIN[3]		0	275	0	1.5
axIN[5]		axIN[4]		0	325	0	1.5
axIN[6]		axIN[5]		0	375	0	1.5
axIN[7]		axIN[6]		0	425	0	1.5
axIN[8]		axIN[7]		0	475	0	1.5
axIN[9]		axIN[8]		0	525	0	1.5
axIN[10]	axIN[9]		0	575	0	1.5
axIN[11]	axIN[10]	0	625	0	1.5
axIN[12]	axIN[11]	0	675	0	1.5
axIN[13]	axIN[12]	0	725	0	1.5
axIN[14]	axIN[13]	0	775	0	1.5
axIN[15]	axIN[14]	0	825	0	1.5
axIN[16]	axIN[15]	0	875	0	1.5
axIN[17]	axIN[16]	0	925	0	1.5
axIN[18]	axIN[17]	0	975	0	1.5
axIN[19]	axIN[18]	0	1025	0	1.5

*set_compt_param RM       	{RM_ax}
*set_compt_param CM       	{CM}
*set_compt_param ELEAK		{ELEAK_ax}

*compt /library/GP_axNode
axNode[0]	axIN[19]	0	1026	0	1

*set_compt_param RM       	{RM_my}
*set_compt_param CM       	{CM_my}

*compt /library/GP_axIN
axIN[20]	axNode[0]	0	1076	0	1.5
axIN[21]	axIN[20]	0	1126	0	1.5
axIN[22]	axIN[21]	0	1176	0	1.5
axIN[23]	axIN[22]	0	1226	0	1.5
axIN[24]	axIN[23]	0	1276	0	1.5
axIN[25]	axIN[24]	0	1326	0	1.5
axIN[26]	axIN[25]	0	1376	0	1.5
axIN[27]	axIN[26]	0	1426	0	1.5
axIN[28]	axIN[27]	0	1476	0	1.5
axIN[29]	axIN[28]	0	1526	0	1.5
axIN[30]	axIN[29]	0	1576	0	1.5
axIN[31]	axIN[30]	0	1626	0	1.5
axIN[32]	axIN[31]	0	1676	0	1.5
axIN[33]	axIN[32]	0	1726	0	1.5
axIN[34]	axIN[33]	0	1776	0	1.5
axIN[35]	axIN[34]	0	1826	0	1.5
axIN[36]	axIN[35]	0	1876	0	1.5
axIN[37]	axIN[36]	0	1926	0	1.5
axIN[38]	axIN[37]	0	1976	0	1.5
axIN[39]	axIN[38]	0	2026	0	1.5

*set_compt_param RM       	{RM_ax}
*set_compt_param CM       	{CM}

*compt /library/GP_axNode
axNode[1]	axIN[39]	0	2027	0	1

*set_compt_param RM       	{RM_my}
*set_compt_param CM       	{CM_my}

*compt /library/GP_axIN
axIN[40]	axNode[1]	0	2077	0	1.5
axIN[41]	axIN[40]	0	2127	0	1.5
axIN[42]	axIN[41]	0	2177	0	1.5
axIN[43]	axIN[42]	0	2227	0	1.5
axIN[44]	axIN[43]	0	2277	0	1.5
axIN[45]	axIN[44]	0	2327	0	1.5
axIN[46]	axIN[45]	0	2377	0	1.5
axIN[47]	axIN[46]	0	2427	0	1.5
axIN[48]	axIN[47]	0	2477	0	1.5
axIN[49]	axIN[48]	0	2527	0	1.5
axIN[50]	axIN[49]	0	2577	0	1.5
axIN[51]	axIN[50]	0	2627	0	1.5
axIN[52]	axIN[51]	0	2677	0	1.5
axIN[53]	axIN[52]	0	2727	0	1.5
axIN[54]	axIN[53]	0	2777	0	1.5
axIN[55]	axIN[54]	0	2827	0	1.5
axIN[56]	axIN[55]	0	2877	0	1.5
axIN[57]	axIN[56]	0	2927	0	1.5
axIN[58]	axIN[57]	0	2977	0	1.5
axIN[59]	axIN[58]	0	3027	0	1.5

*set_compt_param RM       	{RM_sd}
*set_compt_param CM       	{CM}
*set_compt_param ELEAK		{ELEAK_sd}

*compt /library/GP_dendrite_d0_dia2
p0[1]  soma  -4.006  3.814  -5.092  1.994 
p0[2]  p0[1]  -7.439  5.889  -5.79  2.027 
p0[3]  p0[2]  -11.39  3.34  -9.530  1.05 

*compt /library/GP_dendrite_d0_dia1
p0b1[0]  p0[3]  -11.898  1.110  -12.25  0.919 

*compt /library/GP_dendrite_d25_dia0
p0b1[1]  p0b1[0]  -11.74  -1.960  -12.25  0.35 

*compt /library/GP_dendrite_d0_dia0
p0b2[0]  p0[3]  -14.155  5.826  -9.64  0.373 

*compt /library/GP_dendrite_d25_dia0
p0b2[1]  p0b2[0]  -17.293  8.038  -9.64  0.362 
p0b2[2]  p0b2[1]  -20.265  9.822  -8.306  0.374 
p0b2[3]  p0b2[2]  -21.056  10.506  -11.258  0.444 
p0b2[4]  p0b2[3]  -21.779  11.415  -13.807  0.496 
p0b2[5]  p0b2[4]  -23.491  12.56  -10.645  0.368 
p0b2[6]  p0b2[5]  -25.035  12.889  -11.516  0.770 
p0b2[7]  p0b2[6]  -27.900  15.09  -9.870  0.35 

*compt /library/GP_dendrite_d0_dia2
p1[1]  soma  2.346  4.508  0  1.63 
p1[2]  p1[1]  2.766  9.179  0.930  1.519 
p1[3]  p1[2]  7.432  7.846  4.629  1.169 
p1[4]  p1[3]  12.051  10.914  7.267  1.057 

*compt /library/GP_dendrite_d25_dia1
p1[5]  p1[4]  14.990  13.14  8.84  0.58 
p1b1[0]  p1[5]  16.512  16.927  9.18  0.537 

*compt /library/GP_dendrite_d25_dia0
p1b1[1]  p1b1[0]  17.833  20.293  9.18  0.416 
p1b1[2]  p1b1[1]  19.88  22.930  9.18  0.35 
p1b1b1[0]  p1b1[2]  20.11  26.812  10.09  0.351 
p1b1b1[1]  p1b1b1[0]  19.213  30.573  9.97  0.362 

*compt /library/GP_dendrite_d50_dia0
p1b1b1[2]  p1b1b1[1]  18.368  34.424  9.362  0.351 
p1b1b1[3]  p1b1b1[2]  17.322  38.216  9.140  0.355 
p1b1b1[4]  p1b1b1[3]  15.990  41.937  9.520  0.353 
p1b1b1[5]  p1b1b1[4]  15.788  45.71  9.520  0.371 
p1b1b1[6]  p1b1b1[5]  16.62  49.551  9.520  0.356 
p1b1b1[7]  p1b1b1[6]  16.281  53.409  10.082  0.358 
p1b1b1[8]  p1b1b1[7]  15.428  57.053  11.494  0.350 
p1b1b1[9]  p1b1b1[8]  14.294  60.777  12.020  0.356 
p1b1b1[10]  p1b1b1[9]  12.933  64.538  12.020  0.35 
p1b1b1[11]  p1b1b1[10]  11.748  68.175  13.142  0.351 
p1b1b1[12]  p1b1b1[11]  10.697  71.962  13.318  0.356 
p1b1b1[13]  p1b1b1[12]  9.06  74.76  15.760  0.35 
p1b1b1b1[0]  p1b1b1[13]  6.970  77.205  16.330  0.230 

*compt /library/GP_dendrite_d100_dia0
p1b1b1b1[1]  p1b1b1b1[0]  5.630  80.181  16.330  0.231 
p1b1b1b1[2]  p1b1b1b1[1]  3.159  81.931  16.631  0.247 
p1b1b1b1[3]  p1b1b1b1[2]  2.211  82.144  19.756  0.23 
p1b1b1b1[4]  p1b1b1b1[3]  1.016  83.151  22.402  0.245 
p1b1b1b1[5]  p1b1b1b1[4]  -0.602  84.440  24.603  0.249 
p1b1b1b1[6]  p1b1b1b1[5]  -3.512  84.043  25.63  0.242 
p1b1b1b1[7]  p1b1b1b1[6]  -6.475  83.516  26.080  0.247 
p1b1b1b1[8]  p1b1b1b1[7]  -8.84  82.959  26.938  0.292 
p1b1b1b1[9]  p1b1b1b1[8]  -10.719  82.346  28.145  0.325 
p1b1b1b1[10]  p1b1b1b1[9]  -12.616  83.29  30.39  0.244 
p1b1b1b1[11]  p1b1b1b1[10]  -15.061  83.001  32.187  0.247 
p1b1b1b1[12]  p1b1b1b1[11]  -16.339  81.561  34.157  0.273 
p1b1b1b1[13]  p1b1b1b1[12]  -15.866  79.659  36.263  0.262 
p1b1b1b1[14]  p1b1b1b1[13]  -16.868  77.507  38.295  0.241 
p1b1b1b1[15]  p1b1b1b1[14]  -17.619  76.065  41.05  0.235 
p1b1b1b1[16]  p1b1b1b1[15]  -19.727  73.674  41.05  0.236 
p1b1b1b1[17]  p1b1b1b1[16]  -20.274  71.389  41.095  0.320 
p1b1b1b1[18]  p1b1b1b1[17]  -19.316  68.406  41.449  0.239 
p1b1b1b1[19]  p1b1b1b1[18]  -17.667  66.540  43.573  0.230 
p1b1b1b1[20]  p1b1b1b1[19]  -15.893  64.642  45.252  0.243 
p1b1b1b1[21]  p1b1b1b1[20]  -13.96  62.78  44.11  0.23 

*compt /library/GP_dendrite_d50_dia0
p1b1b1b2[0]  p1b1b1[13]  8.041  78.694  15.64  0.351 

*compt /library/GP_dendrite_d100_dia0
p1b1b1b2[1]  p1b1b1b2[0]  7.951  82.756  15.64  0.351 
p1b1b1b2[2]  p1b1b1b2[1]  8.079  86.825  15.64  0.351 
p1b1b1b2[3]  p1b1b1b2[2]  8.712  90.768  15.64  0.357 
p1b1b1b2[4]  p1b1b1b2[3]  11.033  94.056  15.786  0.354 
p1b1b1b2[5]  p1b1b1b2[4]  12.313  97.725  15.870  0.367 
p1b1b1b2[6]  p1b1b1b2[5]  12.647  101.763  15.870  0.352 
p1b1b1b2[7]  p1b1b1b2[6]  14.355  105.288  15.870  0.364 
p1b1b1b2[8]  p1b1b1b2[7]  12.851  109.005  16.015  0.356 
p1b1b1b2[9]  p1b1b1b2[8]  12.717  113.03  16.55  0.351 
p1b1b1b2[10]  p1b1b1b2[9]  12.9  117.102  16.55  0.350 
p1b1b1b2[11]  p1b1b1b2[10]  12.545  121.134  16.55  0.353 
p1b1b1b2[12]  p1b1b1b2[11]  13.905  124.871  17.002  0.357 
p1b1b1b2[13]  p1b1b1b2[12]  15.486  128.414  17.91  0.358 
p1b1b1b2[14]  p1b1b1b2[13]  16.292  132.272  17.91  0.362 
p1b1b1b2[15]  p1b1b1b2[14]  18.473  135.708  17.91  0.351 
p1b1b1b2[16]  p1b1b1b2[15]  19.262  139.086  19.84  0.359 
p1b1b1b2[17]  p1b1b1b2[16]  21.989  142.114  19.84  0.350 
p1b1b1b2[18]  p1b1b1b2[17]  24.358  145.398  19.84  0.352 
p1b1b1b2[19]  p1b1b1b2[18]  27.32  148.14  19.84  0.35 

*compt /library/GP_dendrite_d25_dia1
p1b1b2[0]  p1b1[2]  24.465  24.080  9.860  0.543 

*compt /library/GP_dendrite_d25_dia0
p1b1b2[1]  p1b1b2[0]  29.181  24.337  9.860  0.476 

*compt /library/GP_dendrite_d50_dia0
p1b1b2[2]  p1b1b2[1]  33.585  25.361  9.860  0.497 
p1b1b2[3]  p1b1b2[2]  37.55  26.27  10.991  0.532 
p1b1b2[4]  p1b1b2[3]  41.070  26.38  13.175  0.542 
p1b1b2[5]  p1b1b2[4]  45.814  26.38  13.600  0.472 
p1b1b2[6]  p1b1b2[5]  50.377  25.407  14.565  0.472 
p1b1b2[7]  p1b1b2[6]  55.077  25.446  14.850  0.477 
p1b1b2[8]  p1b1b2[7]  59.669  25.609  15.086  0.488 
p1b1b2[9]  p1b1b2[8]  64.059  26.194  15.3  0.496 
p1b1b2[10]  p1b1b2[9]  67.937  24.801  15.3  0.350 
p1b1b2[11]  p1b1b2[10]  71.415  22.805  15.473  0.36 
p1b1b2[12]  p1b1b2[11]  74.062  22.712  18.634  0.35 
p1b1b2[13]  p1b1b2[12]  76.651  21.080  21.326  0.354 

*compt /library/GP_dendrite_d100_dia0
p1b1b2[14]  p1b1b2[13]  80.074  19.377  22.777  0.353 
p1b1b2[15]  p1b1b2[14]  83.741  17.888  23.124  0.363 
p1b1b2[16]  p1b1b2[15]  87.607  16.611  23.783  0.35 
p1b1b2[17]  p1b1b2[16]  91.397  15.088  24.150  0.352 
p1b1b2[18]  p1b1b2[17]  95.192  13.492  24.150  0.351 
p1b1b2[19]  p1b1b2[18]  98.968  11.861  24.150  0.351 
p1b1b2[20]  p1b1b2[19]  102.811  10.373  24.150  0.350 
p1b1b2[21]  p1b1b2[20]  106.581  8.704  24.150  0.350 
p1b1b2[22]  p1b1b2[21]  110.400  7.37  24.150  0.357 
p1b1b2[23]  p1b1b2[22]  114.335  7.836  24.150  0.364 
p1b1b2[24]  p1b1b2[23]  117.719  7.342  26.2  0.362 
p1b1b2[25]  p1b1b2[24]  121.235  6.902  27.89  0.368 
p1b1b2[26]  p1b1b2[25]  125.253  6.059  28.137  0.351 
p1b1b2[27]  p1b1b2[26]  129.204  5.733  27.962  0.364 
p1b1b2[28]  p1b1b2[27]  132.937  5.014  27.446  0.376 
p1b1b2[29]  p1b1b2[28]  136.343  4.26  29.233  0.368 
p1b1b2[30]  p1b1b2[29]  139.649  2.733  31.017  0.356 
p1b1b2[31]  p1b1b2[30]  143.130  0.899  31.926  0.357 
p1b1b2[32]  p1b1b2[31]  146.535  -0.646  32.624  0.379 
p1b1b2[33]  p1b1b2[32]  149.928  -2.931  32.77  0.353 
p1b1b2[34]  p1b1b2[33]  153.614  -4.736  32.77  0.352 
p1b1b2[35]  p1b1b2[34]  157.348  -6.194  33.182  0.358 
p1b1b2[36]  p1b1b2[35]  161.115  -7.670  33.68  0.354 
p1b1b2[37]  p1b1b2[36]  164.728  -9.66  33.68  0.350 
p1b1b2[38]  p1b1b2[37]  167.988  -12.113  33.68  0.354 

*compt /library/GP_dendrite_d200_dia0
p1b1b2[39]  p1b1b2[38]  171.038  -14.889  33.68  0.350 
p1b1b2[40]  p1b1b2[39]  174.05  -17.536  34.077  0.358 
p1b1b2[41]  p1b1b2[40]  177.143  -19.694  35.38  0.362 
p1b1b2[42]  p1b1b2[41]  180.839  -21.097  35.38  0.365 
p1b1b2[43]  p1b1b2[42]  184.369  -22.648  36.266  0.365 
p1b1b2[44]  p1b1b2[43]  187.511  -25.094  36.85  0.359 
p1b1b2[45]  p1b1b2[44]  190.739  -27.64  36.85  0.351 
p1b1b2[46]  p1b1b2[45]  194.304  -29.6  36.85  0.355 
p1b1b2[47]  p1b1b2[46]  197.410  -32.311  36.914  0.350 
p1b1b2[48]  p1b1b2[47]  200.487  -34.818  37.678  0.357 
p1b1b2[49]  p1b1b2[48]  203.622  -36.903  38.928  0.364 
p1b1b2[50]  p1b1b2[49]  207.294  -38.117  37.496  0.350 
p1b1b2[51]  p1b1b2[50]  209.307  -38.96  39.722  0.463 
p1b1b2[52]  p1b1b2[51]  211.03  -39.85  42.63  0.35 

*compt /library/GP_dendrite_d25_dia1
p1b2[0]  p1[5]  17.840  9.166  8.270  0.535 

*compt /library/GP_dendrite_d25_dia0
p1b2[1]  p1b2[0]  18.778  4.708  8.323  0.497 
p1b2[2]  p1b2[1]  21.74  3.031  11.381  0.495 
p1b2[3]  p1b2[2]  22.943  -0.9  13.693  0.480 

*compt /library/GP_dendrite_d50_dia0
p1b2[4]  p1b2[3]  26.319  -3.947  14.400  0.492 
p1b2[5]  p1b2[4]  29.402  -7.392  15.316  0.480 
p1b2[6]  p1b2[5]  32.626  -10.315  16.67  0.497 
p1b2[7]  p1b2[6]  35.895  -13.767  16.78  0.467 
p1b2[8]  p1b2[7]  39.233  -15.708  17.309  0.373 
p1b2[9]  p1b2[8]  41.851  -17.192  19.84  0.37 
p1b2[10]  p1b2[9]  45.781  -18.509  19.84  0.351 
p1b2[11]  p1b2[10]  49.23  -20.641  19.84  0.359 
p1b2[12]  p1b2[11]  52.356  -23.224  19.84  0.359 
p1b2[13]  p1b2[12]  56.092  -24.407  21.153  0.352 
p1b2[14]  p1b2[13]  59.259  -26.999  21.310  0.355 
p1b2[15]  p1b2[14]  62.449  -29.656  21.310  0.350 

*compt /library/GP_dendrite_d100_dia0
p1b2[16]  p1b2[15]  65.839  -31.805  21.920  0.358 
p1b2[17]  p1b2[16]  69.227  -33.487  23.644  0.350 
p1b2[18]  p1b2[17]  72.769  -35.442  24.150  0.357 
p1b2[19]  p1b2[18]  75.821  -38.205  24.150  0.353 
p1b2[20]  p1b2[19]  78.452  -41.39  24.306  0.352 
p1b2[21]  p1b2[20]  80.356  -44.97  24.94  0.355 
p1b2[22]  p1b2[21]  82.005  -48.761  24.94  0.352 
p1b2[23]  p1b2[22]  84.104  -52.266  24.94  0.356 
p1b2[24]  p1b2[23]  85.276  -56.251  24.94  0.350 
p1b2[25]  p1b2[24]  86.632  -60.173  24.94  0.351 
p1b2[26]  p1b2[25]  87.417  -64.242  25.188  0.350 
p1b2[27]  p1b2[26]  88.130  -68.333  25.28  0.350 
p1b2[28]  p1b2[27]  88.893  -72.419  25.28  0.350 
p1b2[29]  p1b2[28]  90.855  -76.028  25.28  0.354 
p1b2[30]  p1b2[29]  92.94  -79.623  25.28  0.350 
p1b2[31]  p1b2[30]  94.783  -83.089  24.289  0.359 
p1b2[32]  p1b2[31]  97.002  -86.358  23.47  0.361 
p1b2[33]  p1b2[32]  99.341  -89.644  22.614  0.353 
p1b2[34]  p1b2[33]  100.92  -93.42  23.02  0.35 
p1b2b1[0]  p1b2[34]  101.818  -97.501  23.02  0.35 
p1b2b1[1]  p1b2b1[0]  102.716  -101.582  23.02  0.35 
p1b2b1[2]  p1b2b1[1]  103.494  -105.684  23.02  0.350 
p1b2b1[3]  p1b2b1[2]  103.908  -109.83  23.02  0.351 
p1b2b1[4]  p1b2b1[3]  104.081  -113.985  23.02  0.352 

*compt /library/GP_dendrite_d200_dia0
p1b2b1[5]  p1b2b1[4]  105.112  -117.936  23.02  0.358 
p1b2b1[6]  p1b2b1[5]  106.482  -121.883  23.02  0.350 
p1b2b1[7]  p1b2b1[6]  107.936  -125.800  23.02  0.350 
p1b2b1[8]  p1b2b1[7]  109.416  -129.708  23.02  0.35 
p1b2b1[9]  p1b2b1[8]  110.845  -133.633  23.063  0.350 
p1b2b1[10]  p1b2b1[9]  112.345  -137.487  23.35  0.353 
p1b2b1[11]  p1b2b1[10]  114.193  -141.093  24.150  0.354 
p1b2b1[12]  p1b2b1[11]  115.426  -145.064  24.150  0.352 
p1b2b1[13]  p1b2b1[12]  116.078  -149.191  24.150  0.35 
p1b2b1[14]  p1b2b1[13]  116.73  -153.318  24.150  0.35 
p1b2b1[15]  p1b2b1[14]  118.104  -157.235  24.150  0.352 
p1b2b1[16]  p1b2b1[15]  119.81  -161.014  24.150  0.353 
p1b2b1[17]  p1b2b1[16]  120.964  -165.012  24.283  0.351 
p1b2b1[18]  p1b2b1[17]  121.647  -169.097  24.836  0.350 
p1b2b1[19]  p1b2b1[18]  122.330  -173.182  25.389  0.350 
p1b2b1[20]  p1b2b1[19]  123.127  -177.244  25.85  0.351 
p1b2b1[21]  p1b2b1[20]  124.497  -181.191  25.85  0.350 
p1b2b1[22]  p1b2b1[21]  125.765  -185.141  26.115  0.352 
p1b2b1[23]  p1b2b1[22]  126.818  -189.086  26.999  0.350 
p1b2b1[24]  p1b2b1[23]  127.129  -193.179  27.32  0.355 
p1b2b1[25]  p1b2b1[24]  127.565  -197.306  27.32  0.352 
p1b2b1[26]  p1b2b1[25]  128.02  -201.421  27.32  0.353 
p1b2b1[27]  p1b2b1[26]  127.739  -205.521  27.684  0.354 
p1b2b1[28]  p1b2b1[27]  127.570  -209.415  29.190  0.35 

*compt /library/GP_dendrite_d300_dia0
p1b2b1[29]  p1b2b1[28]  128.172  -213.507  29.37  0.353 
p1b2b1[30]  p1b2b1[29]  128.575  -217.642  29.714  0.351 
p1b2b1[31]  p1b2b1[30]  129.281  -221.606  30.05  0.362 
p1b2b1[32]  p1b2b1[31]  130.469  -225.611  30.05  0.350 
p1b2b1[33]  p1b2b1[32]  131.778  -229.578  30.05  0.350 
p1b2b1[34]  p1b2b1[33]  134.12  -232.620  30.964  0.371 
p1b2b1[35]  p1b2b1[34]  136.583  -235.192  33.061  0.354 
p1b2b1[36]  p1b2b1[35]  138.36  -237.52  31.86  0.35 

*compt /library/GP_dendrite_d100_dia0
p1b2b2[0]  p1b2[34]  103.681  -95.805  23.13  0.386 
p1b2b2[1]  p1b2b2[0]  104.514  -99.452  24.356  0.358 
p1b2b2[2]  p1b2b2[1]  105.574  -102.828  26.040  0.359 
p1b2b2[3]  p1b2b2[2]  106.3  -106.683  26.893  0.351 
p1b2b2[4]  p1b2b2[3]  105.769  -109.989  27.987  0.4 
p1b2b2[5]  p1b2b2[4]  106.683  -113.142  29.257  0.4 

*compt /library/GP_dendrite_d200_dia0
p1b2b2[6]  p1b2b2[5]  108.597  -114.980  32.126  0.360 
p1b2b2[7]  p1b2b2[6]  109.425  -118.603  33.474  0.356 
p1b2b2[8]  p1b2b2[7]  111.178  -121.983  34.269  0.362 
p1b2b2[9]  p1b2b2[8]  112.773  -125.535  34.47  0.361 
p1b2b2[10]  p1b2b2[9]  114.279  -129.109  34.47  0.363 
p1b2b2[11]  p1b2b2[10]  116.869  -131.975  35.399  0.354 
p1b2b2[12]  p1b2b2[11]  119.333  -134.888  36.62  0.351 
p1b2b2[13]  p1b2b2[12]  121.570  -138.230  36.62  0.350 
p1b2b2[14]  p1b2b2[13]  123.808  -141.572  36.62  0.35 
p1b2b2[15]  p1b2b2[14]  126.045  -144.914  36.62  0.350 
p1b2b2[16]  p1b2b2[15]  128.443  -147.574  38.34  0.354 
p1b2b2[17]  p1b2b2[16]  130.785  -150.622  39.01  0.361 
p1b2b2[18]  p1b2b2[17]  133.237  -153.806  39.01  0.350 
p1b2b2[19]  p1b2b2[18]  134.976  -155.607  39.577  0.171 
p1b2b2[20]  p1b2b2[19]  136.62  -157.230  40.25  0.12 

*compt /library/GP_dendrite_d0_dia1
p2[1]  soma  -0.981  5.021  0  0.633

*compt /library/GP_dendrite_d0_dia0
p2[2]  p2[1]  -0.464  9.577  1.017  0.477 
p2[3]  p2[2]  0.421  13.688  -0.435  0.504 
p2[4]  p2[3]  -0.088  17.966  -2.334  0.476 

*compt /library/GP_dendrite_d25_dia0
p2[5]  p2[4]  0  22.12  -0.22  0.47 
p2b1[0]  p2[5]  2.957  25.845  -0.68  0.470 
p2b1[1]  p2b1[0]  5.291  29.998  -0.68  0.472 
p2b1[2]  p2b1[1]  7.446  34.248  -0.68  0.472 
p2b1[3]  p2b1[2]  9.037  38.722  -0.68  0.473 
p2b1[4]  p2b1[3]  10.576  43.243  -0.68  0.471 

*compt /library/GP_dendrite_d50_dia0
p2b1[5]  p2b1[4]  12.747  47.378  -0.68  0.481 
p2b1[6]  p2b1[5]  14.584  51.651  -0.484  0.483 
p2b1[7]  p2b1[6]  16.651  55.186  1.986  0.47 
p2b1[8]  p2b1[7]  18.064  59.609  2.38  0.482 
p2b1[9]  p2b1[8]  20.649  63.506  2.38  0.481 
p2b1[10]  p2b1[9]  21.620  67.820  3.529  0.492 
p2b1[11]  p2b1[10]  21.749  72.193  5.438  0.471 
p2b1[12]  p2b1[11]  19.65  75.796  7.023  0.504 
p2b1[13]  p2b1[12]  18.584  80.105  7.83  0.498 
p2b1[14]  p2b1[13]  18.62  84.598  8.928  0.486 

*compt /library/GP_dendrite_d100_dia0
p2b1[15]  p2b1[14]  17.884  87.843  11.12  0.564 
p2b1[16]  p2b1[15]  19.07  91.596  12.95  0.518 
p2b1[17]  p2b1[16]  20.116  94.157  15.386  0.61 
p2b1[18]  p2b1[17]  23.527  94.503  17.503  0.558 
p2b1[19]  p2b1[18]  24.78  96.669  19.861  0.654 
p2b1[20]  p2b1[19]  25.82  100.716  21.258  0.510 
p2b1[21]  p2b1[20]  27.893  104.336  22.42  0.519 
p2b1[22]  p2b1[21]  31.566  105.959  24.068  0.518 
p2b1[23]  p2b1[22]  35.504  105.964  25.576  0.533 
p2b1[24]  p2b1[23]  39.801  107.240  24.95  0.497 
p2b1[25]  p2b1[24]  43.24  108.889  24.95  0.589 
p2b1[26]  p2b1[25]  45.075  112.332  27.238  0.497 
p2b1[27]  p2b1[26]  46.047  116.728  28.13  0.49 
p2b1[28]  p2b1[27]  50.244  118.956  28.13  0.473 
p2b1[29]  p2b1[28]  51.686  123.387  28.13  0.482 
p2b1[30]  p2b1[29]  52.210  126.581  30.144  0.59 
p2b1[31]  p2b1[30]  52.798  130.831  31.614  0.496 
p2b1[32]  p2b1[31]  52.107  135.010  33.395  0.489 
p2b1[33]  p2b1[32]  49.822  138.840  34.7  0.468 
p2b1[34]  p2b1[33]  49.095  142.903  34.7  0.350 
p2b1[35]  p2b1[34]  47.635  146.721  34.7  0.353 
p2b1[36]  p2b1[35]  46.860  150.731  34.7  0.354 
p2b1[37]  p2b1[36]  47.581  154.771  34.7  0.352 
p2b1[38]  p2b1[37]  47.637  158.808  34.868  0.357 

*compt /library/GP_dendrite_d200_dia0
p2b1[39]  p2b1[38]  48.029  161.252  36.97  0.445 
p2b1[40]  p2b1[39]  50.95  163.63  37.112  0.383 
p2b1[41]  p2b1[40]  52.910  166.652  38.315  0.380 
p2b1[42]  p2b1[41]  53.444  169.987  39.961  0.384 
p2b1[43]  p2b1[42]  54.602  173.889  40.26  0.354 
p2b1[44]  p2b1[43]  54.77  177.393  41.354  0.393 
p2b1[45]  p2b1[44]  55.696  180.877  42.655  0.377 
p2b1[46]  p2b1[45]  57.440  184.493  43.43  0.353 
p2b1[47]  p2b1[46]  58.482  187.967  44.57  0.38 
p2b1[48]  p2b1[47]  58.668  191.795  46.078  0.351 
p2b1[49]  p2b1[48]  57.643  195.109  47.74  0.376 
p2b1[50]  p2b1[49]  57.368  198.874  48.901  0.366 
p2b1[51]  p2b1[50]  58.382  202.67  49.9  0.356 
p2b1[52]  p2b1[51]  56.566  206.032  49.9  0.378 
p2b1[53]  p2b1[52]  55.979  208.695  52.128  0.410 
p2b1[54]  p2b1[53]  55.537  212.628  52.39  0.364 
p2b1[55]  p2b1[54]  54.591  216.621  52.39  0.352 
p2b1[56]  p2b1[55]  53.746  220.640  52.39  0.352 
p2b1[57]  p2b1[56]  52.479  224.512  52.737  0.353 
p2b1[58]  p2b1[57]  51.6  228.423  53.719  0.350 
p2b1[59]  p2b1[58]  50.845  232.361  54.65  0.351 
p2b1[60]  p2b1[59]  49.81  236.237  55.34  0.355 
p2b1[61]  p2b1[60]  49.519  240.041  56.381  0.365 
p2b1[62]  p2b1[61]  49.291  244.14  56.558  0.352 
p2b1[63]  p2b1[62]  50.092  248.091  56.59  0.358 

*compt /library/GP_dendrite_d300_dia0
p2b1[64]  p2b1[63]  50.406  252.082  56.59  0.361 
p2b1[65]  p2b1[64]  50.803  256.005  57.219  0.362 
p2b1[66]  p2b1[65]  52.98  259.369  57.61  0.359 
p2b1[67]  p2b1[66]  55.064  262.855  58.052  0.354 
p2b1[68]  p2b1[67]  56.567  266.600  58.63  0.354 
p2b1[69]  p2b1[68]  56.112  270.595  58.63  0.359 
p2b1[70]  p2b1[69]  55.281  274.638  58.63  0.35 
p2b1[71]  p2b1[70]  53.125  278.022  58.63  0.360 
p2b1[72]  p2b1[71]  51.53  281.577  59.758  0.356 
p2b1[73]  p2b1[72]  50.461  285.338  60.787  0.357 
p2b1[74]  p2b1[73]  47.790  287.75  63.17  0.35 

*compt /library/GP_dendrite_d25_dia0
p2b2[0]  p2[5]  -2.748  24.971  1.930  0.490 
p2b2[1]  p2b2[0]  -5.202  28.959  1.930  0.472 
p2b2[2]  p2b2[1]  -6.768  32.973  3.190  0.492 
p2b2[3]  p2b2[2]  -9.728  36.465  4.215  0.471 
p2b2[4]  p2b2[3]  -13.243  39.504  4.898  0.470 

*compt /library/GP_dendrite_d50_dia0
p2b2[5]  p2b2[4]  -16.162  43.015  5.694  0.476 
p2b2[6]  p2b2[5]  -18.381  46.505  6.13  0.413 
p2b2[7]  p2b2[6]  -20.671  49.684  6.13  0.362 
p2b2[8]  p2b2[7]  -22.629  53.225  6.13  0.351 
p2b2[9]  p2b2[8]  -24.494  56.346  7.356  0.37 
p2b2[10]  p2b2[9]  -26.612  59.51  8.584  0.355 
p2b2[11]  p2b2[10]  -29.335  62.499  8.877  0.350 
p2b2[12]  p2b2[11]  -31.636  65.794  8.96  0.353 
p2b2[13]  p2b2[12]  -33.674  69.243  9.507  0.351 
p2b2[14]  p2b2[13]  -35.765  72.691  9.64  0.352 
p2b2[15]  p2b2[14]  -38.430  75.701  9.64  0.353 
p2b2[16]  p2b2[15]  -39.934  79.259  10.32  0.362 

*compt /library/GP_dendrite_d100_dia0
p2b2[17]  p2b2[16]  -41.614  82.949  10.32  0.350 
p2b2[18]  p2b2[17]  -43.381  86.585  10.32  0.351 
p2b2[19]  p2b2[18]  -45.96  89.714  10.32  0.35 
p2b2[20]  p2b2[19]  -48.474  92.886  10.32  0.351 
p2b2[21]  p2b2[20]  -51.08  95.988  10.32  0.350 
p2b2[22]  p2b2[21]  -53.957  98.844  10.32  0.350 
p2b2[23]  p2b2[22]  -56.583  101.900  10.644  0.351 
p2b2[24]  p2b2[23]  -59.090  105.051  11.12  0.350 
p2b2[25]  p2b2[24]  -61.597  108.202  11.596  0.350 
p2b2[26]  p2b2[25]  -64.182  111.268  12.158  0.350 
p2b2[27]  p2b2[26]  -66.81  114.282  12.830  0.350 
p2b2[28]  p2b2[27]  -70.217  116.378  12.93  0.355 
p2b2[29]  p2b2[28]  -73.633  118.539  12.93  0.351 
p2b2[30]  p2b2[29]  -77.003  120.792  12.894  0.350 
p2b2[31]  p2b2[30]  -80.200  123.108  12.920  0.359 
p2b2[32]  p2b2[31]  -81.740  126.48  14.74  0.35 

*compt /library/GP_dendrite_d0_dia0
p3[1]  soma  1.543  -0.915  -3.446  0.376 
p3[2]  p3[1]  2.608  -0.885  -6.052  0.519 
p3[3]  p3[2]  1.444  2.984  -5.065  0.351 
p3[4]  p3[3]  1.823  6.482  -3.344  0.373 
p3[5]  p3[4]  1.677  9.951  -3.97  0.414 

*compt /library/GP_dendrite_d25_dia0
p3[6]  p3[5]  2.672  13.95  -3.97  0.355 
p3[7]  p3[6]  1.63  17.892  -3.97  0.358 
p3[8]  p3[7]  1.361  20.65  -1.747  0.411 
p3[9]  p3[8]  0.896  22.547  1.845  0.357 
p3[10]  p3[9]  0.552  26.664  2.16  0.353 
p3[11]  p3[10]  -0.863  28.994  3.657  0.47 
p3[12]  p3[11]  0.058  31.229  6.328  0.406 

*compt /library/GP_dendrite_d50_dia0
p3[13]  p3[12]  0.725  35.235  6.47  0.36 
p3[14]  p3[13]  -1.229  38.882  6.58  0.353 
p3[15]  p3[14]  -3.230  42.451  6.58  0.357 
p3[16]  p3[15]  -3.159  45.351  7.6  0.257 
p3[17]  p3[16]  -2.772  48.380  7.6  0.255 
p3[18]  p3[17]  -2.775  51.759  7.6  0.230 
p3[19]  p3[18]  -2.328  55.031  7.6  0.236 
p3[20]  p3[19]  -0.682  57.217  9.329  0.241 
p3[21]  p3[20]  -0.236  60.319  9.75  0.246 
p3[22]  p3[21]  1.533  63.159  9.75  0.233 
p3[23]  p3[22]  2.654  66.353  9.75  0.23 
p3[24]  p3[23]  3.26  69.635  9.75  0.233 
p3[25]  p3[24]  3.38  73.000  9.75  0.231 
p3[26]  p3[25]  3.380  76.385  9.75  0.230 
p3[27]  p3[26]  4.269  79.537  9.75  0.238 

*compt /library/GP_dendrite_d100_dia0
p3[28]  p3[27]  4.615  82.708  9.75  0.244 
p3[29]  p3[28]  4.427  85.998  9.75  0.236 
p3[30]  p3[29]  4.033  89.204  9.75  0.241 
p3[31]  p3[30]  3.421  92.457  9.75  0.235 
p3[32]  p3[31]  3.16  95.81  9.75  0.231 
p3[33]  p3[32]  2.159  98.663  8.51  0.238 
p3[34]  p3[33]  1.036  101.22  7.723  0.268 
p3[35]  p3[34]  0.373  104.375  7.49  0.241 
p3[36]  p3[35]  0.788  107.628  7.49  0.237 
p3[37]  p3[36]  0.021  110.877  7.49  0.233 
p3[38]  p3[37]  -3.136  111.776  7.49  0.237 
p3[39]  p3[38]  -3.924  112.681  4.544  0.245 
p3[40]  p3[39]  -5.202  113.910  1.973  0.249 
p3[41]  p3[40]  -5.978  116.934  1.306  0.244 
p3[42]  p3[41]  -4.292  117.602  0.046  0.353 
p3[43]  p3[42]  -3.83  120.168  -1.24  0.268 
p3[44]  p3[43]  -3.333  123.458  -1.457  0.233 
p3[45]  p3[44]  -2.370  126.35  -2.401  0.244 
p3[46]  p3[45]  -3.869  129.32  -3.026  0.230 
p3[47]  p3[46]  -3.948  132.669  -3.060  0.232 
p3[48]  p3[47]  -4.032  136.053  -3.060  0.230 
p3[49]  p3[48]  -2.616  138.602  -3.796  0.259 
p3[50]  p3[49]  -0.514  140.863  -5.012  0.235 
p3[51]  p3[50]  1.174  143.630  -5.67  0.235 
p3[52]  p3[51]  3.64  145.894  -5.67  0.233 
p3[53]  p3[52]  4.770  148.671  -5.67  0.26 
p3[54]  p3[53]  5.93  153.9  -5.67  1.98 

*compt /library/GP_dendrite_d0_dia2
p4[1]  soma  -1.134  -7.17  0.242  1.349 
p4[2]  p4[1]  -2.805  -13.377  3.57  1.354 
p4[3]  p4[2]  -1.49  -20.069  3.63  1.047 

*compt /library/GP_dendrite_d25_dia1
p4[4]  p4[3]  -1.287  -26.159  3.63  0.845 
p4[5]  p4[4]  -1.39  -29.49  8.17  1.05 
p4b1[0]  p4[5]  -1.417  -33.398  8.17  0.836 
p4b1[1]  p4b1[0]  -2.689  -37.866  8.17  0.651 
p4b1[2]  p4b1[1]  -0.697  -41.234  10.074  0.695 

*compt /library/GP_dendrite_d50_dia1
p4b1[3]  p4b1[2]  1.194  -43.823  9.19  0.909 
p4b1[4]  p4b1[3]  2.728  -48.251  8.431  0.637 
p4b1[5]  p4b1[4]  4.917  -51.123  11.434  0.644 
p4b1[6]  p4b1[5]  6.415  -55.504  12.48  0.557 

*compt /library/GP_dendrite_d50_dia0
p4b1[7]  p4b1[6]  7.981  -59.708  12.922  0.489 
p4b1[8]  p4b1[7]  10.466  -63.372  13.95  0.485 
p4b1[9]  p4b1[8]  13.133  -67.139  14.152  0.477 
p4b1[10]  p4b1[9]  15.507  -70.236  14.58  0.562 
p4b1[11]  p4b1[10]  17.172  -73.641  17.252  0.476 
p4b1[12]  p4b1[11]  19.352  -74.763  21.033  0.489 
p4b1[13]  p4b1[12]  19.799  -78.253  23.36  0.523 

*compt /library/GP_dendrite_d100_dia0
p4b1[14]  p4b1[13]  22.09  -81.008  23.958  0.607 
p4b1[15]  p4b1[14]  26.108  -79.920  24.875  0.517 
p4b1[16]  p4b1[15]  28.804  -76.630  25.97  0.502 
p4b1[17]  p4b1[16]  32.749  -74.51  26.373  0.490 
p4b1[18]  p4b1[17]  35.820  -73.03  29.6  0.47 
p4b1b1[0]  p4b1[18]  39.327  -74.668  32.196  0.483 
p4b1b1[1]  p4b1b1[0]  40.990  -77.469  35.5  0.485 
p4b1b1[2]  p4b1b1[1]  41.283  -80.871  37.675  0.556 
p4b1b1[3]  p4b1b1[2]  42.336  -84.682  39.47  0.519 
p4b1b1[4]  p4b1b1[3]  44.267  -88.303  41.581  0.488 
p4b1b1[5]  p4b1b1[4]  46.334  -89.974  45.414  0.483 
p4b1b1[6]  p4b1b1[5]  48.854  -92.468  47.695  0.534 
p4b1b1[7]  p4b1b1[6]  51.400  -95.756  49.333  0.504 
p4b1b1[8]  p4b1b1[7]  55.203  -98.630  49.809  0.470 
p4b1b1[9]  p4b1b1[8]  58.750  -101.816  49.9  0.472 
p4b1b1[10]  p4b1b1[9]  61.748  -105.302  49.9  0.49 
p4b1b1[11]  p4b1b1[10]  63.735  -107.954  52.904  0.503 
p4b1b1[12]  p4b1b1[11]  67.124  -109.671  54.404  0.551 
p4b1b1[13]  p4b1b1[12]  71.18  -111.889  54.43  0.487 
p4b1b1[14]  p4b1b1[13]  74.499  -114.783  54.43  0.511 
p4b1b1[15]  p4b1b1[14]  76.381  -116.444  57.687  0.355 
p4b1b1[16]  p4b1b1[15]  77.937  -120.195  57.72  0.356 
p4b1b1[17]  p4b1b1[16]  79.42  -124.023  57.72  0.353 

*compt /library/GP_dendrite_d200_dia0
p4b1b1[18]  p4b1b1[17]  82.322  -126.945  57.831  0.351 
p4b1b1[19]  p4b1b1[18]  84.54  -130.168  59.100  0.352 
p4b1b1[20]  p4b1b1[19]  86.315  -133.799  59.555  0.356 
p4b1b1[21]  p4b1b1[20]  88.728  -136.659  60.984  0.361 
p4b1b1[22]  p4b1b1[21]  91.406  -139.2  62.734  0.354 
p4b1b1[23]  p4b1b1[22]  91.805  -140.233  66.366  0.381 
p4b1b1[24]  p4b1b1[23]  89.562  -142.214  63.96  0.377 
p4b1b1[25]  p4b1b1[24]  89.143  -145.653  64.772  0.407 
p4b1b1[26]  p4b1b1[25]  90.261  -149.502  65.55  0.354 
p4b1b1[27]  p4b1b1[26]  91.185  -153.509  65.55  0.352 
p4b1b1[28]  p4b1b1[27]  91.791  -157.57  65.774  0.352 
p4b1b1[29]  p4b1b1[28]  92.763  -161.512  66.549  0.35 
p4b1b1[30]  p4b1b1[29]  93.280  -165.611  66.57  0.350 
p4b1b1[31]  p4b1b1[30]  93.457  -169.735  66.57  0.351 
p4b1b1[32]  p4b1b1[31]  93.574  -173.847  66.57  0.352 
p4b1b1[33]  p4b1b1[32]  93.6  -177.776  66.978  0.366 
p4b1b1[34]  p4b1b1[33]  91.951  -180.438  69.226  0.375 
p4b1b1[35]  p4b1b1[34]  90.179  -182.911  70.659  0.430 
p4b1b1[36]  p4b1b1[35]  87.09  -185.230  71.029  0.373 
p4b1b1[37]  p4b1b1[36]  86.074  -187.858  72.684  0.443 
p4b1b1[38]  p4b1b1[37]  82.453  -188.159  74.05  0.373 
p4b1b1[39]  p4b1b1[38]  78.421  -188.463  74.05  0.358 
p4b1b1[40]  p4b1b1[39]  74.360  -188.974  74.05  0.354 
p4b1b1[41]  p4b1b1[40]  70.571  -189.871  74.766  0.365 
p4b1b1[42]  p4b1b1[41]  67.044  -188.763  76.32  0.361 

*compt /library/GP_dendrite_d300_dia0
p4b1b1[43]  p4b1b1[42]  63.114  -187.880  76.67  0.358 
p4b1b1[44]  p4b1b1[43]  59.299  -188.539  77.986  0.354 
p4b1b1[45]  p4b1b1[44]  55.580  -189.61  79.16  0.35 

*compt /library/GP_dendrite_d100_dia0
p4b1b2[0]  p4b1[18]  37.512  -70.384  28.13  0.394 
p4b1b2[1]  p4b1b2[0]  39.886  -69.611  30.423  0.403 
p4b1b2[2]  p4b1b2[1]  43.633  -69.249  31.162  0.356 
p4b1b2[3]  p4b1b2[2]  47.413  -68.423  31.19  0.353 
p4b1b2[4]  p4b1b2[3]  50.862  -68.269  32.319  0.376 
p4b1b2[5]  p4b1b2[4]  53.415  -68.386  35.246  0.351 
p4b1b2[6]  p4b1b2[5]  56.047  -69.115  35.805  0.49 
p4b1b2[7]  p4b1b2[6]  58.825  -70.605  33.508  0.350 
p4b1b2[8]  p4b1b2[7]  61.63  -72.11  31.19  0.35 

*compt /library/GP_dendrite_d25_dia1
p4b2[0]  p4[5]  -0.502  -32.013  3.97  0.614 
p4b2[1]  p4b2[0]  -0.424  -37.229  3.97  0.586 

*compt /library/GP_dendrite_d50_dia1
p4b2[2]  p4b2[1]  -0.541  -42.385  3.97  0.593 
p4b2[3]  p4b2[2]  -0.819  -47.555  3.97  0.591 
p4b2[4]  p4b2[3]  -1.926  -52.698  3.97  0.581 
p4b2[5]  p4b2[4]  -1.818  -57.565  3.97  0.513 

*compt /library/GP_dendrite_d50_dia1
p4b2[6]  p4b2[5]  -0.828  -62.204  3.97  0.470 
p4b2[7]  p4b2[6]  0.073  -66.862  3.97  0.470 
p4b2[8]  p4b2[7]  0.098  -71.579  3.785  0.473 
p4b2[9]  p4b2[8]  0.012  -76.268  3.056  0.47 
p4b2[10]  p4b2[9]  1.667  -80.552  2.801  0.485 
p4b2[11]  p4b2[10]  3.83  -84.506  1.930  0.486 
p4b2[12]  p4b2[11]  7.243  -87.747  1.930  0.474 

*compt /library/GP_dendrite_d100_dia1
p4b2[13]  p4b2[12]  9.772  -91.756  1.875  0.471 
p4b2[14]  p4b2[13]  12.733  -95.399  1.174  0.470 
p4b2[15]  p4b2[14]  15.769  -99.011  0.8  0.471 
p4b2[16]  p4b2[15]  18.767  -102.682  0.8  0.471 
p4b2[17]  p4b2[16]  21.549  -106.517  0.8  0.471 
p4b2[18]  p4b2[17]  24.813  -109.964  0.8  0.470 
p4b2[19]  p4b2[18]  28.131  -113.359  0.8  0.470 
p4b2[20]  p4b2[19]  30.23  -117.26  0.8  0.504 
p4b2[21]  p4b2[20]  32.358  -121.420  0.8  0.477 
p4b2[22]  p4b2[21]  35.179  -125.231  0.8  0.471 
p4b2[23]  p4b2[22]  38.720  -128.560  0.8  0.47 
p4b2b1[0]  p4b2[23]  43.530  -128.811  0.8  0.470 
p4b2b1[1]  p4b2b1[0]  47.964  -130.515  0.8  0.477 
p4b2b1[2]  p4b2b1[1]  52.670  -131.192  0.8  0.476 
p4b2b1[3]  p4b2b1[2]  56.804  -133.516  0.8  0.478 
p4b2b1[4]  p4b2b1[3]  61.435  -134.711  0.8  0.473 
p4b2b1[5]  p4b2b1[4]  65.998  -136.139  0.8  0.474 
p4b2b1[6]  p4b2b1[5]  69.462  -139.202  0.8  0.49 
p4b2b1[7]  p4b2b1[6]  71.151  -141.367  3.892  0.548 
p4b2b1[8]  p4b2b1[7]  74.488  -143.603  5.513  0.523 
p4b2b1[9]  p4b2b1[8]  78.302  -146.093  5.67  0.497 

*compt /library/GP_dendrite_d200_dia1
p4b2b1[10]  p4b2b1[9]  82.32  -147.636  7.15  0.498 
p4b2b1[11]  p4b2b1[10]  86.098  -149.631  7.414  0.529 
p4b2b1[12]  p4b2b1[11]  89.119  -151.386  9.813  0.534 
p4b2b1[13]  p4b2b1[12]  93.197  -153.156  10.66  0.500 
p4b2b1[14]  p4b2b1[13]  95.293  -156.822  12.443  0.494 
p4b2b1[15]  p4b2b1[14]  99.607  -158.193  13.5  0.487 
p4b2b1[16]  p4b2b1[15]  103.41  -161.151  13.5  0.470 
p4b2b1[17]  p4b2b1[16]  107.244  -163.395  14.828  0.488 
p4b2b1[18]  p4b2b1[17]  110.886  -165.952  15.77  0.498 
p4b2b1[19]  p4b2b1[18]  114.277  -168.457  17.100  0.512 
p4b2b1[20]  p4b2b1[19]  117.653  -170.306  18.83  0.537 
p4b2b1[21]  p4b2b1[20]  120.120  -171.473  21.670  0.575 
p4b2b1[22]  p4b2b1[21]  123.080  -174.053  23.48  0.524 
p4b2b1[23]  p4b2b1[22]  126.764  -174.162  25.4  0.545 
p4b2b1[24]  p4b2b1[23]  130.621  -176.14  26.42  0.508 
p4b2b1[25]  p4b2b1[24]  134.188  -178.368  27.45  0.523 
p4b2b1[26]  p4b2b1[25]  137.555  -179.669  27.83  0.624 
p4b2b1[27]  p4b2b1[26]  141.003  -181.874  27.872  0.553 
p4b2b1[28]  p4b2b1[27]  142.763  -184.691  29.276  0.628 
p4b2b1[29]  p4b2b1[28]  146.825  -184.341  30.989  0.512 
p4b2b1[30]  p4b2b1[29]  150.614  -184.531  33.57  0.494 
p4b2b1[31]  p4b2b1[30]  154.072  -185.724  34.59  0.596 
p4b2b1[32]  p4b2b1[31]  157.521  -187.901  36.37  0.509 

*compt /library/GP_dendrite_d300_dia1
p4b2b1[33]  p4b2b1[32]  160.908  -190.632  38.437  0.47 
p4b2b1[34]  p4b2b1[33]  165.31  -192.261  38.45  0.483 
p4b2b1[35]  p4b2b1[34]  168.613  -194.804  39.600  0.524 
p4b2b1[36]  p4b2b1[35]  171.947  -198.173  39.92  0.477 
p4b2b1[37]  p4b2b1[36]  174.18  -201.590  40.81  0.542 
p4b2b1[38]  p4b2b1[37]  176.815  -204.016  43.037  0.537 
p4b2b1[39]  p4b2b1[38]  180.44  -206.665  44.12  0.490 
p4b2b1[40]  p4b2b1[39]  183.316  -208.569  45.48  0.611 
p4b2b1[41]  p4b2b1[40]  186.545  -211.595  45.93  0.509 
p4b2b1[42]  p4b2b1[41]  188.775  -213.210  48.21  0.633 
p4b2b1[43]  p4b2b1[42]  191.22  -215.899  50.63  0.519 
p4b2b1[44]  p4b2b1[43]  192.328  -220.236  51.05  0.504 
p4b2b1[45]  p4b2b1[44]  195.295  -222.512  54.083  0.470 
p4b2b1[46]  p4b2b1[45]  197.886  -225.352  56.82  0.48 
p4b2b1[47]  p4b2b1[46]  199.596  -228.964  58.129  0.538 
p4b2b1[48]  p4b2b1[47]  201.128  -232.790  59.846  0.507 
p4b2b1[49]  p4b2b1[48]  204.442  -235.384  61.753  0.490 
p4b2b1[50]  p4b2b1[49]  205.716  -239.513  62.26  0.520 
p4b2b1[51]  p4b2b1[50]  207.692  -242.426  64.616  0.535 
p4b2b1[52]  p4b2b1[51]  209.164  -245.632  67.601  0.49 
p4b2b1[53]  p4b2b1[52]  210.662  -249.798  68.974  0.489 
p4b2b1[54]  p4b2b1[53]  211.314  -253.059  71.415  0.549 
p4b2b1[55]  p4b2b1[54]  210.794  -256.151  74.241  0.536 

*compt /library/GP_dendrite_d400_dia1
p4b2b1[56]  p4b2b1[55]  210.985  -256.744  77.487  0.685 
p4b2b1[57]  p4b2b1[56]  212.704  -257.497  76.618  1.095 
p4b2b1[58]  p4b2b1[57]  213.294  -259.128  80.4  0.544 
p4b2b1[59]  p4b2b1[58]  215.738  -260.903  83.508  0.522 
p4b2b1[60]  p4b2b1[59]  219.168  -262.650  81.029  0.495 
p4b2b1[61]  p4b2b1[60]  221.27  -266.67  79.16  0.47 

*compt /library/GP_dendrite_d100_dia0
p4b2b2[0]  p4b2[23]  39.704  -132.628  -1.02  0.496 
p4b2b2[1]  p4b2b2[0]  41.836  -136.919  -1.02  0.473 
p4b2b2[2]  p4b2b2[1]  44.315  -140.292  -1.02  0.369 
p4b2b2[3]  p4b2b2[2]  45.944  -144.09  -1.02  0.352 
p4b2b2[4]  p4b2b2[3]  46.717  -148.156  -1.02  0.352 
p4b2b2[5]  p4b2b2[4]  48.885  -151.676  -1.02  0.352 
p4b2b2[6]  p4b2b2[5]  50.106  -155.634  -1.02  0.351 
p4b2b2[7]  p4b2b2[6]  51.038  -159.678  -1.02  0.351 
p4b2b2[8]  p4b2b2[7]  51.657  -163.787  -1.02  0.350 
p4b2b2[9]  p4b2b2[8]  52.500  -167.841  -1.02  0.351 
p4b2b2[10]  p4b2b2[9]  53.778  -171.797  -1.02  0.35 

*compt /library/GP_dendrite_d200_dia0
p4b2b2[11]  p4b2b2[10]  55.766  -175.216  -2.251  0.351 
p4b2b2[12]  p4b2b2[11]  57.331  -178.487  -4.116  0.357 
p4b2b2[13]  p4b2b2[12]  58.370  -181.660  -6.69  0.35 

