// 	genesis
//
// 	Cell morphology file for GENESIS.
// 	Written by cvapp (http://www.neuro.soton.ac.uk/cells/#software).
//
//	GP5 = cell BG0121E
// 	Axon hillock and nodes of ranvier added 06/25/2004 by J. Edgerton
//	Axon hillock & axon taken from Mitral Cell model,
//	Shen et al (1999), J Neurophysiol. 82: 3006-3020
// 	Axon initial segment divided into 20 segments 07/09/2004 by J. Edgerton.
// 	Dendritic diameter subdivisions added 09/30/2004 by J. Edgerton.
//	Each dendritic prototype now has 2 defining variables:
//		d = distance from soma, with segments as follows:
//			d0 = 0-25 microns from soma
//			d25 = >25 to 50 microns
//			d50 = >50 to 100 microns
//			all remaining divisions are 100 microns long, 
//				e.g. d100 means 100 < d <= 200 microns from soma.
//		dia = diameter rating:
//			dia0 = < 0.5 microns
//			dia1 = 0.5 to 1 micron
//			dia2 = > 1 micron
//			CaHVA density is scaled based on diameter rating according to
//				Hanson & Smith, 2002.
//			Once a dendrite crosses the line between two ratings, it cannot
//				go back to a higher rating again even if the diam thickens.
//			If a transition occurs for a short stretch but the majority of
//				the dendrite distal to that stretch is at the previous level, 
//				ignore the transition.
//			In cases where it is oscillating around a transition, make the
//				transition occur where the compartment and 3 of the next 4
//				are at the new level.

*absolute
*asymmetric
*cartesisan

*lambda_warn .001 .01 --> check electrotonic lengths

*origin 0       0       0
*set_global RA       	{RA}
*set_global EREST_ACT   {EREST_ACT}

*set_compt_param RM	{RM_sd}
*set_compt_param CM	{CM}
*set_compt_param ELEAK	{ELEAK_sd}

*compt /library/GP_soma
soma  none    0  0  0  12.38

*compt /library/GP_axHill
axHill		soma		5	0	0	4.75

*set_compt_param RM       	{RM_ax}
*set_compt_param ELEAK		{ELEAK_ax}

*compt /library/GP_axIS
axIS[0]		axHill		7	0	0	1.5
axIS[1]		axIS[0]		9	0	0	1.5
axIS[2]		axIS[1]		11	0	0	1.5
axIS[3]		axIS[2]		13	0	0	1.5
axIS[4]		axIS[3]		15	0	0	1.5
axIS[5]		axIS[4]		17	0	0	1.5
axIS[6]		axIS[5]		19	0	0	1.5
axIS[7]		axIS[6]		21	0	0	1.5
axIS[8]		axIS[7]		23	0	0	1.5
axIS[9]		axIS[8]		25	0	0	1.5

*set_compt_param RM       	{RM_my}
*set_compt_param CM       	{CM_my}

*compt /library/GP_axIN
axIN[0]		axIS[9]		0	75	0	1.5
axIN[1]		axIN[0]		0	125	0	1.5
axIN[2]		axIN[1]		0	175	0	1.5
axIN[3]		axIN[2]		0	225	0	1.5
axIN[4]		axIN[3]		0	275	0	1.5
axIN[5]		axIN[4]		0	325	0	1.5
axIN[6]		axIN[5]		0	375	0	1.5
axIN[7]		axIN[6]		0	425	0	1.5
axIN[8]		axIN[7]		0	475	0	1.5
axIN[9]		axIN[8]		0	525	0	1.5
axIN[10]	axIN[9]		0	575	0	1.5
axIN[11]	axIN[10]	0	625	0	1.5
axIN[12]	axIN[11]	0	675	0	1.5
axIN[13]	axIN[12]	0	725	0	1.5
axIN[14]	axIN[13]	0	775	0	1.5
axIN[15]	axIN[14]	0	825	0	1.5
axIN[16]	axIN[15]	0	875	0	1.5
axIN[17]	axIN[16]	0	925	0	1.5
axIN[18]	axIN[17]	0	975	0	1.5
axIN[19]	axIN[18]	0	1025	0	1.5

*set_compt_param RM       	{RM_ax}
*set_compt_param CM       	{CM}
*set_compt_param ELEAK		{ELEAK_ax}

*compt /library/GP_axNode
axNode[0]	axIN[19]	0	1026	0	1

*set_compt_param RM       	{RM_my}
*set_compt_param CM       	{CM_my}

*compt /library/GP_axIN
axIN[20]	axNode[0]	0	1076	0	1.5
axIN[21]	axIN[20]	0	1126	0	1.5
axIN[22]	axIN[21]	0	1176	0	1.5
axIN[23]	axIN[22]	0	1226	0	1.5
axIN[24]	axIN[23]	0	1276	0	1.5
axIN[25]	axIN[24]	0	1326	0	1.5
axIN[26]	axIN[25]	0	1376	0	1.5
axIN[27]	axIN[26]	0	1426	0	1.5
axIN[28]	axIN[27]	0	1476	0	1.5
axIN[29]	axIN[28]	0	1526	0	1.5
axIN[30]	axIN[29]	0	1576	0	1.5
axIN[31]	axIN[30]	0	1626	0	1.5
axIN[32]	axIN[31]	0	1676	0	1.5
axIN[33]	axIN[32]	0	1726	0	1.5
axIN[34]	axIN[33]	0	1776	0	1.5
axIN[35]	axIN[34]	0	1826	0	1.5
axIN[36]	axIN[35]	0	1876	0	1.5
axIN[37]	axIN[36]	0	1926	0	1.5
axIN[38]	axIN[37]	0	1976	0	1.5
axIN[39]	axIN[38]	0	2026	0	1.5

*set_compt_param RM       	{RM_ax}
*set_compt_param CM       	{CM}

*compt /library/GP_axNode
axNode[1]	axIN[39]	0	2027	0	1

*set_compt_param RM       	{RM_my}
*set_compt_param CM       	{CM_my}

*compt /library/GP_axIN
axIN[40]	axNode[1]	0	2077	0	1.5
axIN[41]	axIN[40]	0	2127	0	1.5
axIN[42]	axIN[41]	0	2177	0	1.5
axIN[43]	axIN[42]	0	2227	0	1.5
axIN[44]	axIN[43]	0	2277	0	1.5
axIN[45]	axIN[44]	0	2327	0	1.5
axIN[46]	axIN[45]	0	2377	0	1.5
axIN[47]	axIN[46]	0	2427	0	1.5
axIN[48]	axIN[47]	0	2477	0	1.5
axIN[49]	axIN[48]	0	2527	0	1.5
axIN[50]	axIN[49]	0	2577	0	1.5
axIN[51]	axIN[50]	0	2627	0	1.5
axIN[52]	axIN[51]	0	2677	0	1.5
axIN[53]	axIN[52]	0	2727	0	1.5
axIN[54]	axIN[53]	0	2777	0	1.5
axIN[55]	axIN[54]	0	2827	0	1.5
axIN[56]	axIN[55]	0	2877	0	1.5
axIN[57]	axIN[56]	0	2927	0	1.5
axIN[58]	axIN[57]	0	2977	0	1.5
axIN[59]	axIN[58]	0	3027	0	1.5

*set_compt_param RM       	{RM_sd}
*set_compt_param CM       	{CM}
*set_compt_param ELEAK		{ELEAK_sd}

*compt /library/GP_dendrite_d0_dia2
p0[1]  soma  -6.309  4.758  0  1.858 
p0[2]  p0[1]  -11.735  11.652  -0.085  1.633 

*compt /library/GP_dendrite_d25_dia2
p0[3]  p0[2]  -16.183  16.448  -1.771  1.512 
p0[4]  p0[3]  -21.913  21.699  -2.04  1.313 
p0[5]  p0[4]  -27.322  25.748  -0.215  1.417 
p0[6]  p0[5]  -31.835  30.526  2.476  1.069 

*compt /library/GP_dendrite_d50_dia2
p0[7]  p0[6]  -35.066  36.006  5.432  1.082 
p0[8]  p0[7]  -37.752  40.979  8.274  1.2 
p0[9]  p0[8]  -38.154  46.558  9.530  1.597 
p0[10]  p0[9]  -41.919  49.724  15.016  1.819 
p0[11]  p0[10]  -45.557  51.880  16.375  2.862 
p0[12]  p0[11]  -53.149  51.017  18.058  1.493 
p0[13]  p0[12]  -60.662  53.779  16.67  1.438 

*compt /library/GP_dendrite_d100_dia2
p0[14]  p0[13]  -67.718  52.513  16.67  1.287 
p0[15]  p0[14]  -74.384  54.545  15.360  1.243 
p0[16]  p0[15]  -81.395  55.373  12.737  1.170 
p0[17]  p0[16]  -88.024  57.077  10.321  1.214 
p0[18]  p0[17]  -95.241  57.837  9.075  1.197 
p0[19]  p0[18]  -101.534  60.734  6.216  1.176 
p0[20]  p0[19]  -106.645  61.704  2.661  1.398 
p0[21]  p0[20]  -112.506  63.911  -1.186  1.199 
p0[22]  p0[21]  -117.419  63.84  -5.913  1.293 
p0[23]  p0[22]  -124.559  63.205  -7.854  1.187 
p0[24]  p0[23]  -130.44  64.196  -9.802  1.294 
p0[25]  p0[24]  -133.648  64.825  -16.201  1.056 
p0[26]  p0[25]  -138.469  65.071  -18.71  1.395 
p0[27]  p0[26]  -144.704  63.775  -21.325  1.102 
p0[28]  p0[27]  -150.674  64.08  -23.458  1.096 

*compt /library/GP_dendrite_d200_dia2
p0[29]  p0[28]  -156.39  63.59  -26.42  1.16 
p0b1[0]  p0[29]  -159.889  61.366  -29.854  1.363 
p0b1[1]  p0b1[0]  -159.087  58.082  -35.196  1.122 
p0b1[2]  p0b1[1]  -156.85  55.760  -41.16  1.05 

*compt /library/GP_dendrite_d200_dia1
p0b1b1[0]  p0b1[2]  -153.975  52.261  -43.473  0.852 
p0b1b1[1]  p0b1b1[0]  -149.709  49.622  -45.284  0.812 
p0b1b1[2]  p0b1b1[1]  -145.46  47.69  -47.85  0.81 
p0b1b1b1[0]  p0b1b1[2]  -140.564  45.725  -47.74  0.569 

*compt /library/GP_dendrite_d200_dia0
p0b1b1b1[1]  p0b1b1b1[0]  -136.928  43.351  -49.534  0.481 
p0b1b1b1[2]  p0b1b1b1[1]  -132.573  41.902  -49.032  0.489 
p0b1b1b1[3]  p0b1b1b1[2]  -128.025  40.732  -49.725  0.476 
p0b1b1b1[4]  p0b1b1b1[3]  -124.014  39.079  -50.276  0.516 
p0b1b1b1[5]  p0b1b1b1[4]  -119.657  39.095  -52.117  0.477 
p0b1b1b1[6]  p0b1b1b1[5]  -115.676  40.563  -53.97  0.488 
p0b1b1b1[7]  p0b1b1b1[6]  -111.418  41.7  -55.296  0.491 
p0b1b1b1[8]  p0b1b1b1[7]  -108.163  42.050  -58.385  0.502 
p0b1b1b1[9]  p0b1b1b1[8]  -105.967  42.606  -60.21  0.776 
p0b1b1b1[10]  p0b1b1b1[9]  -103.150  43.895  -61.777  0.651 
p0b1b1b1[11]  p0b1b1b1[10]  -103.212  44.609  -66.528  0.470 
p0b1b1b1[12]  p0b1b1b1[11]  -101.477  45.353  -70.009  0.570 

*compt /library/GP_dendrite_d300_dia0
p0b1b1b1[13]  p0b1b1b1[12]  -96.965  45.634  -69.28  0.493 
p0b1b1b1[14]  p0b1b1b1[13]  -93.824  47.04  -72.403  0.486 
p0b1b1b1[15]  p0b1b1b1[14]  -92.130  49.039  -76.171  0.492 
p0b1b1b1[16]  p0b1b1b1[15]  -89.255  50.264  -79.582  0.488 
p0b1b1b1[17]  p0b1b1b1[16]  -87.469  52.291  -83.133  0.506 
p0b1b1b1[18]  p0b1b1b1[17]  -85.441  56.52  -82.440  0.476 
p0b1b1b1[19]  p0b1b1b1[18]  -83.419  60.856  -82.440  0.472 
p0b1b1b1[20]  p0b1b1b1[19]  -81.134  63.089  -84.586  0.587 
p0b1b1b1[21]  p0b1b1b1[20]  -79.557  66.069  -86.29  0.598 
p0b1b1b1[22]  p0b1b1b1[21]  -77.065  69.858  -86.29  0.498 
p0b1b1b1[23]  p0b1b1b1[22]  -75.380  72.371  -89.185  0.68 
p0b1b1b1[24]  p0b1b1b1[23]  -74.564  75.853  -91.559  0.721 
p0b1b1b1[25]  p0b1b1b1[24]  -74.425  80.220  -94.158  0.609 
p0b1b1b1[26]  p0b1b1b1[25]  -74.18  84.802  -96.155  0.619 
p0b1b1b1[27]  p0b1b1b1[26]  -73.800  87.963  -100.264  0.596 
p0b1b1b1[28]  p0b1b1b1[27]  -73.980  90.185  -102.581  0.963 
p0b1b1b1[29]  p0b1b1b1[28]  -71.339  89.419  -104.296  0.955 
p0b1b1b1[30]  p0b1b1b1[29]  -69.840  92.246  -106.59  0.786 
p0b1b1b1[31]  p0b1b1b1[30]  -66.547  93.766  -107.678  0.959 
p0b1b1b1[32]  p0b1b1b1[31]  -67.251  97.08  -111.442  0.918 
p0b1b1b1[33]  p0b1b1b1[32]  -64.417  99.907  -111.350  1.025 
p0b1b1b1[34]  p0b1b1b1[33]  -63.638  102.566  -114.87  0.916 
p0b1b1b1[35]  p0b1b1b1[34]  -59.009  102.367  -116.484  0.837 

*compt /library/GP_dendrite_d400_dia0
p0b1b1b1[36]  p0b1b1b1[35]  -55.301  104.095  -119.395  0.818 
p0b1b1b1[37]  p0b1b1b1[36]  -49.76  105.52  -119.75  0.7 

*compt /library/GP_dendrite_d200_dia1
p0b1b1b2[0]  p0b1b1[2]  -143.971  49.901  -52.707  0.700 
p0b1b1b2[1]  p0b1b1b2[0]  -142.434  51.564  -57.253  0.614 
p0b1b1b2[2]  p0b1b1b2[1]  -140.835  52.515  -61.395  0.470 
p0b1b1b2[3]  p0b1b1b2[2]  -140.368  53.103  -65.87  0.470 
p0b1b1b2[4]  p0b1b1b2[3]  -139.92  53.685  -70.35  0.470 
p0b1b1b2[5]  p0b1b1b2[4]  -139.471  54.268  -74.830  0.47 
p0b1b1b2[6]  p0b1b1b2[5]  -138.974  55.198  -74.259  1.779 
p0b1b1b2[7]  p0b1b1b2[6]  -138.694  56.109  -75.143  1.641 
p0b1b1b2[8]  p0b1b1b2[7]  -138.6  56.680  -79.590  0.476 
p0b1b1b2[9]  p0b1b1b2[8]  -135.978  53.452  -80.564  0.5 
p0b1b1b2[10]  p0b1b1b2[9]  -133.596  50.880  -83  0.5 
p0b1b1b2[11]  p0b1b1b2[10]  -129.734  49.285  -84.181  0.491 
p0b1b1b2[12]  p0b1b1b2[11]  -126.124  47.896  -86.489  0.474 
p0b1b1b2[13]  p0b1b1b2[12]  -121.970  46.31  -86.75  0.47 

*compt /library/GP_dendrite_d200_dia0
p0b1b2[0]  p0b1[2]  -155.525  56.271  -45.383  0.47 
p0b1b2[1]  p0b1b2[0]  -154.200  56.782  -49.606  0.470 
p0b1b2[2]  p0b1b2[1]  -152.301  57.181  -53.616  0.470 
p0b1b2[3]  p0b1b2[2]  -152.552  59.935  -56.763  0.5 
p0b1b2[4]  p0b1b2[3]  -154.065  62.187  -60.029  0.493 
p0b1b2[5]  p0b1b2[4]  -157.2  63.914  -62.619  0.474 
p0b1b2[6]  p0b1b2[5]  -160.728  65.962  -63.889  0.490 
p0b1b2[7]  p0b1b2[6]  -164.499  67.221  -64.72  0.516 
p0b1b2[8]  p0b1b2[7]  -168.331  67.136  -66.534  0.494 
p0b1b2[9]  p0b1b2[8]  -172.478  68.128  -67.826  0.47 
p0b1b2[10]  p0b1b2[9]  -176.39  69.460  -69.62  0.47 
p0b1b2b1[0]  p0b1b2[10]  -179.160  73.019  -69.62  0.473 
p0b1b2b1[1]  p0b1b2b1[0]  -182.457  76.084  -69.62  0.474 
p0b1b2b1[2]  p0b1b2b1[1]  -185.897  78.655  -70.452  0.487 
p0b1b2b1[3]  p0b1b2b1[2]  -188.851  81.532  -72.339  0.470 
p0b1b2b1[4]  p0b1b2b1[3]  -189.780  84.708  -74.901  0.509 
p0b1b2b1[5]  p0b1b2b1[4]  -190.527  88.537  -76.78  0.492 

*compt /library/GP_dendrite_d300_dia0
p0b1b2b1[6]  p0b1b2b1[5]  -191.908  90.556  -79.986  0.529 
p0b1b2b1[7]  p0b1b2b1[6]  -194.87  90.77  -81.159  0.668 
p0b1b2b1[8]  p0b1b2b1[7]  -198.12  92.221  -82.676  0.551 
p0b1b2b1[9]  p0b1b2b1[8]  -201.751  90.829  -84.671  0.488 
p0b1b2b1[10]  p0b1b2b1[9]  -203.009  89.044  -85.438  0.921 
p0b1b2b1[11]  p0b1b2b1[10]  -205.266  89.893  -87.626  0.655 
p0b1b2b1[12]  p0b1b2b1[11]  -208.382  88.049  -89.851  0.502 
p0b1b2b1[13]  p0b1b2b1[12]  -210.92  87.09  -92.190  0.47 
p0b1b2b1b1[0]  p0b1b2b1[13]  -213.805  86.819  -93.875  0.485 
p0b1b2b1b1[1]  p0b1b2b1b1[0]  -216.682  86.815  -95.501  0.492 
p0b1b2b1b1[2]  p0b1b2b1b1[1]  -220.11  86.63  -95.14  0.47 
p0b1b2b1b2[0]  p0b1b2b1[13]  -213.886  84.536  -92.300  0.574 
p0b1b2b1b2[1]  p0b1b2b1b2[0]  -217.923  84.077  -92.606  0.552 
p0b1b2b1b2[2]  p0b1b2b1b2[1]  -221.703  83.982  -95.335  0.482 
p0b1b2b1b2[3]  p0b1b2b1b2[2]  -225.672  82.432  -96.180  0.518 
p0b1b2b1b2[4]  p0b1b2b1b2[3]  -230.11  81.210  -96.270  0.488 
p0b1b2b1b2[5]  p0b1b2b1b2[4]  -234.192  80.011  -97.692  0.501 
p0b1b2b1b2[6]  p0b1b2b1b2[5]  -237.876  77.467  -98.041  0.501 
p0b1b2b1b2[7]  p0b1b2b1b2[6]  -241.945  76.892  -95.59  0.470 
p0b1b2b1b2[8]  p0b1b2b1b2[7]  -244.06  73.5  -95.03  0.47 
p0b1b2b1b2b1[0]  p0b1b2b1b2[8]  -242.284  70.814  -95.03  0.472 
p0b1b2b1b2b1[1]  p0b1b2b1b2b1[0]  -240.83  68.085  -94.39  0.482 
p0b1b2b1b2b1[2]  p0b1b2b1b2b1[1]  -239.17  65.55  -93.210  0.47 
p0b1b2b1b2b2[0]  p0b1b2b1b2[8]  -245.588  70.109  -94.639  0.483 
p0b1b2b1b2b2[1]  p0b1b2b1b2b2[0]  -245.69  66.58  -93.100  0.47 

*compt /library/GP_dendrite_d200_dia0
p0b1b2b2[0]  p0b1b2[10]  -178.469  66.215  -66.958  0.47 
p0b1b2b2[1]  p0b1b2b2[0]  -180.992  62.409  -66.033  0.473 
p0b1b2b2[2]  p0b1b2b2[1]  -183.168  58.321  -65.65  0.474 
p0b1b2b2[3]  p0b1b2b2[2]  -184.776  53.962  -65.374  0.473 
p0b1b2b2[4]  p0b1b2b2[3]  -186.176  49.625  -64.373  0.472 

*compt /library/GP_dendrite_d300_dia0
p0b1b2b2[5]  p0b1b2b2[4]  -188.492  46.444  -63.109  0.394 
p0b1b2b2[6]  p0b1b2b2[5]  -190.894  43.606  -62.03  0.335 
p0b1b2b2[7]  p0b1b2b2[6]  -193.553  41.761  -62.03  0.233 
p0b1b2b2[8]  p0b1b2b2[7]  -195.504  41.055  -59.849  0.250 
p0b1b2b2[9]  p0b1b2b2[8]  -197.549  40.573  -57.594  0.245 
p0b1b2b2[10]  p0b1b2b2[9]  -200.46  39.97  -56.13  0.23 

*compt /library/GP_dendrite_d200_dia0
p0b2[0]  p0[29]  -158.287  64.953  -30.621  0.47 
p0b2[1]  p0b2[0]  -161.891  65.558  -32.09  0.573 
p0b2[2]  p0b2[1]  -166.493  66.435  -32.09  0.482 
p0b2[3]  p0b2[2]  -171.299  66.369  -32.09  0.470 
p0b2[4]  p0b2[3]  -176.037  65.668  -32.09  0.472 
p0b2[5]  p0b2[4]  -179.177  65.811  -35.366  0.498 
p0b2[6]  p0b2[5]  -182.567  66.388  -38.456  0.489 
p0b2[7]  p0b2[6]  -186.939  67.469  -40.135  0.47 
p0b2[8]  p0b2[7]  -191.132  69.210  -39.51  0.493 
p0b2[9]  p0b2[8]  -195.652  70.322  -39.434  0.485 
p0b2[10]  p0b2[9]  -200.047  72.240  -39.759  0.47 
p0b2[11]  p0b2[10]  -204.46  73.978  -40.03  0.475 
p0b2[12]  p0b2[11]  -209.264  74.118  -40.03  0.470 
p0b2[13]  p0b2[12]  -214.054  74.457  -40.03  0.470 
p0b2[14]  p0b2[13]  -218.829  75.006  -40.03  0.470 
p0b2[15]  p0b2[14]  -223.605  75.526  -40.03  0.470 
p0b2[16]  p0b2[15]  -228.115  76.354  -40.742  0.487 
p0b2[17]  p0b2[16]  -231.815  78.113  -42.798  0.455 
p0b2[18]  p0b2[17]  -234.878  80.800  -43.573  0.350 
p0b2[19]  p0b2[18]  -237.158  84.128  -43.638  0.36 

*compt /library/GP_dendrite_d300_dia0
p0b2[20]  p0b2[19]  -240.262  86.874  -43.476  0.35 
p0b2[21]  p0b2[20]  -243.786  88.713  -44.197  0.359 
p0b2[22]  p0b2[21]  -247.272  90.381  -45.447  0.357 
p0b2[23]  p0b2[22]  -249.61  93.322  -47.204  0.350 
p0b2[24]  p0b2[23]  -252.060  96.346  -48.3  0.359 
p0b2[25]  p0b2[24]  -254.856  99.307  -48.747  0.354 
p0b2[26]  p0b2[25]  -257.614  102.097  -50.094  0.35 
p0b2[27]  p0b2[26]  -260.843  104.364  -50.716  0.363 
p0b2[28]  p0b2[27]  -264.678  105.932  -50.523  0.350 
p0b2[29]  p0b2[28]  -268.199  107.452  -51.491  0.367 
p0b2[30]  p0b2[29]  -271.646  108.878  -53.302  0.350 
p0b2[31]  p0b2[30]  -274.823  111.076  -54.812  0.350 
p0b2[32]  p0b2[31]  -278.411  112.648  -56.055  0.353 
p0b2[33]  p0b2[32]  -282.062  112.841  -57.37  0.374 
p0b2[34]  p0b2[33]  -285.55  112.281  -58.525  0.391 
p0b2[35]  p0b2[34]  -287.405  112.326  -62.089  0.361 
p0b2[36]  p0b2[35]  -287.913  111.545  -66.124  0.351 
p0b2[37]  p0b2[36]  -289.717  112.148  -69.253  0.396 
p0b2[38]  p0b2[37]  -289.102  112.754  -72.551  0.426 
p0b2[39]  p0b2[38]  -287.052  114.422  -75.728  0.351 
p0b2[40]  p0b2[39]  -284.609  115.028  -78.929  0.356 
p0b2[41]  p0b2[40]  -282.099  115.183  -82.206  0.351 
p0b2[42]  p0b2[41]  -280.53  115.850  -85.729  0.371 
p0b2[43]  p0b2[42]  -279.269  115.679  -89.193  0.393 
p0b2[44]  p0b2[43]  -277.307  116.926  -91.917  0.405

*compt /library/GP_dendrite_d400_dia0
p0b2[45]  p0b2[44]  -277.126  117.313  -96.042  0.35 
p0b2[46]  p0b2[45]  -276.946  117.700  -100.168  0.350 
p0b2[47]  p0b2[46]  -276.765  118.087  -104.293  0.35 
p0b2[48]  p0b2[47]  -276.493  118.593  -108.196  0.368 
p0b2[49]  p0b2[48]  -274.499  120.416  -111.306  0.352 
p0b2[50]  p0b2[49]  -275.210  123.415  -112.490  0.44 
p0b2[51]  p0b2[50]  -277.295  125.319  -110.365  0.411 
p0b2[52]  p0b2[51]  -278.206  122.98  -110.967  0.562 
p0b2[53]  p0b2[52]  -276.96  121.42  -111.240  0.35 

*compt /library/GP_dendrite_d0_dia2
p1[1]  soma  2.552  -3.313  -7.710  1.998 
p1[2]  p1[1]  6.273  -7.076  -7.710  3.312 
p1[3]  p1[2]  10.352  -11.173  -11.000  2.208 

*compt /library/GP_dendrite_d25_dia2
p1[4]  p1[3]  12.346  -17.821  -12.727  1.600 
p1[5]  p1[4]  14.290  -22.818  -16.792  1.572 
p1[6]  p1[5]  15.424  -28.78  -19.73  1.280 

*compt /library/GP_dendrite_d50_dia2
p1[7]  p1[6]  19.033  -33.520  -20.559  1.435 
p1[8]  p1[7]  20.611  -39.688  -22.405  1.302 
p1[9]  p1[8]  22.560  -42.97  -28.12  1.16 
p1b1[0]  p1[9]  25.978  -47.245  -28.977  1.576 
p1b1[1]  p1b1[0]  30.198  -48.637  -33.145  1.433 
p1b1[2]  p1b1[1]  29.795  -50.343  -38.710  1.497 
p1b1[3]  p1b1[2]  29.385  -56.939  -39.313  1.316 
p1b1[4]  p1b1[3]  35.695  -60.614  -40.37  1.183 

*compt /library/GP_dendrite_d100_dia2
p1b1[5]  p1b1[4]  40.457  -66.109  -40.464  1.201 
p1b1[6]  p1b1[5]  44.857  -69.417  -43.58  1.380 
p1b1[7]  p1b1[6]  50.165  -72.394  -45.414  1.310 
p1b1[8]  p1b1[7]  54.200  -75.791  -46.04  1.225 
p1b1[9]  p1b1[8]  57.731  -80.066  -49.269  0.977 
p1b1[10]  p1b1[9]  60.93  -83.582  -52.683  1.071 
p1b1[11]  p1b1[10]  64.369  -87.868  -54.820  1.063 
p1b1[12]  p1b1[11]  68.667  -90.842  -55.379  1.192 
p1b1[13]  p1b1[12]  68.934  -95.889  -55.734  1.237 
p1b1[14]  p1b1[13]  67.852  -99.363  -60.741  1.013 
p1b1[15]  p1b1[14]  70.081  -104.220  -62.659  1.104 
p1b1[16]  p1b1[15]  67.453  -109.839  -64.848  0.953 
p1b1[17]  p1b1[16]  66.144  -114.753  -66.205  1.191 
p1b1[18]  p1b1[17]  65.671  -120.853  -67.568  1 
p1b1[19]  p1b1[18]  65.698  -126.434  -70.074  1.025 

*compt /library/GP_dendrite_d100_dia1
p1b1[20]  p1b1[19]  61.328  -131.077  -70.817  0.976 
p1b1[21]  p1b1[20]  57.280  -135.524  -72.350  0.919 

*compt /library/GP_dendrite_d200_dia1
p1b1[22]  p1b1[21]  53.670  -140.316  -72.350  0.849 
p1b1[23]  p1b1[22]  52.548  -145.850  -74.334  0.851 
p1b1[24]  p1b1[23]  49.06  -150.262  -75.353  0.891 
p1b1[25]  p1b1[24]  44.426  -154.133  -75.75  0.758 
p1b1[26]  p1b1[25]  40.382  -158.074  -75.75  0.669 

*compt /library/GP_dendrite_d200_dia0
p1b1[27]  p1b1[26]  36.928  -161.379  -75.75  0.471 
p1b1[28]  p1b1[27]  33.126  -164.244  -75.75  0.473 
p1b1[29]  p1b1[28]  29.190  -166.972  -75.75  0.470 
p1b1[30]  p1b1[29]  26.121  -170.505  -74.789  0.471 
p1b1[31]  p1b1[30]  22.899  -173.769  -73.692  0.477 
p1b1[32]  p1b1[31]  18.676  -175.488  -72.22  0.470 
p1b1[33]  p1b1[32]  14.695  -177.261  -70.273  0.472 
p1b1[34]  p1b1[33]  10.854  -179.380  -68.533  0.477 
p1b1[35]  p1b1[34]  6.944  -181.987  -67.6  0.470 
p1b1[36]  p1b1[35]  2.78  -184.319  -67.355  0.471 
p1b1[37]  p1b1[36]  -1.191  -186.91  -67.212  0.475 
p1b1[38]  p1b1[37]  -4.024  -190.694  -67.153  0.476 
p1b1[39]  p1b1[38]  -6.044  -195.037  -67.212  0.47 
p1b1[40]  p1b1[39]  -8.253  -199.279  -67.25  0.471 
p1b1[41]  p1b1[40]  -10.786  -203.347  -67.25  0.47 

*compt /library/GP_dendrite_d300_dia0
p1b1[42]  p1b1[41]  -13.318  -207.414  -67.25  0.47 
p1b1[43]  p1b1[42]  -15.85  -211.481  -67.25  0.47 
p1b1[44]  p1b1[43]  -19.254  -214.846  -67.278  0.470 
p1b1[45]  p1b1[44]  -22.687  -218.189  -67.306  0.47 
p1b1[46]  p1b1[45]  -26.12  -221.531  -67.335  0.47 
p1b1[47]  p1b1[46]  -29.581  -224.823  -67.36  0.471 
p1b1[48]  p1b1[47]  -32.665  -228.49  -67.36  0.470 
p1b1[49]  p1b1[48]  -35.748  -232.157  -67.36  0.470 
p1b1[50]  p1b1[49]  -38.658  -235.963  -67.36  0.470 
p1b1[51]  p1b1[50]  -39.316  -240.610  -67.36  0.48 
p1b1[52]  p1b1[51]  -38.4  -245.239  -67.36  0.477 
p1b1[53]  p1b1[52]  -36.791  -249.742  -67.36  0.471 
p1b1[54]  p1b1[53]  -34.606  -254.006  -67.36  0.470 
p1b1[55]  p1b1[54]  -32.362  -258.24  -67.36  0.470 
p1b1[56]  p1b1[55]  -30.132  -262.48  -67.36  0.470 
p1b1[57]  p1b1[56]  -28.056  -266.786  -67.36  0.471 
p1b1[58]  p1b1[57]  -26.735  -271.372  -67.36  0.472 
p1b1[59]  p1b1[58]  -26.003  -275.935  -66.772  0.483 
p1b1[60]  p1b1[59]  -26.152  -280.604  -65.709  0.470 
p1b1[61]  p1b1[60]  -26.404  -285.290  -64.881  0.473 
p1b1[62]  p1b1[61]  -27.039  -290.039  -64.936  0.47 

*compt /library/GP_dendrite_d400_dia0
p1b1[63]  p1b1[62]  -27.476  -294.792  -65.021  0.472 
p1b1[64]  p1b1[63]  -27.099  -299.564  -65.230  0.470 
p1b1[65]  p1b1[64]  -26.724  -304.212  -65.574  0.482 
p1b1[66]  p1b1[65]  -25.998  -308.827  -66.638  0.47 
p1b1[67]  p1b1[66]  -24.456  -313.178  -67.25  0.484 
p1b1[68]  p1b1[67]  -22.249  -317.417  -67.25  0.471 
p1b1[69]  p1b1[68]  -20.11  -322.08  -67.25  0.47 
p1b1b1[0]  p1b1[69]  -15.882  -324.395  -67.25  0.47 
p1b1b1[1]  p1b1b1[0]  -12.687  -327.724  -66.376  0.482 
p1b1b1[2]  p1b1b1[1]  -8.576  -329.875  -65.770  0.484 
p1b1b1[3]  p1b1b1[2]  -5.275  -332.667  -65.770  0.524 
p1b1b1[4]  p1b1b1[3]  -2.811  -336.081  -64.391  0.511 
p1b1b1[5]  p1b1b1[4]  -0.11  -338.43  -61.12  0.47 
p1b1b2[0]  p1b1[69]  -20.201  -326.792  -67.159  0.47 
p1b1b2[1]  p1b1b2[0]  -21.842  -331.07  -67.130  0.483 
p1b1b2[2]  p1b1b2[1]  -25.766  -333.539  -67.006  0.478 
p1b1b2[3]  p1b1b2[2]  -29.561  -334.734  -64.479  0.470 
p1b1b2[4]  p1b1b2[3]  -33.126  -336.848  -62.293  0.473 
p1b1b2[5]  p1b1b2[4]  -37.106  -338.668  -60.882  0.482 
p1b1b2[6]  p1b1b2[5]  -40.671  -341.180  -59.364  0.48 
p1b1b2[7]  p1b1b2[6]  -44.518  -342.892  -58.279  0.51 
p1b1b2[8]  p1b1b2[7]  -49.068  -343.332  -57.713  0.481 
p1b1b2[9]  p1b1b2[8]  -52.801  -345.185  -55.512  0.470 
p1b1b2[10]  p1b1b2[9]  -56.882  -346.256  -53.505  0.474 
p1b1b2[11]  p1b1b2[10]  -60.65  -347.383  -53.047  0.56 
p1b1b2[12]  p1b1b2[11]  -63.068  -349.964  -55.785  0.495 
p1b1b2[13]  p1b1b2[12]  -65.452  -353.896  -54.749  0.47 

*compt /library/GP_dendrite_d500_dia0
p1b1b2[14]  p1b1b2[13]  -67.317  -357.954  -54.21  0.492 
p1b1b2[15]  p1b1b2[14]  -68.36  -362.63  -54.21  0.47 

*compt /library/GP_dendrite_d50_dia1
p1b2[0]  p1[9]  24.236  -46.972  -25.225  0.987 
p1b2[1]  p1b2[0]  25.92  -52.908  -26.641  0.813 
p1b2[2]  p1b2[1]  27.127  -58.627  -28.272  0.848 
p1b2[3]  p1b2[2]  31.392  -63.018  -27.56  0.835 
p1b2[4]  p1b2[3]  34.354  -68.279  -27.56  0.853 
p1b2[5]  p1b2[4]  39.465  -69.79  -27.56  0.966 

*compt /library/GP_dendrite_d100_dia1
p1b2[6]  p1b2[5]  42.983  -74.887  -27.56  0.831 
p1b2[7]  p1b2[6]  46.914  -79.474  -27.56  0.852 
p1b2[8]  p1b2[7]  50.820  -84.362  -28.418  0.815 
p1b2[9]  p1b2[8]  54.246  -89.308  -30.399  0.813 
p1b2[10]  p1b2[9]  58.74  -93.332  -31.865  0.829 
p1b2[11]  p1b2[10]  63.432  -97.083  -33.644  0.822 
p1b2[12]  p1b2[11]  67.405  -101.742  -34.959  0.822 
p1b2[13]  p1b2[12]  72.050  -106.075  -35.131  0.81 
p1b2[14]  p1b2[13]  73.183  -109.92  -35.765  1.268 
p1b2[15]  p1b2[14]  72.481  -113.314  -40.621  0.863 
p1b2[16]  p1b2[15]  70.12  -118.069  -42.187  0.93 
p1b2[17]  p1b2[16]  70.621  -123.450  -42.98  0.785 
p1b2[18]  p1b2[17]  68.478  -127.304  -43.730  0.697 
p1b2[19]  p1b2[18]  66.141  -127.396  -48.572  0.58 
p1b2[20]  p1b2[19]  62.629  -130.782  -48.76  0.639 
p1b2[21]  p1b2[20]  58.205  -133.222  -48.853  0.617 
p1b2[22]  p1b2[21]  53.978  -136.43  -49.662  0.581

*compt /library/GP_dendrite_d200_dia1
p1b2[23]  p1b2[22]  49.541  -138.616  -50.695  0.617 
p1b2[24]  p1b2[23]  47.910  -139.15  -45.93  0.58 

