//	CELL BG0122B
//	genesis
//	Cell	morphology	file	for	GENESIS.
//	Written	by	cvapp	(http://www.neuro.soton.ac.uk/cells/#software).
//	Axon modeled according to Shen et al (1999), J Neurophysiol. 82: 3006-20.
//	Soma modeled as sphere, with volume conserved relative to cylinder of 
//		16 X 10 um.
//	To conserve surface area, diameter would be 12.65 um assuming open ends,
//		14.5 microns assuming closed ends. So volume conservation (d = 13.4)
//		is a reasonable middle ground.

*absolute
*asymmetric
*cartesian

*lambda_warn .001 .02 --> check electrotonic lengths

*origin 0       0       0
*set_global RA       	{RA}
*set_global EREST_ACT   {EREST_ACT}

*set_compt_param RM	{RM_sd}
*set_compt_param CM	{CM}
*set_compt_param ELEAK	{ELEAK_sd}


*compt	/library/GP_soma
soma	none	0	0	0	13.4	

*compt	/library/GP_dendrite_p
p0[1]	soma	-7.469	1.291	1.43	1.368	
p0[2]	p0[1]	-14.907	2.791	2.49	1.322	
p0[3]	p0[2]	-22.775	3.411	2.49	1.283	
p0[4]	p0[3]	-29.79	1.966	4.31	1.235	
p0[5]	p0[4]	-36.593	2.259	5.265	1.094	
p0[6]	p0[5]	-42.401	0.396	8.622	1.080	
p0[7]	p0[6]	-48.765	-1.687	9.711	1.109	
p0[8]	p0[7]	-54.95	-4.192	10.483	1.12	
p0[9]	p0[8]	-61.665	-6.086	11.79	1.06	
p0[10]	p0[9]	-67.341	-7.978	14.025	1.078	
p0[11]	p0[10]	-73.322	-8.278	16.1	0.989	
p0[12]	p0[11]	-79.556	-9.063	16.44	0.867	
p0[13]	p0[12]	-85.538	-7.861	16.44	0.835	
p0[14]	p0[13]	-91.009	-7.558	18.94	0.846	
p0[15]	p0[14]	-96.733	-9.716	19.537	0.829	
p0[16]	p0[15]	-102.528	-10.335	20.64	0.859	
p0[17]	p0[16]	-106.589	-14.681	20.64	0.857	
p0[18]	p0[17]	-111.230	-18.218	21.986	0.851	
p0[19]	p0[18]	-114.765	-23.262	22.625	0.823	
p0[20]	p0[19]	-117.267	-28.691	23.888	0.834	
p0[21]	p0[20]	-119.009	-34.697	24.500	0.811	
p0[22]	p0[21]	-119.840	-40.877	24.61	0.817	
p0[23]	p0[22]	-122.045	-46.729	24.9	0.814	
p0[24]	p0[23]	-125.055	-52.223	25.29	0.812	
p0[25]	p0[24]	-128.151	-57.675	25.29	0.813	
p0[26]	p0[25]	-130.477	-63.498	25.29	0.813	
p0[27]	p0[26]	-134.649	-67.979	25.948	0.828	
p0[28]	p0[27]	-137.66	-73.435	25.970	0.818	
p0[29]	p0[28]	-140.569	-78.567	25.970	0.864	
p0[30]	p0[29]	-144.864	-82.962	25.970	0.829	
p0[31]	p0[30]	-147.539	-88.5	26.766	0.822	
p0[32]	p0[31]	-150.540	-93.789	27.78	0.827	
p0[33]	p0[32]	-155.714	-97.224	27.78	0.821	
p0[34]	p0[33]	-161.576	-99.366	27.78	0.817	
p0[35]	p0[34]	-167.485	-101.139	27.78	0.826	
p0[36]	p0[35]	-172.605	-104.681	27.78	0.819	
p0[37]	p0[36]	-178.739	-105.962	27.78	0.813	
p0[38]	p0[37]	-184.872	-107.094	27.079	0.812	
p0[39]	p0[38]	-190.968	-108.310	26.525	0.817	
p0[40]	p0[39]	-196.142	-111.75	25.85	0.816	
p0[41]	p0[40]	-201.687	-114.466	25.85	0.825	
p0[42]	p0[41]	-207.287	-117.144	25.85	0.821	
p0[43]	p0[42]	-212.559	-119.697	25.85	0.870	
p0[44]	p0[43]	-218.166	-122.179	25.85	0.831	
p0[45]	p0[44]	-223.987	-124.334	26.795	0.812	
p0[46]	p0[45]	-229.23	-127.539	27.771	0.819	
p0[47]	p0[46]	-234.165	-131.289	28.392	0.818	
p0[48]	p0[47]	-238.141	-135.718	30.060	0.825	
p0[49]	p0[48]	-240.497	-141.460	30.28	0.821	
p0[50]	p0[49]	-244.070	-145.805	32.468	0.844	
p0[51]	p0[50]	-248.43	-150.522	32.43	0.919	
p0b1[1]	p0[51]	-249.13	-156.196	32.43	1.095	
p0b1b1[1]	p0b1[1]	-247.926	-158.764	32.32	0.522	
p0b1b1[2]	p0b1b1[1]	-246.306	-162.647	33.47	0.481	
p0b1b1[3]	p0b1b1[2]	-244.636	-166.408	35.04	0.477	
p0b1b1[4]	p0b1b1[3]	-242.861	-170.264	35.04	0.432	
p0b1b1[5]	p0b1b1[4]	-241.013	-173.644	35.04	0.350	
p0b1b1[6]	p0b1b1[5]	-239.548	-177.111	35.27	0.35	
p0b1b2[1]	p0b1[1]	-244.9	-154.771	32.43	0.519	
p0b1b2[2]	p0b1b2[1]	-240.793	-155.754	31.300	0.481	
p0b1b2[3]	p0b1b2[2]	-236.975	-157.955	31.300	0.47	
p0b1b3[0]	p0b1[1]	-252.371	-159.144	34.208	0.663	
p0b1b3b1[1]	p0b1b3[0]	-254.272	-156.739	34.153	0.371	
p0b1b3b1[2]	p0b1b3b1[1]	-256.961	-156.316	35.483	0.376	
p0b1b3b1[3]	p0b1b3b1[2]	-259.580	-156.382	37.420	0.35	
p0b1b3b1[4]	p0b1b3b1[3]	-262.713	-155.811	37.673	0.35	
p0b1b3b2[0]	p0b1b3[0]	-253.518	-163.738	34.273	0.480	
p0b1b3b2[1]	p0b1b3b2[0]	-255.667	-167.347	35.128	0.529	
p0b1b3b2[2]	p0b1b3b2[1]	-255.561	-172.080	35.561	0.477	
p0b1b3b2[3]	p0b1b3b2[2]	-256.105	-176.762	36.4	0.474	
p0b1b3b2[4]	p0b1b3b2[3]	-256.943	-181.334	36.937	0.485	
p0b1b3b2[5]	p0b1b3b2[4]	-257.232	-185.726	38.33	0.491	
p0b1b3b2[6]	p0b1b3b2[5]	-259.467	-189.975	38.33	0.472	
p0b1b3b2[7]	p0b1b3b2[6]	-262.170	-193.778	38.33	0.486	
p0b1b3b2[8]	p0b1b3b2[7]	-264.599	-197.797	38.33	0.483	
p0b1b3b2[9]	p0b1b3b2[8]	-265.993	-202.416	38.33	0.470	
p0b1b3b2[10]	p0b1b3b2[9]	-267.387	-207.009	38.33	0.472	
p0b1b3b2[11]	p0b1b3b2[10]	-268.33	-211.682	38.33	0.476	
p0b1b3b2[12]	p0b1b3b2[11]	-270.475	-215.904	38.66	0.478	
p0b1b3b2[13]	p0b1b3b2[12]	-270.187	-220.117	38.78	0.537	
p0b1b3b2[14]	p0b1b3b2[13]	-268.263	-224.528	38.78	0.471	
p0b1b3b2[15]	p0b1b3b2[14]	-265.658	-228.517	38.867	0.476	
p0b1b3b2[16]	p0b1b3b2[15]	-264.614	-233.081	39.939	0.472	
p0b1b3b2[17]	p0b1b3b2[16]	-263.420	-237.317	41.915	0.47	
p0b1b3b2[18]	p0b1b3b2[17]	-261.985	-240.891	44.387	0.495	
p0b1b3b2[19]	p0b1b3b2[18]	-259.760	-243.689	47.410	0.484	
p0b1b3b2[20]	p0b1b3b2[19]	-256.573	-245.075	50.753	0.470	
p0b1b3b2[21]	p0b1b3b2[20]	-253.656	-246.155	54.434	0.470	
p0b1b3b2[22]	p0b1b3b2[21]	-251.002	-247.833	57.796	0.493	
p0b1b3b2[23]	p0b1b3b2[22]	-247.243	-248.013	61.800	1.692	
p0b1b3b2b1[1]	p0b1b3b2[23]	-249.319	-249.089	67.731	0.81	
p0b1b3b2b1[2]	p0b1b3b2b1[1]	-248.696	-252.035	70.180	0.978	
p0b1b3b2b1[3]	p0b1b3b2b1[2]	-249.254	-253.361	73.996	0.35	
p0b1b3b2b1[4]	p0b1b3b2b1[3]	-252.371	-255.265	75.41	0.364	
p0b1b3b2b1[5]	p0b1b3b2b1[4]	-255.191	-257.410	76.689	0.379	
p0b1b3b2b1[6]	p0b1b3b2b1[5]	-257.195	-260.42	77.56	0.384	
p0b1b3b2b1[7]	p0b1b3b2b1[6]	-258.778	-263.931	78.274	0.364	
p0b1b3b2b1[8]	p0b1b3b2b1[7]	-259.907	-267.164	80.451	0.352	
p0b1b3b2b1[9]	p0b1b3b2b1[8]	-260.891	-270.660	82.33	0.35	
p0b1b3b2b2[0]	p0b1b3b2[23]	-245.717	-245.801	65.541	1.502	
p0b1b3b2b2[1]	p0b1b3b2b2[0]	-244.911	-247.272	71.731	0.964	
p0b1b3b2b2[2]	p0b1b3b2b2[1]	-241.908	-250.288	73.430	0.745	
p0b1b3b2b2[3]	p0b1b3b2b2[2]	-239.316	-252.052	75.64	0.591	
p0b1b3b2b2[4]	p0b1b3b2b2[3]	-236.523	-254.463	78.660	0.476	
p0b1b3b2b2[5]	p0b1b3b2b2[4]	-233.274	-257.348	79.95	0.500	
p0b1b3b2b2[6]	p0b1b3b2b2[5]	-230.316	-259.294	81.900	0.561	
p0b1b3b2b2[7]	p0b1b3b2b2[6]	-227.717	-261.427	84.521	0.532	
p0b1b3b2b2[8]	p0b1b3b2b2[7]	-225.36	-263.726	87.426	0.516	
p0b1b3b2b2b1[1]	p0b1b3b2b2[8]	-222.008	-265.806	87.31	0.459	
p0b1b3b2b2b1[2]	p0b1b3b2b2b1[1]	-220.526	-268.908	87.31	0.359	
p0b1b3b2b2b1[3]	p0b1b3b2b2b1[2]	-221.29	-272.248	87.31	0.35	
p0b1b3b2b2b2[0]	p0b1b3b2b2[8]	-225.840	-268.029	87.2	0.523	
p0b1b3b2b2b2[1]	p0b1b3b2b2b2[0]	-224.830	-272.862	87.09	0.47	
p0b2[0]	p0[51]	-254.606	-150.370	32.43	1.024	
p0b2[1]	p0b2[0]	-259.75	-150.882	32.43	0.618	
p0b2[2]	p0b2[1]	-262.531	-150.671	35.813	0.514	
p0b2[3]	p0b2[2]	-267.232	-149.858	35.83	0.472	
p0b2[4]	p0b2[3]	-271.87	-149.276	36.103	0.481	
p0b2[5]	p0b2[4]	-276.362	-147.801	36.63	0.474	
p0b2[6]	p0b2[5]	-280.944	-146.427	36.63	0.471	
p0b2[7]	p0b2[6]	-285.591	-145.297	36.63	0.471	
p0b2[8]	p0b2[7]	-289.51	-142.543	36.63	0.470	
p0b2[9]	p0b2[8]	-293.648	-140.472	35.805	0.479	
p0b2[10]	p0b2[9]	-297.359	-137.768	35.27	0.487	
p0b2[11]	p0b2[10]	-300.408	-134.07	35.27	0.470	
p0b2[12]	p0b2[11]	-303.457	-130.371	35.27	0.47	
p0b2[13]	p0b2[12]	-306.403	-126.591	35.27	0.470	
p0b2[14]	p0b2[13]	-309.344	-122.807	35.27	0.470	
p0b2[15]	p0b2[14]	-312.305	-119.037	35.27	0.470	
p0b2[16]	p0b2[15]	-315.266	-115.267	35.27	0.47	
p0b2b1[1]	p0b2[16]	-318.668	-114.845	35.04	0.233	
p0b2b1[2]	p0b2b1[1]	-321.991	-115.246	35.04	0.230	
p0b2b1[3]	p0b2b1[2]	-325.338	-115.286	35.04	0.230	
p0b2b1[4]	p0b2b1[3]	-328.522	-114.597	35.04	0.237	
p0b2b1[5]	p0b2b1[4]	-331.677	-114.046	35.765	0.235	
p0b2b1[6]	p0b2b1[5]	-334.778	-113.483	36.444	0.239	
p0b2b1[7]	p0b2b1[6]	-337.863	-112.583	36.386	0.24	
p0b2b1[8]	p0b2b1[7]	-340.725	-112.583	34.59	0.23	
p0b2b2[0]	p0b2[16]	-318.156	-111.507	35.27	0.475	
p0b2b2[1]	p0b2b2[0]	-320.407	-108.242	35.27	0.424	
p0b2b2[2]	p0b2b2[1]	-322.770	-105.63	35.27	0.23	

p1b2[0]	soma	-4.363	5.227	-0.79	1.001	
p1b2[1]	p1b2[0]	-8.004	10.167	-1.130	0.785	
p1b2[2]	p1b2[1]	-12.078	14.409	-1.253	0.702	
p1b2[3]	p1b2[2]	-15.419	19.191	-1.81	0.705	
p1b2[4]	p1b2[3]	-17.755	24.163	-1.81	0.62	
p1b2[5]	p1b2[4]	-19.167	28.618	-1.985	0.486	
p1b2[6]	p1b2[5]	-21.309	32.89	-2.49	0.473	
p1b2[7]	p1b2[6]	-23.653	37.118	-2.49	0.470	
p1b2[8]	p1b2[7]	-26.052	41.317	-2.49	0.47	
p1b2[9]	p1b2[8]	-28.425	45.530	-2.49	0.470	
p1b2[10]	p1b2[9]	-30.517	49.833	-2.49	0.475	
p1b2[11]	p1b2[10]	-33.124	53.881	-2.567	0.472	
p1b2[12]	p1b2[11]	-35.694	57.965	-2.61	0.471	
p1b2[13]	p1b2[12]	-37.598	62.384	-2.61	0.472	
p1b2[14]	p1b2[13]	-38.780	67.056	-2.61	0.472	
p1b2[15]	p1b2[14]	-39.595	71.817	-2.61	0.471	
p1b2[16]	p1b2[15]	-40.19	76.564	-2.61	0.475	
p1b2[17]	p1b2[16]	-39.922	81.362	-2.61	0.473	
p1b2[18]	p1b2[17]	-40.528	85.787	-1.634	0.497	
p1b2[19]	p1b2[18]	-41.162	89.668	0.68	0.498	
p1b2[20]	p1b2[19]	-43.047	93.998	1.018	0.480	
p1b2[21]	p1b2[20]	-45.745	97.292	3.277	0.472	
p1b2[22]	p1b2[21]	-48.976	100.717	4.376	0.47	
p1b2[23]	p1b2[22]	-51.656	104.221	4.965	0.418	
p1b2[24]	p1b2[23]	-53.733	107.805	5.306	0.351	
p1b2[25]	p1b2[24]	-55.620	111.370	6.375	0.35	
p1b2[26]	p1b2[25]	-57.556	114.934	7.341	0.350	
p1b2[27]	p1b2[26]	-59.728	118.42	7.992	0.351	
p1b2[28]	p1b2[27]	-62.531	121.493	8.332	0.350	
p1b2[29]	p1b2[28]	-65.333	124.567	8.672	0.350	
p1b2[30]	p1b2[29]	-66.811	127.712	8.73	0.257	
p1b2[31]	p1b2[30]	-67.224	130.964	8.73	0.237	
p1b2[32]	p1b2[31]	-66.739	134.312	8.73	0.230	
p1b2[33]	p1b2[32]	-65.64	137.511	8.73	0.23	
p1b2[34]	p1b2[33]	-64.451	140.674	8.73	0.230	
p1b2[35]	p1b2[34]	-63.062	143.759	8.73	0.23	
p1b2[36]	p1b2[35]	-61.674	146.844	8.73	0.230	
p1b2[37]	p1b2[36]	-60.672	150.072	8.73	0.230	
p1b2[38]	p1b2[37]	-59.861	153.348	8.73	0.231	
p1b2[39]	p1b2[38]	-59.404	156.7	8.73	0.230	
p1b2[40]	p1b2[39]	-59.371	160.075	8.73	0.231	
p1b2[41]	p1b2[40]	-59.867	163.392	8.524	0.232	
p1b2[42]	p1b2[41]	-60.656	166.662	8.168	0.230	
p1b2[43]	p1b2[42]	-61.347	169.95	7.94	0.231	
p1b2[44]	p1b2[43]	-62.175	173.23	7.94	0.230	
p1b2[45]	p1b2[44]	-62.016	176.540	7.94	0.235	
p1b2[46]	p1b2[45]	-61.559	179.874	7.94	0.231	
p1b2[47]	p1b2[46]	-61.822	183.247	7.94	0.230	
p1b2[48]	p1b2[47]	-61.995	186.623	8.035	0.230	
p1b2[49]	p1b2[48]	-62.158	190.001	8.142	0.230	
p1b2[50]	p1b2[49]	-61.883	193.361	8.17	0.231	
p1b2[51]	p1b2[50]	-61.830	196.732	8.17	0.231	
p1b2[52]	p1b2[51]	-60.772	197.405	10.860	0.262	
p1b2[53]	p1b2[52]	-58.766	200.838	10.66	0.701	
p1b2[54]	p1b2[53]	-59.082	204.733	10.66	0.676	
p1b2[55]	p1b2[54]	-59.3	206.764	14.86	0.578	
p1b2[56]	p1b2[55]	-62.199	209.189	14.86	0.304	
p1b2[57]	p1b2[56]	-64.487	210.965	16.607	0.230	
p1b2[58]	p1b2[57]	-66.806	213.107	17.35	0.24	
p1b2[59]	p1b2[58]	-69.176	215.473	17.35	0.232	
p1b2[60]	p1b2[59]	-71.646	217.775	17.35	0.230	
p1b2[61]	p1b2[60]	-73.907	220.28	17.35	0.231	
p1b2[62]	p1b2[61]	-76.218	222.552	17.35	0.240	
p1b2[63]	p1b2[62]	-78.796	224.617	17.782	0.234	
p1b2[64]	p1b2[63]	-81.112	226.970	18.52	0.23	
p1b2[65]	p1b2[64]	-83.071	229.589	19.13	0.234	
p1b2b1[1]	p1b2[65]	-85.944	231.263	19.269	0.234	
p1b2b1[2]	p1b2b1[1]	-89.100	231.699	20.348	0.230	
p1b2b1[3]	p1b2b1[2]	-92.308	231.596	21.177	0.233	
p1b2b1[4]	p1b2b1[3]	-95.563	230.990	21.771	0.230	
p1b2b1[5]	p1b2b1[4]	-98.827	230.255	21.89	0.231	
p1b2b1[6]	p1b2b1[5]	-102.056	229.349	21.89	0.231	
p1b2b1[7]	p1b2b1[6]	-104.447	226.982	21.89	0.23	
p1b2b1[8]	p1b2b1[7]	-106.342	224.312	22.013	0.236	
p1b2b1[9]	p1b2b1[8]	-109.148	223.094	23.413	0.23	
p1b2b1[10]	p1b2b1[9]	-111.662	221.316	24.27	0.242	
p1b2b1[11]	p1b2b1[10]	-113.796	218.721	24.398	0.230	
p1b2b1[12]	p1b2b1[11]	-115.974	216.165	24.594	0.230	
p1b2b1[13]	p1b2b1[12]	-117.683	213.361	24.72	0.235	
p1b2b1[14]	p1b2b1[13]	-118.337	209.355	24.799	0.593	
p1b2b1[15]	p1b2b1[14]	-118.527	204.691	24.830	0.514	
p1b2b1[16]	p1b2b1[15]	-118.988	201.498	25.822	0.233	
p1b2b1[17]	p1b2b1[16]	-119.411	198.208	25.344	0.231	
p1b2b1[18]	p1b2b1[17]	-119.83	194.912	24.826	0.230	
p1b2b1[19]	p1b2b1[18]	-120.174	191.567	24.717	0.230	
p1b2b1[20]	p1b2b1[19]	-120.519	188.225	24.62	0.230	
p1b2b1[21]	p1b2b1[20]	-120.982	185.144	25.889	0.23	
p1b2b1[22]	p1b2b1[21]	-121.445	182.063	27.158	0.23	
p1b2b1[23]	p1b2b1[22]	-122.235	179.105	28.407	0.234	
p1b2b1[24]	p1b2b1[23]	-124.050	176.532	29.589	0.230	
p1b2b1[25]	p1b2b1[24]	-124.846	174.174	29.71	0.137	
p1b2b1[26]	p1b2b1[25]	-125.526	171.842	29.71	0.12	
p1b2b1[27]	p1b2b1[26]	-126.266	169.961	28.965	0.135	
p1b2b1[28]	p1b2b1[27]	-127.089	168.002	27.787	0.120	
p1b2b1[29]	p1b2b1[28]	-127.989	165.907	27.307	0.125	
p1b2b1[30]	p1b2b1[29]	-128.961	163.686	27.474	0.120	
p1b2b1[31]	p1b2b1[30]	-129.932	161.465	27.641	0.12	
p1b2b1[32]	p1b2b1[31]	-130.903	159.244	27.808	0.12	
p1b2b1[33]	p1b2b1[32]	-131.874	157.023	27.975	0.120	
p1b2b1[34]	p1b2b1[33]	-132.845	154.802	28.141	0.120	
p1b2b1[35]	p1b2b1[34]	-133.816	152.581	28.308	0.12	
p1b2b1[36]	p1b2b1[35]	-134.788	150.36	28.475	0.12	
p1b2b1[37]	p1b2b1[36]	-136.099	148.394	28.580	0.123	
p1b2b1[38]	p1b2b1[37]	-137.959	146.876	28.682	0.121	
p1b2b1[39]	p1b2b1[38]	-139.400	145.322	29.87	0.120	
p1b2b1[40]	p1b2b1[39]	-140.842	143.767	31.057	0.120	
p1b2b1[41]	p1b2b1[40]	-142.283	142.213	32.245	0.12	
p1b2b1[42]	p1b2b1[41]	-143.554	140.371	32.89	0.125	
p1b2b1[43]	p1b2b1[42]	-144.621	138.189	32.89	0.12	
p1b2b1[44]	p1b2b1[43]	-145.689	136.006	32.89	0.120	
p1b2b1[45]	p1b2b1[44]	-146.548	133.788	33.091	0.122	
p1b2b1[46]	p1b2b1[45]	-146.902	131.486	33.782	0.120	
p1b2b1[47]	p1b2b1[46]	-148.048	129.614	34.095	0.131	
p1b2b1[48]	p1b2b1[47]	-149.325	127.549	34.179	0.120	
p1b2b1[49]	p1b2b1[48]	-150.553	125.457	34.245	0.120	
p1b2b1[50]	p1b2b1[49]	-151.519	123.228	34.213	0.12	
p1b2b1[51]	p1b2b1[50]	-152.486	120.999	34.180	0.120	
p1b2b1[52]	p1b2b1[51]	-153.453	118.770	34.148	0.120	
p1b2b1[53]	p1b2b1[52]	-154.449	116.554	34.13	0.120	
p1b2b1[54]	p1b2b1[53]	-155.482	114.355	34.13	0.120	
p1b2b1[55]	p1b2b1[54]	-156.515	112.156	34.13	0.12	
p1b2b1[56]	p1b2b1[55]	-157.340	109.903	34.284	0.121	
p1b2b1[57]	p1b2b1[56]	-158.106	107.628	34.658	0.120	
p1b2b1[58]	p1b2b1[57]	-158.871	105.352	35.033	0.12	
p1b2b1[59]	p1b2b1[58]	-159.696	103.084	35.314	0.120	
p1b2b1[60]	p1b2b1[59]	-160.522	100.816	35.593	0.120	
p1b2b1[61]	p1b2b1[60]	-161.349	98.548	35.872	0.12	
p1b2b1b1[1]	p1b2b1[61]	-162.442	96.365	36.034	0.12	
p1b2b1b1[2]	p1b2b1b1[1]	-163.535	94.2	36.008	0.120	
p1b2b1b1[3]	p1b2b1b1[2]	-164.628	92.035	35.982	0.12	
p1b2b1b1[4]	p1b2b1b1[3]	-165.720	89.871	35.957	0.12	
p1b2b1b1[5]	p1b2b1b1[4]	-166.930	87.771	35.95	0.120	
p1b2b1b1[6]	p1b2b1b1[5]	-168.180	85.692	35.95	0.12	
p1b2b1b1[7]	p1b2b1b1[6]	-169.43	83.614	35.95	0.12	
p1b2b1b1[8]	p1b2b1b1[7]	-170.074	81.74	36.507	0.141	
p1b2b1b1[9]	p1b2b1b1[8]	-169.335	80.331	38.337	0.12	
p1b2b1b1[10]	p1b2b1b1[9]	-168.566	78.703	39.685	0.129	
p1b2b1b1[11]	p1b2b1b1[10]	-169.522	76.57	39.043	0.12	
p1b2b1b1[12]	p1b2b1b1[11]	-170.526	74.569	38.547	0.127	
p1b2b1b1[13]	p1b2b1b1[12]	-170.998	73.339	40.577	0.120	
p1b2b1b1[14]	p1b2b1b1[13]	-171.460	72.1	42.61	0.120	
p1b2b1b1[15]	p1b2b1b1[14]	-171.935	70.318	43.680	0.136	
p1b2b1b1[16]	p1b2b1b1[15]	-172.542	67.970	43.732	0.120	
p1b2b1b1[17]	p1b2b1b1[16]	-172.992	65.722	43.903	0.127	
p1b2b1b1[18]	p1b2b1b1[17]	-173.047	63.298	43.958	0.12	
p1b2b1b1[19]	p1b2b1b1[18]	-173.431	60.989	44	0.124	
p1b2b1b1[20]	p1b2b1b1[19]	-174.896	59.057	44	0.120	
p1b2b1b1[21]	p1b2b1b1[20]	-176.454	57.212	43.857	0.120	
p1b2b1b1[22]	p1b2b1b1[21]	-178.085	55.435	43.601	0.12	
p1b2b1b1[23]	p1b2b1b1[22]	-179.716	53.659	43.346	0.12	
p1b2b1b1[24]	p1b2b1b1[23]	-181.346	51.882	43.090	0.120	
p1b2b1b1[25]	p1b2b1b1[24]	-181.854	49.524	43.338	0.120	
p1b2b1b1[26]	p1b2b1b1[25]	-182.36	47.166	43.586	0.120	
p1b2b1b1[27]	p1b2b1b1[26]	-182.866	44.807	43.834	0.120	
p1b2b1b1[28]	p1b2b1b1[27]	-182.979	42.438	44.279	0.121	
p1b2b1b1[29]	p1b2b1b1[28]	-183.381	40.325	44.787	0.132	
p1b2b1b1[30]	p1b2b1b1[29]	-184.094	38.015	44.976	0.120	
p1b2b1b1[31]	p1b2b1b1[30]	-184.827	36.151	43.844	0.126	
p1b2b1b1[32]	p1b2b1b1[31]	-185.566	34.421	42.314	0.120	
p1b2b1b1[33]	p1b2b1b1[32]	-186.320	32.899	40.94	0.133	
p1b2b1b1b1[1]	p1b2b1b1[33]	-184.881	31.791	40.751	0.120	
p1b2b1b1b1[2]	p1b2b1b1b1[1]	-183.784	29.791	40.6	0.124	
p1b2b1b1b1[3]	p1b2b1b1b1[2]	-182.102	28.122	40.6	0.12	
p1b2b1b1b1[4]	p1b2b1b1b1[3]	-181.115	26.032	40.6	0.123	
p1b2b1b1b1[5]	p1b2b1b1b1[4]	-180.438	23.764	40.6	0.120	
p1b2b1b1b1[6]	p1b2b1b1b1[5]	-180.544	21.397	40.6	0.120	
p1b2b1b1b1[7]	p1b2b1b1b1[6]	-180.670	19.03	40.6	0.12	
p1b2b1b1b1[8]	p1b2b1b1b1[7]	-180.138	16.735	40.6	0.121	
p1b2b1b1b1[9]	p1b2b1b1b1[8]	-179.631	14.42	40.6	0.120	
p1b2b1b1b1[10]	p1b2b1b1b1[9]	-178.92	12.185	40.721	0.121	
p1b2b1b1b1[11]	p1b2b1b1b1[10]	-177.941	10.041	40.97	0.120	
p1b2b1b1b1[12]	p1b2b1b1b1[11]	-176.962	7.897	41.218	0.12	
p1b2b1b1b1[13]	p1b2b1b1b1[12]	-176.173	5.894	41.28	0.132	
p1b2b1b1b1[14]	p1b2b1b1b1[13]	-175.400	3.654	41.28	0.12	
p1b2b1b1b1[15]	p1b2b1b1b1[14]	-174.627	1.414	41.28	0.12	
p1b2b1b1b1[16]	p1b2b1b1b1[15]	-173.854	-0.827	41.28	0.120	
p1b2b1b1b1[17]	p1b2b1b1b1[16]	-173.292	-3.121	41.28	0.120	
p1b2b1b1b1[18]	p1b2b1b1b1[17]	-172.861	-5.449	41.28	0.120	
p1b2b1b1b1[19]	p1b2b1b1b1[18]	-172.691	-7.813	41.28	0.120	
p1b2b1b1b1[20]	p1b2b1b1b1[19]	-172.403	-9.340	39.796	0.132	
p1b2b1b1b1[21]	p1b2b1b1b1[20]	-172.068	-10.607	37.76	0.12	
p1b2b1b1b2[0]	p1b2b1b1[33]	-187.748	31.849	40.94	0.186	
p1b2b1b1b2[1]	p1b2b1b1b2[0]	-189.61	29.833	40.94	0.12	
p1b2b1b1b2[2]	p1b2b1b1b2[1]	-191.471	27.816	40.94	0.120	
p1b2b1b1b2[3]	p1b2b1b1b2[2]	-192.897	25.81	40.94	0.120	
p1b2b1b1b2[4]	p1b2b1b1b2[3]	-194.261	23.805	40.94	0.120	
p1b2b1b1b2[5]	p1b2b1b1b2[4]	-194.808	21.497	40.94	0.123	
p1b2b1b1b2[6]	p1b2b1b1b2[5]	-195.119	19.092	40.94	0.120	
p1b2b1b1b2[7]	p1b2b1b1b2[6]	-195.521	16.701	40.94	0.12	
p1b2b1b1b2[8]	p1b2b1b1b2[7]	-196.158	14.462	41.058	0.125	
p1b2b1b1b2[9]	p1b2b1b1b2[8]	-196.774	12.124	41.244	0.12	
p1b2b1b1b2[10]	p1b2b1b1b2[9]	-197.390	9.786	41.431	0.120	
p1b2b1b1b2[11]	p1b2b1b1b2[10]	-198.006	7.448	41.617	0.12	
p1b2b1b1b2[12]	p1b2b1b1b2[11]	-198.622	5.11	41.804	0.120	
p1b2b1b1b2[13]	p1b2b1b1b2[12]	-199.249	2.773	41.96	0.120	
p1b2b1b1b2[14]	p1b2b1b1b2[13]	-199.934	0.447	41.96	0.12	
p1b2b1b1b2[15]	p1b2b1b1b2[14]	-200.624	-1.873	41.96	0.120	
p1b2b1b1b2[16]	p1b2b1b1b2[15]	-201.371	-4.18	41.96	0.120	
p1b2b1b1b2[17]	p1b2b1b1b2[16]	-202.706	-6.159	42.283	0.121	
p1b2b1b1b2[18]	p1b2b1b1b2[17]	-204.12	-8.095	42.65	0.12	
p1b2b1b1b2[19]	p1b2b1b1b2[18]	-205.533	-10.031	43.017	0.12	
p1b2b1b1b2[20]	p1b2b1b1b2[19]	-206.947	-11.967	43.383	0.120	
p1b2b1b1b2[21]	p1b2b1b1b2[20]	-208.439	-14.011	43.77	0.12	
p1b2b1b2[0]	p1b2b1[61]	-161.382	96.425	36.06	0.137	
p1b2b1b2[1]	p1b2b1b2[0]	-159.467	95.438	36.06	0.152	
p1b2b1b2[2]	p1b2b1b2[1]	-158.048	93.107	36.06	0.12	
p1b2b1b2[3]	p1b2b1b2[2]	-156.436	91.428	36.06	0.135	
p1b2b1b2[4]	p1b2b1b2[3]	-154.251	90.427	35.866	0.121	
p1b2b1b2[5]	p1b2b1b2[4]	-152.188	89.290	35.271	0.12	
p1b2b1b2[6]	p1b2b1b2[5]	-150.124	88.154	34.676	0.120	
p1b2b1b2[7]	p1b2b1b2[6]	-148.146	86.865	34.25	0.122	
p1b2b1b2[8]	p1b2b1b2[7]	-146.382	85.194	34.25	0.12	
p1b2b1b2[9]	p1b2b1b2[8]	-144.513	83.816	34.86	0.121	
p1b2b1b2[10]	p1b2b1b2[9]	-142.612	82.526	35.652	0.12	
p1b2b1b2[11]	p1b2b1b2[10]	-140.712	81.235	36.444	0.12	
p1b2b1b2[12]	p1b2b1b2[11]	-138.811	79.945	37.236	0.12	
p1b2b1b2[13]	p1b2b1b2[12]	-136.911	78.655	38.028	0.120	
p1b2b1b2[14]	p1b2b1b2[13]	-135.011	77.365	38.820	0.12	
p1b2b1b2[15]	p1b2b1b2[14]	-133.110	76.074	39.612	0.12	
p1b2b1b2[16]	p1b2b1b2[15]	-131.242	74.707	40.26	0.121	
p1b2b1b2[17]	p1b2b1b2[16]	-129.518	72.995	40.26	0.12	
p1b2b1b2[18]	p1b2b1b2[17]	-127.683	71.519	40.6	0.123	
p1b2b1b2[19]	p1b2b1b2[18]	-125.700	70.357	41.389	0.120	
p1b2b1b2[20]	p1b2b1b2[19]	-123.717	69.196	42.179	0.120	
p1b2b1b2[21]	p1b2b1b2[20]	-121.559	68.244	42.53	0.122	
p1b2b1b2[22]	p1b2b1b2[21]	-119.319	67.336	42.497	0.121	
p1b2b1b2[23]	p1b2b1b2[22]	-117.266	66.044	42.361	0.12	
p1b2b1b2[24]	p1b2b1b2[23]	-115.212	64.752	42.225	0.12	
p1b2b1b2[25]	p1b2b1b2[24]	-113.159	63.459	42.09	0.12	
p1b2b1b2[26]	p1b2b1b2[25]	-111.106	62.167	41.954	0.12	
p1b2b1b2[27]	p1b2b1b2[26]	-109.053	60.874	41.818	0.12	
p1b2b1b2[28]	p1b2b1b2[27]	-106.952	59.666	41.720	0.120	
p1b2b1b2[29]	p1b2b1b2[28]	-104.763	58.611	41.693	0.12	
p1b2b1b2[30]	p1b2b1b2[29]	-102.574	57.557	41.666	0.12	
p1b2b1b2[31]	p1b2b1b2[30]	-100.386	56.502	41.639	0.120	
p1b2b1b2[32]	p1b2b1b2[31]	-98.391	55.528	41.094	0.128	
p1b2b1b2[33]	p1b2b1b2[32]	-96.818	54.731	39.422	0.120	
p1b2b1b2[34]	p1b2b1b2[33]	-95.245	53.934	37.75	0.12	
p1b2b1b2[35]	p1b2b1b2[34]	-93.672	53.138	36.078	0.120	
p1b2b1b2[36]	p1b2b1b2[35]	-91.781	51.761	35.434	0.120	
p1b2b1b2[37]	p1b2b1b2[36]	-89.885	50.378	34.802	0.12	
p1b2b1b2[38]	p1b2b1b2[37]	-87.990	48.995	34.169	0.120	
p1b2b1b2[39]	p1b2b1b2[38]	-86.095	47.613	33.537	0.12	
p1b2b1b2[40]	p1b2b1b2[39]	-84.180	46.387	32.799	0.122	
p1b2b1b2[41]	p1b2b1b2[40]	-82.309	45.326	31.669	0.12	
p1b2b1b2[42]	p1b2b1b2[41]	-80.437	44.265	30.539	0.120	
p1b2b1b2[43]	p1b2b1b2[42]	-78.566	43.204	29.409	0.120	
p1b2b1b2[44]	p1b2b1b2[43]	-76.612	42.084	28.69	0.123	
p1b2b1b2[45]	p1b2b1b2[44]	-74.512	40.862	28.69	0.12	
p1b2b1b2[46]	p1b2b1b2[45]	-72.275	40.013	28.69	0.122	
p1b2b1b2[47]	p1b2b1b2[46]	-69.897	39.514	28.69	0.120	
p1b2b1b2[48]	p1b2b1b2[47]	-67.256	38.959	28.69	0.12	
p1b2b2[0]	p1b2[65]	-83.728	232.712	19.39	0.243	
p1b2b2[1]	p1b2b2[0]	-82.701	235.727	19.39	0.304	
p1b2b2[2]	p1b2b2[1]	-80.671	238.433	19.39	0.230	
p1b2b2[3]	p1b2b2[2]	-78.468	240.954	19.39	0.232	
p1b2b2[4]	p1b2b2[3]	-75.916	243.162	19.39	0.231	
p1b2b2[5]	p1b2b2[4]	-73.246	245.221	19.450	0.231	
p1b2b2[6]	p1b2b2[5]	-71.159	247.594	20.07	0.242	
p1b2b2[7]	p1b2b2[6]	-69.010	250.177	20.07	0.232	
p1b2b2[8]	p1b2b2[7]	-66.648	252.595	20.07	0.230	
p1b2b2[9]	p1b2b2[8]	-64.772	255.361	20.07	0.233	
p1b2b2[10]	p1b2b2[9]	-63.454	258.457	20.07	0.231	
p1b2b2[11]	p1b2b2[10]	-63.177	261.828	20.07	0.230	
p1b2b2[12]	p1b2b2[11]	-61.940	264.945	20.07	0.232	
p1b2b2[13]	p1b2b2[12]	-60.678	268.081	20.014	0.230	
p1b2b2[14]	p1b2b2[13]	-58.710	271.603	19.96	0.456	
p1b2b2[15]	p1b2b2[14]	-56.222	274.208	19.96	0.311	
p1b2b2[16]	p1b2b2[15]	-53.301	275.913	19.96	0.23	
p1b2b2[17]	p1b2b2[16]	-50.45	277.615	20.437	0.232	
p1b2b2[18]	p1b2b2[17]	-47.81	279.515	21.251	0.232	
p1b2b2[19]	p1b2b2[18]	-45.612	282.008	21.884	0.23	
p1b2b2[20]	p1b2b2[19]	-43.399	284.406	22.738	0.231	
p1b2b2[21]	p1b2b2[20]	-41.171	286.690	23.859	0.23	
p1b2b2[22]	p1b2b2[21]	-38.636	288.881	24.04	0.232	
p1b2b2[23]	p1b2b2[22]	-35.184	290.644	24.04	0.319	
p1b2b2[24]	p1b2b2[23]	-31.2	291.472	24.04	0.359	
p1b2b2[25]	p1b2b2[24]	-27.196	291.959	24.04	0.332	
p1b2b2[26]	p1b2b2[25]	-23.864	292.494	24.04	0.231	
p1b2b2[27]	p1b2b2[26]	-20.844	293.407	24.649	0.242	
p1b2b2[28]	p1b2b2[27]	-18.435	294.301	26.850	0.230	
p1b2b2[29]	p1b2b2[28]	-16.586	296.655	27.844	0.247	
p1b2b2[30]	p1b2b2[29]	-15.074	299.624	28.354	0.231	
p1b2b2[31]	p1b2b2[30]	-14.085	302.823	28.534	0.232	
p1b2b2[32]	p1b2b2[31]	-12.047	305.014	30.112	0.23	
p1b2b2[33]	p1b2b2[32]	-10.421	307.742	31.096	0.234	
p1b2b2[34]	p1b2b2[33]	-8.530	311.188	32.349	0.645	
p1b2b2[35]	p1b2b2[34]	-7.258	313.114	34.821	0.23	
p1b2b2[36]	p1b2b2[35]	-6.444	315.479	36.831	0.243	
p1b2b2[37]	p1b2b2[36]	-5.371	318.471	37.837	0.233	
p1b2b2[38]	p1b2b2[37]	-4.399	321.392	38.963	0.237	
p1b2b2[39]	p1b2b2[38]	-3.768	324.309	40.554	0.230	
p1b2b2[40]	p1b2b2[39]	-4.194	326.616	41.829	0.199	
p1b2b2[41]	p1b2b2[40]	-5.598	328.299	42.909	0.12	
p1b2b2[42]	p1b2b2[41]	-7.002	329.983	43.989	0.120	
p1b2b2[43]	p1b2b2[42]	-8.405	331.666	45.069	0.120	
p1b2b2[44]	p1b2b2[43]	-9.809	333.349	46.149	0.120	
p1b2b2[45]	p1b2b2[44]	-10.224	335.627	46.38	0.126	
p1b2b2[46]	p1b2b2[45]	-10.371	338.064	46.38	0.120	
p1b2b2[47]	p1b2b2[46]	-10.912	340.447	46.38	0.120	
p1b2b2[48]	p1b2b2[47]	-11.384	342.207	47.5	0.137	
p1b2b2[49]	p1b2b2[48]	-11.798	343.44	49.569	0.120	
p1b2b2[50]	p1b2b2[49]	-12.213	345.017	51.001	0.135	
p1b2b2[51]	p1b2b2[50]	-12.55	347.049	50.459	0.138	
p1b2b2[52]	p1b2b2[51]	-13.084	347.834	52.488	0.131	
p1b2b2[53]	p1b2b2[52]	-13.945	348.724	54.55	0.303	
p1b2b2[54]	p1b2b2[53]	-15.690	352.37	54.55	0.23	

p2[1]	soma	2.879	6.979	3.717	2.001	
p2[2]	p2[1]	3.076	14.083	8.249	1.774	
p2b1[1]	p2[2]	6.464	16.402	13.458	0.847	
p2b1[2]	p2b1[1]	11.833	15.886	14.132	0.752	
p2b1[3]	p2b1[2]	16.116	14.509	16.934	0.771	
p2b1[4]	p2b1[3]	21.524	13.791	18.667	0.714	
p2b1[5]	p2b1[4]	25.722	10.239	19.856	0.727	
p2b1[6]	p2b1[5]	29.493	7.068	22.72	0.717	
p2b1[7]	p2b1[6]	32.83	3.29	23.926	0.789	
p2b1[8]	p2b1[7]	34.556	-2.179	24.338	0.711	
p2b1[9]	p2b1[8]	36.701	-6.718	26.707	0.736	
p2b1[10]	p2b1[9]	37.679	-12.013	27.624	0.748	
p2b1[11]	p2b1[10]	39.276	-17.212	29.572	0.708	
p2b1[12]	p2b1[11]	41.946	-22.338	30.008	0.705	
p2b1[13]	p2b1[12]	44.343	-27.443	30.008	0.725	
p2b1[14]	p2b1[13]	48.088	-31.229	31.521	0.738	
p2b1[15]	p2b1[14]	51.320	-34.762	34.291	0.666	
p2b1[16]	p2b1[15]	52.907	-39.403	34.778	0.626	
p2b1[17]	p2b1[16]	55.357	-44.048	34.778	0.587	
p2b1[18]	p2b1[17]	58.786	-48.079	34.778	0.583	
p2b1[19]	p2b1[18]	61.299	-52.737	34.778	0.583	
p2b1[20]	p2b1[19]	62.896	-56.547	37.622	0.615	
p2b1[21]	p2b1[20]	65.731	-60.719	37.948	0.61	
p2b1[22]	p2b1[21]	67.59	-65.582	38.006	0.592	
p2b1[23]	p2b1[22]	68.712	-70.199	40.148	0.592	
p2b1[24]	p2b1[23]	70.985	-74.621	41.377	0.595	
p2b1[25]	p2b1[24]	71.915	-78.182	44.298	0.479	
p2b1[26]	p2b1[25]	70.791	-82.797	44.511	0.473	
p2b1[27]	p2b1[26]	71.295	-86.761	46.071	0.524	
p2b1[28]	p2b1[27]	72.366	-90.345	48.079	0.53	
p2b1[29]	p2b1[28]	75.183	-93.844	48.838	0.494	
p2b1[30]	p2b1[29]	77.668	-96.262	51.232	0.534	
p2b1[31]	p2b1[30]	79.601	-98.671	54.627	0.490	
p2b1[32]	p2b1[31]	83.124	-101.286	56.536	0.470	
p2b1[33]	p2b1[32]	86.429	-104.707	56.548	0.473	
p2b1[34]	p2b1[33]	89.899	-107.418	58.087	0.482	
p2b1[35]	p2b1[34]	92.87	-110.405	60.211	0.477	
p2b1[36]	p2b1[35]	94.611	-114.581	61.638	0.474	
p2b1[37]	p2b1[36]	96.414	-118.834	62.884	0.470	
p2b1[38]	p2b1[37]	96.712	-122.906	64.976	0.490	
p2b1[39]	p2b1[38]	96.067	-126.658	67.853	0.471	
p2b1[40]	p2b1[39]	94.528	-130.779	69.513	0.478	
p2b1[41]	p2b1[40]	91.486	-134.253	70.608	0.474	
p2b1[42]	p2b1[41]	88.609	-138.031	71.014	0.472	
p2b1[43]	p2b1[42]	85.907	-141.913	71.740	0.470	
p2b1[44]	p2b1[43]	84.252	-146.248	71.858	0.485	
p2b1[45]	p2b1[44]	83.320	-150.547	73.230	0.488	
p2b1[46]	p2b1[45]	81.813	-154.900	73.917	0.483	
p2b1[47]	p2b1[46]	80.753	-159.079	75.815	0.477	
p2b1[48]	p2b1[47]	80.131	-163.459	77.188	0.486	
p2b1[49]	p2b1[48]	78.884	-167.782	77.938	0.493	
p2b1[50]	p2b1[49]	78.163	-171.424	80.913	0.473	
p2b1[51]	p2b1[50]	77.314	-175.7	82.398	0.488	
p2b1[52]	p2b1[51]	75.895	-180.094	83.414	0.476	
p2b1[53]	p2b1[52]	73.205	-183.819	84.556	0.475	
p2b1[54]	p2b1[53]	70.004	-187.158	85.619	0.474	
p2b1[55]	p2b1[54]	66.989	-190.812	85.918	0.474	
p2b1[56]	p2b1[55]	64.364	-194.782	86.244	0.471	
p2b1[57]	p2b1[56]	61.885	-199.191	87.048	0.597	
p2b1b1[1]	p2b1[57]	59.598	-202.387	87.048	0.355	
p2b1b1[2]	p2b1b1[1]	56.716	-205.134	87.048	0.350	
p2b1b1[3]	p2b1b1[2]	54.53	-208.289	87.048	0.363	
p2b1b1[4]	p2b1b1[3]	51.424	-210.459	87.048	0.368	
p2b1b1[5]	p2b1b1[4]	49.41	-213.277	88.372	0.376	
p2b1b1[6]	p2b1b1[5]	47.957	-216.330	90.152	0.365	
p2b1b1[7]	p2b1b1[6]	45.475	-218.699	91.588	0.375	
p2b1b1[8]	p2b1b1[7]	43.662	-220.590	94.043	0.388	
p2b1b1[9]	p2b1b1[8]	40.946	-222.262	96.142	0.365	
p2b1b1[10]	p2b1b1[9]	36.086	-224.068	98.168	1.018	
p2b1b1[11]	p2b1b1[10]	35.255	-224.013	101.45	0.412	
p2b1b1[12]	p2b1b1[11]	34.965	-224.352	105.407	0.350	
p2b1b1[13]	p2b1b1[12]	33.981	-225.644	109.402	0.769	
p2b1b1[14]	p2b1b1[13]	31.305	-226.492	111.998	0.35	
p2b1b2[0]	p2b1[57]	63.544	-203.151	87.048	0.577	
p2b1b2[1]	p2b1b2[0]	63.841	-207.097	86.118	0.356	
p2b1b2[2]	p2b1b2[1]	65.406	-210.894	85.691	0.35	
p2b1b2[3]	p2b1b2[2]	67.133	-214.580	86.137	0.353	
p2b1b2[4]	p2b1b2[3]	68.608	-218.454	87.508	0.35	
p2b2[0]	p2[2]	4.937	21.656	9.488	1.459	
p2b2[1]	p2b2[0]	7.389	28.190	8.620	1.450	
p2b2[2]	p2b2[1]	8.936	35.327	9.08	1.132	
p2b2[3]	p2b2[2]	11.51	41.532	9.114	0.940	
p2b2b1[1]	p2b2[3]	10.707	47.235	7.863	0.709	
p2b2b1[2]	p2b2b1[1]	9.439	52.775	7.863	0.717	
p2b2b1[3]	p2b2b1[2]	8.044	58.311	7.863	0.714	
p2b2b1b1[1]	p2b2b1[3]	3.803	60.593	9.061	0.35	
p2b2b1b1[2]	p2b2b1b1[1]	0.48	62.952	8.993	0.353	
p2b2b1b1[3]	p2b2b1b1[2]	-2.88	65.326	8.993	0.350	
p2b2b1b1[4]	p2b2b1b1[3]	-5.69	68.262	8.993	0.354	
p2b2b1b1[5]	p2b2b1b1[4]	-8.084	71.605	8.993	0.350	
p2b2b1b1[6]	p2b2b1b1[5]	-10.137	75.132	8.993	0.353	
p2b2b1b1[7]	p2b2b1b1[6]	-10.676	78.443	8.993	0.234	
p2b2b1b1[8]	p2b2b1b1[7]	-10.461	81.064	8.993	0.162	
p2b2b1b1[9]	p2b2b1b1[8]	-10.338	83.412	9.053	0.123	
p2b2b1b1[10]	p2b2b1b1[9]	-10.86	85.759	9.208	0.12	
p2b2b1b1[11]	p2b2b1b1[10]	-11.381	88.105	9.363	0.12	
p2b2b1b1[12]	p2b2b1b1[11]	-12.049	90.332	9.443	0.124	
p2b2b1b1[13]	p2b2b1b1[12]	-12.231	92.734	9.443	0.120	
p2b2b1b1[14]	p2b2b1b1[13]	-12.442	95.131	9.443	0.120	
p2b2b1b1[15]	p2b2b1b1[14]	-12.795	97.514	9.443	0.12	
p2b2b1b1[16]	p2b2b1b1[15]	-13.011	99.800	9.443	0.126	
p2b2b1b1[17]	p2b2b1b1[16]	-13.104	102.207	9.443	0.12	
p2b2b1b1[18]	p2b2b1b1[17]	-13.192	104.594	9.648	0.121	
p2b2b1b1[19]	p2b2b1b1[18]	-13.275	106.953	10.129	0.12	
p2b2b1b1[20]	p2b2b1b1[19]	-13.358	109.311	10.609	0.12	
p2b2b1b1[21]	p2b2b1b1[20]	-13.441	111.670	11.089	0.12	
p2b2b1b1[22]	p2b2b1b1[21]	-13.524	114.029	11.569	0.12	
p2b2b1b1[23]	p2b2b1b1[22]	-13.607	116.388	12.05	0.12	
p2b2b1b1[24]	p2b2b1b1[23]	-14.627	118.351	12.744	0.125	
p2b2b1b1[25]	p2b2b1b1[24]	-15.979	120.138	13.627	0.12	
p2b2b1b1[26]	p2b2b1b1[25]	-17.592	121.677	14.357	0.123	
p2b2b1b1[27]	p2b2b1b1[26]	-19.716	122.728	14.788	0.12	
p2b2b1b1[28]	p2b2b1b1[27]	-21.840	123.778	15.218	0.12	
p2b2b1b1[29]	p2b2b1b1[28]	-23.743	125.209	15.389	0.121	
p2b2b1b1[30]	p2b2b1b1[29]	-25.578	126.733	15.453	0.121	
p2b2b1b1[31]	p2b2b1b1[30]	-27.954	126.961	15.752	0.120	
p2b2b1b1[32]	p2b2b1b1[31]	-29.873	127.898	16.443	0.129	
p2b2b1b1[33]	p2b2b1b1[32]	-31.423	129.527	17.308	0.12	
p2b2b1b1[34]	p2b2b1b1[33]	-32.973	131.156	18.172	0.12	
p2b2b1b1[35]	p2b2b1b1[34]	-34.523	132.784	19.037	0.12	
p2b2b1b1[36]	p2b2b1b1[35]	-36.156	134.286	19.528	0.127	
p2b2b1b1[37]	p2b2b1b1[36]	-38.263	135.365	19.972	0.120	
p2b2b1b1[38]	p2b2b1b1[37]	-40.370	136.444	20.416	0.12	
p2b2b1b1[39]	p2b2b1b1[38]	-42.363	137.656	20.783	0.122	
p2b2b1b1[40]	p2b2b1b1[39]	-44.437	139.063	20.783	0.12	
p2b2b1b2[0]	p2b2b1[3]	6.183	63.786	7.513	0.703	
p2b2b1b2[1]	p2b2b1b2[0]	4.236	69.251	7.513	0.873	
p2b2b1b2[2]	p2b2b1b2[1]	2.491	74.786	7.416	0.702	
p2b2b1b2[3]	p2b2b1b2[2]	2.447	80.581	7.403	0.703	
p2b2b1b2[4]	p2b2b1b2[3]	2.755	86.386	7.605	0.700	
p2b2b1b2[5]	p2b2b1b2[4]	2.189	92.167	7.633	0.701	
p2b2b1b2[6]	p2b2b1b2[5]	1.623	97.837	8.166	0.712	
p2b2b1b2[7]	p2b2b1b2[6]	0.642	102.882	10.764	0.707	
p2b2b1b2[8]	p2b2b1b2[7]	-2.035	107.433	12.781	0.721	
p2b2b1b2[9]	p2b2b1b2[8]	-5.553	111.956	13.800	0.700	
p2b2b1b2[10]	p2b2b1b2[9]	-8.437	116.949	14.398	0.703	
p2b2b1b2[11]	p2b2b1b2[10]	-11.492	121.877	14.663	0.702	
p2b2b1b2[12]	p2b2b1b2[11]	-14.886	126.557	15.311	0.700	
p2b2b1b2[13]	p2b2b1b2[12]	-18.255	131.267	15.825	0.701	
p2b2b1b2[14]	p2b2b1b2[13]	-21.19	136.230	15.913	0.706	
p2b2b1b2[15]	p2b2b1b2[14]	-23.712	141.359	15.913	0.713	
p2b2b1b2[16]	p2b2b1b2[15]	-26.876	146.214	16.369	0.701	
p2b2b1b2[17]	p2b2b1b2[16]	-29.373	151.38	16.703	0.709	
p2b2b1b2[18]	p2b2b1b2[17]	-31.172	156.894	16.703	0.702	
p2b2b1b2[19]	p2b2b1b2[18]	-33.898	162.028	16.703	0.701	
p2b2b1b2[20]	p2b2b1b2[19]	-36.166	167.376	16.954	0.701	
p2b2b1b2[21]	p2b2b1b2[20]	-38.318	172.763	17.273	0.701	
p2b2b1b2[22]	p2b2b1b2[21]	-41.182	177.738	17.273	0.71	
p2b2b1b2[23]	p2b2b1b2[22]	-41.808	183.524	17.273	0.700	
p2b2b1b2[24]	p2b2b1b2[23]	-43.289	188.982	17.273	0.720	
p2b2b1b2[25]	p2b2b1b2[24]	-42.147	194.286	17.273	0.751	
p2b2b1b2[26]	p2b2b1b2[25]	-43.692	199.858	17.273	0.705	
p2b2b1b2[27]	p2b2b1b2[26]	-46.976	204.552	17.273	0.711	
p2b2b1b2[28]	p2b2b1b2[27]	-50.001	209.49	17.273	0.704	
p2b2b1b2[29]	p2b2b1b2[28]	-52.359	214.769	17.273	0.705	
p2b2b1b2[30]	p2b2b1b2[29]	-55.933	219.322	17.273	0.704	
p2b2b1b2[31]	p2b2b1b2[30]	-60.033	223.394	16.995	0.704	
p2b2b1b2[32]	p2b2b1b2[31]	-64.414	226.808	15.356	0.703	
p2b2b1b2[33]	p2b2b1b2[32]	-69.315	229.364	13.533	0.7	
p2b2b1b2[34]	p2b2b1b2[33]	-74.226	231.924	11.791	0.702	
p2b2b1b2[35]	p2b2b1b2[34]	-78.596	235.131	11.033	0.744	
p2b2b1b2b1[1]	p2b2b1b2[35]	-82.068	239.208	11.033	0.570	
p2b2b1b2b1[2]	p2b2b1b2b1[1]	-84.354	242.474	11.033	0.366	
p2b2b1b2b1[3]	p2b2b1b2b1[2]	-86.803	245.63	10.389	0.360	
p2b2b1b2b1[4]	p2b2b1b2b1[3]	-89.744	247.946	8.752	0.357	
p2b2b1b2b1b1[1]	p2b2b1b2b1[4]	-91.278	250.062	9.254	0.449	
p2b2b1b2b1b1[2]	p2b2b1b2b1b1[1]	-90.982	252.844	10.397	0.463	
p2b2b1b2b1b1[3]	p2b2b1b2b1b1[2]	-92.507	256.312	10.924	0.366	
p2b2b1b2b1b1[4]	p2b2b1b2b1b1[3]	-95.245	258.621	12.328	0.364	
p2b2b1b2b1b1[5]	p2b2b1b2b1b1[4]	-97.137	261.781	12.767	0.378	
p2b2b1b2b1b1[6]	p2b2b1b2b1b1[5]	-98.876	265.092	13.432	0.369	
p2b2b1b2b1b1[7]	p2b2b1b2b1b1[6]	-101.330	268.164	14.035	0.352	
p2b2b1b2b1b1[8]	p2b2b1b2b1b1[7]	-103.916	271.112	14.462	0.355	
p2b2b1b2b1b1[9]	p2b2b1b2b1b1[8]	-106.313	274.157	14.972	0.358	
p2b2b1b2b1b1[10]	p2b2b1b2b1b1[9]	-107.992	276.982	17.256	0.35	
p2b2b1b2b1b1[11]	p2b2b1b2b1b1[10]	-109.406	280.302	18.886	0.354	
p2b2b1b2b1b1[12]	p2b2b1b2b1b1[11]	-111.417	283.654	19.357	0.356	
p2b2b1b2b1b1[13]	p2b2b1b2b1b1[12]	-111.987	287.61	19.357	0.350	
p2b2b1b2b1b1[14]	p2b2b1b2b1b1[13]	-111.965	291.565	19.639	0.353	
p2b2b1b2b1b1[15]	p2b2b1b2b1b1[14]	-112.548	295.354	20.157	0.35	
p2b2b1b2b1b2[0]	p2b2b1b2b1[4]	-92.935	249.511	7.107	0.372	
p2b2b1b2b1b2[1]	p2b2b1b2b1b2[0]	-96.490	250.535	6.899	0.52	
p2b2b1b2b1b2[2]	p2b2b1b2b1b2[1]	-99.846	249.314	4.791	0.351	
p2b2b1b2b1b2[3]	p2b2b1b2b1b2[2]	-103.606	249.180	3.663	0.371	
p2b2b1b2b1b2[4]	p2b2b1b2b1b2[3]	-106.728	250.086	2.605	0.426	
p2b2b1b2b1b2[5]	p2b2b1b2b1b2[4]	-110.281	252.218	2.533	0.352	
p2b2b1b2b1b2[6]	p2b2b1b2b1b2[5]	-113.277	254.137	0.656	0.362	
p2b2b1b2b1b2[7]	p2b2b1b2b1b2[6]	-116.272	256.038	-1.069	0.369	
p2b2b1b2b1b2[8]	p2b2b1b2b1b2[7]	-120.141	257.567	-0.906	0.350	
p2b2b1b2b1b2[9]	p2b2b1b2b1b2[8]	-124.161	258.612	-0.877	0.351	
p2b2b1b2b1b2[10]	p2b2b1b2b1b2[9]	-127.952	260.296	-0.877	0.351	
p2b2b1b2b1b2[11]	p2b2b1b2b1b2[10]	-131.989	261.315	-0.877	0.35	
p2b2b1b2b1b2[12]	p2b2b1b2b1b2[11]	-136.02	262.333	-0.877	0.350	
p2b2b1b2b1b2[13]	p2b2b1b2b1b2[12]	-140.100	263.137	-0.877	0.350	
p2b2b1b2b1b2[14]	p2b2b1b2b1b2[13]	-144.26	263.324	-0.877	0.350	
p2b2b1b2b1b2[15]	p2b2b1b2b1b2[14]	-148.367	263.281	-0.697	0.354	
p2b2b1b2b1b2[16]	p2b2b1b2b1b2[15]	-151.915	262.273	-0.249	0.392	
p2b2b1b2b1b2[17]	p2b2b1b2b1b2[16]	-155.433	261.522	-2.117	0.359	
p2b2b1b2b1b2[18]	p2b2b1b2b1b2[17]	-159.552	260.914	-2.117	0.350	
p2b2b1b2b1b2[19]	p2b2b1b2b1b2[18]	-163.62	260.064	-2.117	0.351	
p2b2b1b2b1b2[20]	p2b2b1b2b1b2[19]	-167.006	260.395	-3.567	0.394	
p2b2b1b2b1b2[21]	p2b2b1b2b1b2[20]	-169.885	260.717	-6.657	0.35	
p2b2b1b2b2[0]	p2b2b1b2[35]	-84.276	235.833	11.033	0.712	
p2b2b1b2b2[1]	p2b2b1b2b2[0]	-89.157	233.641	11.033	0.814	
p2b2b1b2b2[2]	p2b2b1b2b2[1]	-92.808	232.877	13.303	0.519	
p2b2b1b2b2[3]	p2b2b1b2b2[2]	-97.24	231.400	13.303	0.48	
p2b2b1b2b2[4]	p2b2b1b2b2[3]	-100.699	229.311	15.393	0.493	
p2b2b1b2b2[5]	p2b2b1b2b2[4]	-104.918	228.802	16.363	0.514	
p2b2b1b2b2b1[1]	p2b2b1b2b2[5]	-105.857	231.710	17.334	0.230	
p2b2b1b2b2b1[2]	p2b2b1b2b2b1[1]	-107.038	234.343	17.880	0.24	
p2b2b1b2b2b1[3]	p2b2b1b2b2b1[2]	-108.687	236.660	19.004	0.230	
p2b2b1b2b2b1[4]	p2b2b1b2b2b1[3]	-110.826	238.562	18.033	0.233	
p2b2b1b2b2b1[5]	p2b2b1b2b2b1[4]	-112.96	240.432	16.964	0.23	
p2b2b1b2b2b2[0]	p2b2b1b2b2[5]	-108.287	225.995	17.414	0.497	
p2b2b1b2b2b2[1]	p2b2b1b2b2b2[0]	-111.012	223.303	19.763	0.502	
p2b2b1b2b2b2[2]	p2b2b1b2b2b2[1]	-115.086	222.728	19.763	0.350	
p2b2b1b2b2b2[3]	p2b2b1b2b2b2[2]	-117.554	219.983	19.763	0.390	
p2b2b1b2b2b2b1[1]	p2b2b1b2b2b2[3]	-119.612	217.471	19.599	0.23	
p2b2b1b2b2b2b1[2]	p2b2b1b2b2b2b1[1]	-122.478	215.953	19.598	0.230	
p2b2b1b2b2b2b1[3]	p2b2b1b2b2b2b1[2]	-124.602	213.730	19.598	0.243	
p2b2b1b2b2b2b1[4]	p2b2b1b2b2b2b1[3]	-125.662	210.662	19.598	0.230	
p2b2b1b2b2b2b1[5]	p2b2b1b2b2b2b1[4]	-127.013	208.104	20.611	0.244	
p2b2b1b2b2b2b1[6]	p2b2b1b2b2b2b1[5]	-128.693	206.001	22.276	0.236	
p2b2b1b2b2b2b1[7]	p2b2b1b2b2b2b1[6]	-131.328	204.176	21.76	0.230	
p2b2b1b2b2b2b1[8]	p2b2b1b2b2b2b1[7]	-133.883	202.891	20.708	0.245	
p2b2b1b2b2b2b1[9]	p2b2b1b2b2b2b1[8]	-136.246	203.552	18.884	0.244	
p2b2b1b2b2b2b1[10]	p2b2b1b2b2b2b1[9]	-136.362	206.280	17.934	0.258	
p2b2b1b2b2b2b1[11]	p2b2b1b2b2b2b1[10]	-136.495	208.682	16.078	0.23	
p2b2b1b2b2b2b2[0]	p2b2b1b2b2b2[3]	-116.29	218.311	19.708	0.484	
p2b2b1b2b2b2b2[1]	p2b2b1b2b2b2b2[0]	-113.456	217.313	19.01	0.237	
p2b2b1b2b2b2b2[2]	p2b2b1b2b2b2b2[1]	-111.621	215.404	16.99	0.230	
p2b2b1b2b2b2b2[3]	p2b2b1b2b2b2b2[2]	-110.274	213.072	15.020	0.230	
p2b2b1b2b2b2b2[4]	p2b2b1b2b2b2b2[3]	-108.012	211.107	15.113	0.23	
p2b2b2[0]	p2b2[3]	14.296	47.230	7.973	1.059	
p2b2b2[1]	p2b2b2[0]	13.638	52.937	8.669	0.728	
p2b2b2[2]	p2b2b2[1]	13.371	58.115	7.385	0.582	
p2b2b2[3]	p2b2b2[2]	13.49	62.892	6.01	0.549	
p2b2b2[4]	p2b2b2[3]	15.433	66.86	4.770	0.495	
p2b2b2[5]	p2b2b2[4]	17.069	71.298	4.174	0.476	
p2b2b2[6]	p2b2b2[5]	19.614	73.925	3.860	0.333	
p2b2b2[7]	p2b2b2[6]	22.21	73.490	1.7	0.23	


p3[1]	soma	4.124	-6.699	-0.433	1.508	
p3[2]	p3[1]	7.64	-12.423	-3.162	1.316	
p3[3]	p3[2]	11.727	-18.086	-4.65	1.336	
p3[4]	p3[3]	17.150	-23.09	-4.65	1.293	
p3[5]	p3[4]	20.271	-29.598	-4.65	1.322	
p3[6]	p3[5]	23.604	-36.136	-5.452	1.292	
p3[7]	p3[6]	27.783	-42.198	-5.560	1.296	
p3[8]	p3[7]	30.293	-49.121	-5.560	1.295	
p3[9]	p3[8]	32.576	-56.138	-5.560	1.293	
p3[10]	p3[9]	35.120	-63.12	-5.44	1.28	
p3b1[0]	p3[10]	35.99	-69.87	-5.44	1.001	
p3b1[1]	p3b1[0]	37.043	-76.279	-5.638	0.942	
p3b1[2]	p3b1[1]	37.957	-82.495	-6.358	0.968	
p3b1[3]	p3b1[2]	37.440	-88.806	-6.58	0.966	
p3b1[4]	p3b1[3]	36.157	-95.130	-6.659	0.949	
p3b1[5]	p3b1[4]	35.335	-101.601	-7.03	0.937	
p3b1[6]	p3b1[5]	36.041	-107.990	-7.327	0.951	
p3b1[7]	p3b1[6]	33.812	-113.825	-8.378	0.967	
p3b1[8]	p3b1[7]	29.654	-118.726	-9.788	0.930	
p3b1[9]	p3b1[8]	27.55	-124.851	-10.32	0.942	
p3b1[10]	p3b1[9]	25.352	-130.969	-11.032	0.936	
p3b1[11]	p3b1[10]	23.062	-137.091	-11.764	0.931	
p3b1[12]	p3b1[11]	20.964	-143.313	-12.13	0.931	
p3b1[13]	p3b1[12]	20.298	-149.745	-12.81	0.942	
p3b1[14]	p3b1[13]	20.676	-156.314	-12.81	0.930	
p3b1[15]	p3b1[14]	20.413	-162.85	-12.81	0.936	
p3b1[16]	p3b1[15]	21.108	-169.259	-13.247	0.947	
p3b1[17]	p3b1[16]	21.86	-175.778	-13.27	0.933	
p3b1[18]	p3b1[17]	24.150	-181.894	-13.27	0.937	
p3b1[19]	p3b1[18]	26.743	-187.822	-13.27	0.946	
p3b1[20]	p3b1[19]	28.260	-194.1	-14.74	0.93	
p3b1b1[0]	p3b1[20]	26.051	-199.443	-14.74	0.783	
p3b1b1[1]	p3b1b1[0]	22.415	-203.773	-14.74	0.714	
p3b1b1[2]	p3b1b1[1]	18.816	-207.827	-15.391	0.661	
p3b1b1[3]	p3b1b1[2]	14.653	-210.669	-15.530	0.604	
p3b1b1[4]	p3b1b1[3]	11.449	-214.738	-15.530	0.567	
p3b1b1[5]	p3b1b1[4]	8.371	-218.323	-15.530	0.47	
p3b1b1[6]	p3b1b1[5]	5.688	-222.188	-15.530	0.472	
p3b1b1[7]	p3b1b1[6]	2.741	-225.77	-15.530	0.479	
p3b1b1[8]	p3b1b1[7]	-1.152	-228.246	-15.530	0.481	
p3b1b1[9]	p3b1b1[8]	-4.215	-231.52	-15.530	0.462	
p3b1b1[10]	p3b1b1[9]	-7.812	-233.316	-15.530	0.355	
p3b1b1[11]	p3b1b1[10]	-10.853	-236.031	-15.530	0.350	
p3b1b1[12]	p3b1b1[11]	-13.896	-238.718	-15.530	0.352	
p3b1b1[13]	p3b1b1[12]	-16.295	-241.922	-15.530	0.357	
p3b1b1[14]	p3b1b1[13]	-17.016	-245.798	-15.530	0.362	
p3b1b1[15]	p3b1b1[14]	-16.635	-249.853	-15.530	0.350	
p3b1b1[16]	p3b1b1[15]	-15.741	-253.829	-15.469	0.350	
p3b1b1[17]	p3b1b1[16]	-14.876	-257.802	-15.193	0.350	
p3b1b1[18]	p3b1b1[17]	-11.943	-259.301	-17.596	0.350	
p3b1b1[19]	p3b1b1[18]	-9.3	-260.33	-20.41	0.35	
p3b1b2[0]	p3b1[20]	31.372	-198.138	-16.33	0.862	
p3b1b2[1]	p3b1b2[0]	35.1	-202.365	-16.33	0.816	
p3b1b2[2]	p3b1b2[1]	38.098	-207.166	-16.33	0.813	
p3b1b2[3]	p3b1b2[2]	41.460	-211.675	-16.33	0.818	
p3b1b2[4]	p3b1b2[3]	45.249	-215.719	-16.411	0.830	
p3b1b2[5]	p3b1b2[4]	48.023	-220.511	-17.306	0.820	
p3b1b2[6]	p3b1b2[5]	49.198	-225.214	-19.884	0.838	
p3b1b2[7]	p3b1b2[6]	51.97	-228.371	-22.91	0.826	
p3b1b2[8]	p3b1b2[7]	54.77	-231.3	-22.91	0.35	
p3b2[0]	p3[10]	38.031	-68.319	-2.95	1.159	
p3b2[1]	p3b2[0]	40.394	-74.652	-1.098	1.068	
p3b2[2]	p3b2[1]	41.594	-81.479	-0.910	1.056	
p3b2[3]	p3b2[2]	42.658	-87.996	-0.525	0.943	
p3b2[4]	p3b2[3]	42.624	-94.012	2.170	0.946	
p3b2[5]	p3b2[4]	40.692	-100.228	2.312	0.958	
p3b2[6]	p3b2[5]	41.950	-106.449	3.513	0.966	
p3b2[7]	p3b2[6]	42.159	-112.333	6.298	0.958	
p3b2[8]	p3b2[7]	42.596	-118.294	8.4	0.985	
p3b2[9]	p3b2[8]	42.821	-124.512	10.21	0.963	
p3b2[10]	p3b2[9]	43.552	-130.853	10.21	0.848	
p3b2[11]	p3b2[10]	41.297	-136.288	10.21	0.862	
p3b2[12]	p3b2[11]	41.845	-140.72	11.654	1.080	
p3b2[13]	p3b2[12]	45.216	-144.841	13.38	0.879	
p3b2[14]	p3b2[13]	45.848	-149.713	15.42	0.766	
p3b2[15]	p3b2[14]	47.177	-155.371	15.42	0.701	
p3b2[16]	p3b2[15]	47.866	-160.830	15.42	0.740	
p3b2[17]	p3b2[16]	47.167	-165.918	16.634	0.772	
p3b2[18]	p3b2[17]	46.895	-170.520	20.033	0.711	
p3b2[19]	p3b2[18]	44.396	-175.204	21.55	0.738	
p3b2[20]	p3b2[19]	43.006	-179.914	24.011	0.742	
p3b2[21]	p3b2[20]	41.160	-184.059	27.33	0.725	
p3b2[22]	p3b2[21]	41.275	-189.235	28.719	0.76	
p3b2[23]	p3b2[22]	39.063	-194.035	30.144	0.744	
p3b2[24]	p3b2[23]	38.486	-199.3	32.403	0.707	
p3b2[25]	p3b2[24]	38.167	-204.205	35.087	0.727	
p3b2[26]	p3b2[25]	40.208	-208.888	37.604	0.715	
p3b2[27]	p3b2[26]	39.677	-213.758	40.615	0.709	
p3b2[28]	p3b2[27]	39.248	-219.015	42.127	0.742	
p3b2[29]	p3b2[28]	38.033	-224.441	43.613	0.708	
p3b2[30]	p3b2[29]	38.032	-229.096	45.686	0.751	
p3b2[31]	p3b2[30]	37.379	-233.521	48.08	0.606	
p3b2[32]	p3b2[31]	37.330	-238.16	50.083	0.608	
p3b2[33]	p3b2[32]	36.750	-242.734	52.264	0.602	
p3b2[34]	p3b2[33]	37.258	-247.633	53.53	0.604	
p3b2[35]	p3b2[34]	38.219	-251.241	56.72	0.626	
p3b2[36]	p3b2[35]	37.330	-255.65	58.746	0.623	
p3b2[37]	p3b2[36]	37.910	-260.355	60.427	0.611	
p3b2[38]	p3b2[37]	36.184	-263.761	63.756	0.606	
p3b2[39]	p3b2[38]	34.031	-267.623	65.550	0.644	
p3b2[40]	p3b2[39]	32.359	-271.054	68.855	0.609	
p3b2[41]	p3b2[40]	31.453	-275.107	71.860	0.599	
p3b2[42]	p3b2[41]	30.240	-279.462	74.423	0.591	
p3b2[43]	p3b2[42]	29.372	-282.428	77.45	0.710	
p3b2[44]	p3b2[43]	28.265	-286.158	80.413	0.628	
p3b2[45]	p3b2[44]	26.980	-288.79	77.910	1.51	
p3b2b1[0]	p3b2[45]	25.844	-285.184	80.565	1.024	
p3b2b1[1]	p3b2b1[0]	25.552	-283.585	85.997	0.834	
p3b2b1[2]	p3b2b1[1]	25.120	-280.959	90.758	0.867	
p3b2b1[3]	p3b2b1[2]	23.218	-279.757	96.019	0.826	
p3b2b1[4]	p3b2b1[3]	20.213	-279.174	95.594	1.530	
p3b2b1[5]	p3b2b1[4]	17.776	-278.796	99	1.125	
p3b2b1[6]	p3b2b1[5]	15.7	-278.19	104.220	0.81	
p3b2b1b1[0]	p3b2b1[6]	12.783	-274.329	104.9	0.683	
p3b2b1b1[1]	p3b2b1b1[0]	11.367	-270.530	104.9	0.393	
p3b2b1b1[2]	p3b2b1b1[1]	9.023	-267.535	105.272	0.358	
p3b2b1b1[3]	p3b2b1b1[2]	6.718	-265.375	107.297	0.364	
p3b2b1b1[4]	p3b2b1b1[3]	4.890	-264.25	110.45	0.35	
p3b2b1b2[0]	p3b2b1[6]	14.959	-280.302	106.851	0.389	
p3b2b1b2[1]	p3b2b1b2[0]	15.534	-281.715	109.620	0.425	
p3b2b1b2[2]	p3b2b1b2[1]	13.469	-282.08	112.826	0.351	
p3b2b1b2[3]	p3b2b1b2[2]	10.981	-282.22	115.736	0.351	
p3b2b1b2[4]	p3b2b1b2[3]	8.527	-281.976	115.25	0.535	
p3b2b1b2[5]	p3b2b1b2[4]	5.930	-281.41	112.95	0.35	
p3b2b2[0]	p3b2[45]	28.630	-292.422	77.997	0.350	
p3b2b2[1]	p3b2b2[0]	30.599	-295.886	78.020	0.351	
p3b2b2[2]	p3b2b2[1]	32.683	-299.289	78.020	0.350	
p3b2b2[3]	p3b2b2[2]	34.973	-302.526	78.020	0.352	
p3b2b2[4]	p3b2b2[3]	37.805	-305.322	78.020	0.351	
p3b2b2[5]	p3b2b2[4]	40.864	-307.883	78.020	0.350	
p3b2b2[6]	p3b2b2[5]	43.829	-310.467	78.585	0.352	
p3b2b2[7]	p3b2b2[6]	46.739	-313.08	79.377	0.350	
p3b2b2[8]	p3b2b2[7]	49.194	-315.89	79.656	0.373	
p3b2b2[9]	p3b2b2[8]	51.239	-319.005	81.005	0.352	
p3b2b2[10]	p3b2b2[9]	53.600	-321.995	82.142	0.351	
p3b2b2[11]	p3b2b2[10]	55.513	-325.344	82.838	0.356	
p3b2b2[12]	p3b2b2[11]	56.980	-329.1	83.01	0.35	

