// Run "cpp -P filename > newfilename" to process this file. -CG
#define IF_PREPROCESSED str creator="This file is automatically generated by the cpp preprocessor."

// GENESIS SETUP FILE
IF_PREPROCESSED

// Load common CIP functions
include ../../common/CIPfuncs.g

// Modify CIP configuration options
defdatadir = "data"
tmpdir = "data"
destdir = "data"
compressdata = 1
savesnapshot = 1
saveItotal = 1

silent -1

//load variable parameter values from environment variable
str parrow = {read_env_params}
echo "Parameter row: " {parrow}

str readcompartment

// assign variables by reading from the parrow variable
include readGPparams.g

float cip = 0

// Now that all params have been established, create library objects.
//	Intrinsic params should be left alone from this point forward.
include ../../common/make_GP_library.g

// filename based on the trial and pAcip parameters
str basefilename = "/brute_" @ {trialnum} @ "_trial"

dt = 1e-5
//set up clocks
setclock 0 {dt}	  	// simulation
setclock 1 {1e-4} 	// output
rundur = 1		// simulation length

//load compartments with ion channels
readcell {"../../common/" @ {morph_name} @ ".p"} {cellpath} -hsolve

//set up current injection
create pulsegen /pulse
addmsg /pulse {cellpath}/soma INJECT output

//set up hines solver
setfield {cellpath} 				\
    path {cellpath}/##[][TYPE=compartment] 	\
    comptmode       1 			\
    chanmode        4 			\
    calcmode        0 			\
    outclock        1 			\
    storemode       1
call {cellpath} SETUP
setmethod 11
		
//add synapses to appropriate compartments	
//include ../../common/read_STN_syns_nocluster
include ../../common/read_clusters
//include ../../common/read_striatum_syns_const_scaled
//include ../../common/add_pallidum_syns

// Do each cip run serially

// initialize CIP params
cip_init

str hstr

#define addsavefieldVm(path) \
hstr = {findsolvefield {cellpath} {cellpath}/path Vm}; \
addmsg {cellpath} /out_v SAVE {hstr} 

// save some more voltages from this morphology
// choose dendritic tips and axonal tip
addsavefieldVm(p0b2[26])
addsavefieldVm(p0b1b2b2[8])
addsavefieldVm(p1b1b1b2b2b2[7])
addsavefieldVm(p1b1b2b1b1[7])
addsavefieldVm(p1b2b2[28])
addsavefieldVm(axIN[59])

include ../../common/snapshotGP

str snapshotname = "/brute_"	@	{trialnum}	@	".save"
str defsnapshot = {defdatadir} @ {snapshotname}

fileexists = {ls {defsnapshot}}

if (fileexists != "0")
  // doesn't exist, run spont sim, and take snapshot
  // Run 1 sec to reach steady state or stable cycle 
  // and 1 sec for spontaneous firing with 0 pA cip 
  do_cip_run 0 1 1 2 {cellpath} {basefilename}  
  snapshotname = {tmpdir} @ {snapshotname}
  take_snapshot
else
  // exists
  // If snapshot is in data/, first copy to /tmp/ and then use
  cp {{defdatadir} @ {snapshotname}} {tmpdir}
  snapshotname = {tmpdir} @ {snapshotname}
  // still run the simulation unless the voltage trace also exists
  do_cip_run 0 1 1 2 {cellpath} {basefilename}  
end

// Run CIP simulations starting from snapshot point
do_cip_run -100 0 1 2   {cellpath} {basefilename} {snapshotname}
do_cip_run 40   0 1 0.5 {cellpath} {basefilename} {snapshotname}
do_cip_run 100  0 1 2   {cellpath} {basefilename} {snapshotname}
do_cip_run 200  0 1 0.5 {cellpath} {basefilename} {snapshotname}

// cleanup and finish
cip_finish
