import sys
from math import *
from p3 import *


##############################################
# Create a leaky intergrate and fire AH cell #
##############################################
AH = Cell()
AH.capacitance =   1
AH.APthreshold = -45
AH.emtrace = True

# Membrane time constant
tau = 9.0

# Resting properties: V=-65mV, tau(=RC)=9ms There is also a
# contribution from the slow EPSP
leak = hhLeak(AH)
leak.Gmax =3000.0/4800.0/tau
leak.Er = -41.67

# Action Potential
AP = ActionPotential(AH)

# Action Potential Na pulse
AP.addPulse(30000.0/4800.0/tau, 100000.0/4800.0/tau, 55, 2, 0)

# Action Potential K repolaristation
AP.addAlpha(10000.0/4800.0/tau, 100000.0/4800.0/tau, -90, 200, 0)

# Set the absolute refractory period
AP.abs_refractory = 8.0

# Add synaptically driven phosphorylation
sEPSP = slowEPSP(AH)
sEPSP.Gmax  = 1800.0/4800.0/tau
sEPSP.Er    = -90
sEPSP.alpha = 2.8e-3
sEPSP.beta1 = log(2)/1237
sEPSP.beta2 = log(2)/1083
sEPSP.beta3 = log(2)/1824
#sEPSP.dont_export_current = True
sEPSP.dsm2  = 0
sEPSP.dsm3  = 1

# Create the GKCa
AP.addGKCa(10000.0/4800.0/tau, 4*10000.0/4800.0/tau,
            1800.0/4800.0/tau, -90, 1.5, 70, 10, sEPSP)

# Add a stereotyped conductance time course to simulate a PPP
AH.ppp = fastEPSP(AH)
AH.ppp.Gmax = 8
AH.ppp.Er   = 0
AH.ppp.k    = 2500



########
# Kick #
########
for i in range(10):
    sEPSP.enq(i*10, 20)

###############
# Run options #
###############
setTRfilename('trace')
gd = GD()
gd.duration  = 10000
gd.tolerance = 1e-3
gd.network = [AH]

#######
# Run #
#######
parplex(gd)
message_print(info, 'made it')

try:
    from py2mat import Matwrap
    m = Matwrap()
    m.closeOnDel = False
    m.write('cd \'' + os.getcwd() + '\'')
    m.write('figure(1);traceplot(\'%s.dat\');\n' % trfn)
except:
    pass
