/*
 * Copyright (C) 2004 Evan Thomas
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#define P3_MODULE
#include "ndl.h"

/* One global data to rule them all ... */
GD *gd;

static void delGD(GD *self) {

    Py_XDECREF(self->network);
    Py_XDECREF(self->debug_handler);
    Py_XDECREF(self->trace_handler);
    Py_XDECREF(self->ap_handler);
    Py_XDECREF(self->endWindow_handler);
    Py_XDECREF(self->message_handler);
    Py_XDECREF(self->startWindow_handler);
    Py_XDECREF(self->dumpCell_handler);

    /* Release GD objects */
    self->ob_type->tp_free((PyObject*)self);
}

static PyObject *reprGD(GD *self) {
    return PyString_FromFormat("C Global Data object at %p, refcnt=%d",
        self, ((PyObject*)self)->ob_refcnt);
}

static PyMethodDef p3_GD_methods[] = {
 	{NULL, NULL, 0, NULL}		/* sentinel */
};

static PyMemberDef p3_GD_members[] = {
    {"duration", T_DOUBLE, offsetof(GD, duration), 
     0, "run duration"},
    {"tolerance", T_DOUBLE, offsetof(GD, tolerance), 
     0, "numerical integration tolerance"},
    {"maxStep", T_DOUBLE, offsetof(GD, maxStep), 
     0, "maximum step size (0 indicates no maximum)"},
    {"minStep", T_DOUBLE, offsetof(GD, minStep), 
     0, "minimum step size"},
    {"window", T_DOUBLE, offsetof(GD, window), 
     0, "waveform relaxation window size"},
    {"windowStart", T_INT, offsetof(GD, windowStart), 
     READONLY, "start of current window"},
    {"windowID", T_INT, offsetof(GD, windowID), 
     READONLY, "sequence number of the current waveform relaxation window"},
    {"firstRound", T_INT, offsetof(GD, firstRound), 
     READONLY, "true if this is the first round of the current window"},
    {"reDoCnt", T_INT, offsetof(GD, reDoCnt), 
     READONLY, "Number of times a cell had to be recalculated in this partition"},
    {"sendMsgCnt", T_INT, offsetof(GD, sendMsgCnt), 
     READONLY, "number of messages send from this partition"},
    {"recvMsgCnt", T_INT, offsetof(GD, recvMsgCnt), 
     READONLY, "number of messages received in this partition"},
    {"roundCnt", T_INT, offsetof(GD, roundCnt), 
     READONLY, "total number relaxtion interations in this partition"},
	{NULL}		/* sentinel */
};

static int setfunction(PyObject **at, PyObject *f) {
    if( !PyObject_IsTrue(f) ) {
        *at = 0;
        return 0;
    }
    if( PyList_Check(f) ) {
      int i;
      int size = PyList_Size(f);
      PyObject *o;
      for(i=0; i<size; i++) {
	o = PyList_GetItem(f, i);
	if( !PyCallable_Check(o) ) {
	  PyErr_SetString(PyExc_TypeError,
			  "Need a callable object or a list of callable objects");
	  return -1;
	}
      }
    }
    if( !PyCallable_Check(f) && !PyList_Check(f) ) {
        PyErr_SetString(PyExc_TypeError,
            "Need a callable object or a list of callable objects");
        return -1;
    }
    Py_XDECREF(*at);
    Py_INCREF(f);
    *at = f;
    return 0;
}

static PyObject *getfunction(PyObject **at) {
    if( *at ) {
        Py_INCREF(*at);
        return *at;
    } else {
        Py_INCREF(Py_None);
        return Py_None;
    }
}

static int p3_GD_setmessage_handler(GD *self, PyObject *f, void *c) {
    return setfunction(&(self->message_handler), f);
}
static PyObject *p3_GD_getmessage_handler(GD *self, void *C) {
    return getfunction(&(self->message_handler));
}

static int p3_GD_setdebug_handler(GD *self, PyObject *f, void *c) {
    return setfunction(&(self->debug_handler), f);
}
static PyObject *p3_GD_getdebug_handler(GD *self, void *C) {
    return getfunction(&(self->debug_handler));
}

static int p3_GD_settrace_handler(GD *self, PyObject *f, void *c) {
    return setfunction(&(self->trace_handler), f);
}
static PyObject *p3_GD_gettrace_handler(GD *self, void *C) {
    return getfunction(&(self->trace_handler));
}

static int p3_GD_setap_handler(GD *self, PyObject *f, void *c) {
    return setfunction(&(self->ap_handler), f);
}
static PyObject *p3_GD_getap_handler(GD *self, void *C) {
    return getfunction(&(self->ap_handler));
}

static int p3_GD_setendWindow_handler(GD *self, PyObject *f, void *c) {
    return setfunction(&(self->endWindow_handler), f);
}
static PyObject *p3_GD_getendWindow_handler(GD *self, void *C) {
    return getfunction(&(self->endWindow_handler));
}

static int p3_GD_setstartWindow_handler(GD *self, PyObject *f, void *c) {
    return setfunction(&(self->startWindow_handler), f);
}
static PyObject *p3_GD_getstartWindow_handler(GD *self, void *C) {
    return getfunction(&(self->startWindow_handler));
}

static int p3_GD_setstepTrace_handler(GD *self, PyObject *f, void *c) {
    return setfunction(&(self->stepTrace_handler), f);
}
static PyObject *p3_GD_getstepTrace_handler(GD *self, void *C) {
    return getfunction(&(self->stepTrace_handler));
}

static int p3_GD_setdumpCell_handler(GD *self, PyObject *f, void *c) {
    return setfunction(&(self->dumpCell_handler), f);
}
static PyObject *p3_GD_getdumpCell_handler(GD *self, void *C) {
    return getfunction(&(self->dumpCell_handler));
}

static int p3_GD_setnetwork(GD *self, PyObject *f, void *c) {
    if( f==Py_None ) {
        self->network = 0;
        return 0;
    }
    if( !PyList_Check(f) ) {
        PyErr_SetString(PyExc_TypeError,
            "Network must be a list");
        return -1;
    }
    Py_XDECREF(self->network);
    Py_INCREF(f);
    self->network = f;
    return 0;
}

static PyObject *p3_GD_getnetwork(GD *self, void *C) {
    return getfunction(&(self->network));
}

static PyGetSetDef p3_GD_getseters[] = {
    {"message_handler", 
     (getter)p3_GD_getmessage_handler, (setter)p3_GD_setmessage_handler,
     "handler for output messages: message_handler(msg_level, msg)",
     NULL},
    {"debug_handler", 
     (getter)p3_GD_getdebug_handler, (setter)p3_GD_setdebug_handler,
     "handler for debug messages: debug_handler(msg)",
     NULL},
    {"trace_handler", 
     (getter)p3_GD_gettrace_handler, (setter)p3_GD_settrace_handler,
     "called per cell at window end to handle trace output: GD.endWindow_handler(cell)",
     NULL},
    {"ap_handler", 
     (getter)p3_GD_getap_handler, (setter)p3_GD_setap_handler,
     "called per cell at window end to handle AP output: endWindow_handler(cell)",
     NULL},
    {"endWindow_handler", 
     (getter)p3_GD_getendWindow_handler, (setter)p3_GD_setendWindow_handler,
     "called once at the end of each window: endWindow_handler(GD)",
     NULL},
    {"startWindow_handler", 
     (getter)p3_GD_getstartWindow_handler, (setter)p3_GD_setstartWindow_handler,
     "called once at the start of each window: endWindow_handler(GD)",
     NULL},
    {"stepTrace_handler", 
     (getter)p3_GD_getstepTrace_handler, (setter)p3_GD_setstepTrace_handler,
     "called per cell at each failed and accepted step: stepTrace_handler(cell)",
     NULL},
    {"dumpCell_handler", 
     (getter)p3_GD_getdumpCell_handler, (setter)p3_GD_setdumpCell_handler,
     "called by internal debugging routines: dumpCell_handler(cell, msglevel)",
     NULL},
    {"network", 
     (getter)p3_GD_getnetwork, (setter)p3_GD_setnetwork,
     "a list of cells making up the network",
     NULL},
    {NULL}  /* Sentinel */
};

PyTypeObject p3_GDType = {
    PyObject_HEAD_INIT(NULL)
    0,                         /*ob_size*/
    "_p3.GD",             /*tp_name*/
    sizeof(GD),      /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)delGD,                         /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    (reprfunc)reprGD,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    0,                         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,        /*tp_flags*/
    "Parplex GlobalData object",   /* tp_doc */
    0,		               /* tp_traverse */
    0,		               /* tp_clear */
    0,		               /* tp_richcompare */
    0,		               /* tp_weaklistoffset */
    0,		               /* tp_iter */
    0,		               /* tp_iternext */
    p3_GD_methods,             /* tp_methods */
    p3_GD_members,             /* tp_members */
    p3_GD_getseters,          /* tp_getset */
    0,                         /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    0,      /* tp_init */
    0,                         /* tp_alloc */
    PyType_GenericNew                 /* tp_new */
};
