/*
 * Copyright (C) 2004 Evan Thomas
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/****************************************************************
  Generate random numbers, using the sprng library or C library
  depending on the compile time option.
*****************************************************************/

#define P3_MODULE
#include "ndl.h"

#define EXACT_PI 3.141592653589793238462643

static bool initialised;
static int   user_seed = -1;

static void init(void) { 
  int  seed; /* make seed from date/time information */
  int rc;

  if( user_seed == -1 ) {
    seed = (int)time(0);
  } else {
    seed = user_seed;
  }
  srand(seed);
  rc = 1;
    
  if( !rc )
    ABEND("Random number generator initialisation failed", (Cell*)Py_None);

  message(info, "Random number seed: %d\n", seed);

  user_seed = seed;

  initialised = true;
}

void set_random_seed(int s) {user_seed = s;}

static double my_rand(void) {
  return (double)rand()/RAND_MAX;
}

double rand_flat(void) {
  if( !initialised ) init();
  return my_rand();
}

double rand_norm(double mean, double std) {
  static int    f;
  double        x1, x2, y1, t1;
  static double y2;
  
  if( !initialised ) init();

  if( f ) {
    f = 0;
    return mean+std*y2;
  }

  do {
	x1 = my_rand();
  }	while( x1==0 || x1==1 );
  t1 = sqrt(-2.0*log(x1));
  do {
	x2 = my_rand();
  }	while( x2==0 || x2==1 );
  

  y1 = t1 * cos(2.0*EXACT_PI*x2);
  y2 = t1 * sin(2.0*EXACT_PI*x2);

  f = 1;

  return mean+std*y1;
}

int get_random_seed(void) {
  if( !initialised ) init();
  return user_seed;
}
/* CHANGELOG
   EAT 23Jan03
   Allowed conditional compilation of MPI and SPRNG.
   EAT 31Aug07
   Removed SPRNG, now based purely on the C library
   EAT 16Jul08
   A bug in rand_norm, xi should be in (0,1), not [0,1].
   This caused rand_norm to return garbage values.
*/
