#!/usr/bin/python
import os, sys, time

#import logwindow
#logger = logwindow.LogWindow()

from p3 import *

#################################################
# Test the implicit methods in a trivial system #
#################################################        

def makeFlacidcell():
    cell = Cell()
    cell.capacitance = 1
    cell.APthreshold = -30
    cell.Em = -60
    cell.emtrace = True
    cell.timeSample = 0

    # Leak
    leak = hhLeak(cell)
    leak.Gmax = 0.5
    leak.Er   = -60

    ci = CurrentInjection(cell)
    ci.start   = 10
    ci.end     = 60
    ci.Iinject = 10
    
    return cell, 100
    
def makeHHcell():
    cell = Cell()
    cell.capacitance = 1
    cell.APthreshold = -50
    cell.Em = 0
    cell.emtrace = True
    cell.timeSample = 0.5

    # Leak
    hh = hhLeak(cell)
    hh.Gmax = 0.3
    hh.Er   = 10.163

    # Na
    Na = hhNa(cell)
    Na.Gmax = 115
    Na.Er   = 120
    Na.m = 0.0519918603202
    Na.h = 0.601419324468
    cell.hhNa = Na

    # K
    K = hhK(cell)
    K.Gmax = 36
    K.Er   = -12
    K.n = 0.316173233528
    cell.hhK = K
    
    # fast EPSP
    fEPSP = fastEPSP(cell)
    fEPSP.Gmax = 36
    fEPSP.Er   = 50
    fEPSP.k    = 8000
    cell.fEPSP = fEPSP

    #cell.fEPSP.enq(5, 1.1)
    
    ci = CurrentInjection(cell)
    ci.start   = 10
    ci.end     = 960
    ci.Iinject = 10
    
    # Noise
    #c = Inoise(cell)
    #c.mean = 0
    #c.std  = 0.2
    
    return cell, 1000

###############
# Run options #
###############
set_message_option('noinfo')
setTRfilename('trace')
gd = GD()
gd.duration  = 1000
gd.tolerance = 1e-4
gd.window = 50
gd.network = []

makecell = makeHHcell

#######
# Run #
#######
(cell, time) = makecell()
cell.method = rk32
gd.network.append(cell)

(cell, time) = makecell()
cell.method = rdIIA
gd.network.append(cell)

(cell, time) = makecell()
cell.method = rw23
gd.network.append(cell)

gd.duration = 100
parplex(gd)

set_message_option('info')
    

for cell in gd.network:
    message_print(info, 'id=%d %s: %d total steps, %d succesful, %d function evals, %d Jacobian evals, %d Newton iters\n' % (cell.id, cell.method, cell.stepTotal, cell.stepAccepts, cell.functionCnt, cell.jacobianCnt, cell.newtonCnt))

tracefile_close()

#logger.waitForClose()

from traceplot import plotto
plotto('trace.dat')
