"""
 * Copyright (C) 2004 Evan Thomas
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
"""

"""
Test the interpolation routines
"""

import sys
from p3 import *


# Build neuron
def makecell():
    cell = Cell()
    cell.capacitance = 1
    cell.Em = -57
    cell.emtrace = True
    cell.timeSample = 0.5
    cell.threshold = -40
    cell.method = rk32
    
    d = hhLeak(cell)
    d.Er   = -60
    d.Gmax = 0.1
    
    d = CurrentInjection(cell)
    d.start = 10
    d.end = 110
    d.Iinject = 0

    return cell

cell1 = makecell()
cell2 = makecell()
cell2.timeSample = 0
network = [cell1, cell2]

###############
# Run options #
###############
set_message_option('noinfo')
setTRfilename('trace')
gd = GD()
gd.duration  = 120
gd.tolerance = 1e-4
gd.network = network

#######
# Run #
#######
parplex(gd)
set_message_option('info')
message_print(info, 'made it\n')


#####################
# Initialise matlab #
#####################
try:
    from py2mat import Matwrap
    m = Matwrap()
    m.closeOnDel = False
    m.write('cd \'' + os.getcwd() + '\'')
    print m.read()
    m.write('figure(2);traceplot(\'trace.dat\')\n')
    print m.read()
except:
    message_print(info, 'No matlab\n')
    pass
