/*
 * Copyright (C) 2004 Evan Thomas
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* Current sources - injections, noise */

#include "ndl.h"

/*---------
     Leak
-----------*/
typedef struct {
    DYNAMICS
  double Gmax;    /* The maximum conductance */
  double Er;      /* The driving potential */
}  Leak;

static double Leakcurrent(Leak *self, double t) {
  double v   = GETEM_DYN(self, t);
  double Gmax = self->Gmax;
  double Er = self->Er;
  return -Gmax * (v-Er);
}

static PyMemberDef Leak_members[] = {
    {"Gmax", T_DOUBLE, offsetof(Leak, Gmax), 0, "maximum conductance"},
    {"Er", T_DOUBLE, offsetof(Leak, Er), 0, "reversal potential"},
    {NULL},
};

DynamicsDescriptor LeakDescriptor = {
    "Leak",
    "Leak current",
    Leak_members,
    0,
    0,
    0,
    0,
    0,
    0,
    (currentfcn*)Leakcurrent,
    0,
    0,
    0,
    sizeof(Leak),
    0,
    0,
	0,
	0,
	0,
	0,
	0,
	0,
	HIdynamics
};
REGISTER_DESCRIPTOR(LeakDescriptor)

/*-------------------
  Current injection
---------------------*/
typedef struct {
    DYNAMICS
    double start;
    double end;
    double Iinject;
} CurrentInjection;

static PyMemberDef p3_CurrentInjection_members[] = {
    {"start", T_DOUBLE, offsetof(CurrentInjection, start),
     0, "start time of current injection"},
    {"end", T_DOUBLE, offsetof(CurrentInjection, end),
     0, "end time of current injection"},
    {"Iinject", T_DOUBLE, offsetof(CurrentInjection, Iinject),
     0, "amount of current injected"},
    {NULL},
};

static double inject_current(CurrentInjection *c, double t) {
  double start      = c->start;
  double end        = c->end;
  double current    = c->Iinject;

  if( start<= t && t<=end) return current;
  else return 0;
}

DynamicsDescriptor CurrentInjectionDescriptor = {
    "CurrentInjection",
    "CurrentInjection, members: start, end, current",
    p3_CurrentInjection_members, /* Members */
    0,
    0,  /* number of state variables */
    0,  /* State variable names */
    0,  /* deriv variable names */
    0,  /* trace variable names */
    0,  /* Derivs */
    (currentfcn*)inject_current,
    0,  /* acceptor */
    0,  /* enqueue */
    0,  /* cleanup */
    sizeof(CurrentInjection),
    0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	HIdynamics
};
REGISTER_DESCRIPTOR(CurrentInjectionDescriptor)

static DynamicsDescriptor *userDynamics[] = {
	&LeakDescriptor,
    &CurrentInjectionDescriptor
};

static initproc LuserInitDynamics[] = {
	initLeakDescriptor,
    initCurrentInjectionDescriptor
};


MAKE_P3_MODEL(isrc, "Current injection")
