"""
/*
 * Copyright (C) 2007 Evan Thomas
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
"""

#
# Units and constants for parplex
#

from math import pi
# Units
mole   = 1e3
meter  = 1
litre  = 1
cm     = meter*1e-2
um     = meter*1e-6
nm     = meter*1e-9
ms     = 1  # Time is in ms!!!
mM     = mole*1e-3/litre

coul   = 1

uF     = 1e-6

Ohm = 1
S   = 1
mS  = S*1e-3
uS  = S*1e-6

# Current is in units of coul/ms !
mA     = 1e-3 / ms
uA     = 1e-6 / ms
nA     = 1e-9 / ms
pA     = 1e-12 / ms

# Constants
FARADAY = 96520*coul
