#!/usr/bin/python
import os, sys, time
from math import pi, exp

from p3 import *

################################################
# Test the C code implementation of fast EPSPs #
################################################

class Passive(PyDynamics):
    def __init__(self, cell, Gleak, Vleak):
        PyDynamics.__init__(self, cell)
        self.Gleak = Gleak
        self.Vleak = Vleak
        
    def current(self, t):
        Em = self.owner.Em
        return self.Gleak * (self.Vleak - Em)
        

def makecell():
    cell = Cell()
    cell.capacitance = 10
    cell.APthreshold = -50
    cell.Em = -60
    cell.emtrace = True

    # Leak
    Gleak = 0.5
    Eleak = -60
    Passive(cell, Gleak, Eleak)
    
    # fEPSP
    Gsyn = 30
    Esyn = 0
    cell.fepsp = fastEPSP(cell)
    cell.fepsp.Gmax = 30
    cell.fepsp.Er = 0
    cell.fepsp.k = 8000
    
    return cell
    
strength = 18
trans_time = 15
##################
# Make a network #
##################
network = []
cell1 = makecell()
network.append(cell1)
cell2 = makecell()
network.append(cell2)
syn = Synapse(cell1, cell2.fepsp)
syn.nominal_strength = strength
syn.trans_time = trans_time
syn = Synapse(cell2, cell1.fepsp)
syn.nominal_strength = strength
syn.trans_time = trans_time

##################################
# Add a stimulus to get it going #
##################################
cell1.fepsp.enq(10, strength)

###############
# Run options #
###############
setTRfilename('trace')
gd = GD()
gd.duration  = 300
gd.tolerance = 1e-4
gd.network = network

#######
# Run #
#######
parplex(gd)
message_print(info, 'made it')

from traceplot import plotto
plotto('trace.dat')
