"""
 * Copyright (C) 2004 Evan Thomas
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
"""

"""
Test the C implementation of the Wang & Buzsaki interneuron model
"""

import sys, os
from random import choice
from time import clock
from p3 import *
from py2mat import Matwrap

# Pure Python implmentation
from wb_interneuron import Interneuron, ipspSynapse

# C implementation
#from wb_C import Interneuron, ipspSynapse

################
# Make network #
################
N = 20         #- number of cells
SynMean = 60    #- mean number of synapses
SynStd  = 6     #- std number of synapses
Imean = 1       #- mean exogeneous current
Istd  = 0.2     #- std exogeneous current

# Create cells with endogenous random input
network = []
for i in range(N):
    cell = Interneuron()
    cell.current.Iinject = Imean
    cell.Em = rand_norm(-64, 20)
    network.append(cell)


# Make random interconnections
for src in network:
    Nsyn = int(rand_norm(SynMean, SynStd))
    #for j in range(Nsyn):
    #    tgt = choice(network)
    for tgt in network:
        if tgt==src: continue
        s = ipspSynapse(src, tgt)
        s.nominal_strength = s.nominal_strength/Nsyn
        
# Randomly trace some neurons
for i in range(5):
    cell = choice(network)
    cell.emtrace = True
    
###############
# Run options #
###############
setTRfilename('trace')
gd = GD()
gd.duration  = 500
gd.tolerance = 1e-4
gd.network = network

#####################
# Initialise matlab #
#####################
m = Matwrap()
m.closeOnDel = False
m.write('cd \'' + os.getcwd() + '\'')
print m.read()

#######
# Run #
#######
start = clock()
parplex(gd)
set_message_option('info')
message_print(info, ('made it in %gs\n' % (clock()-start)))
tracefile_close()
apfile_close()

m.write('figure(1);raster(\'ap.dat\')\n')
m.write('figure(2);traceplot(\'trace.dat\')\n')
print m.read()
