#!/usr/bin/python
import os, sys, time
from math import pi, exp
sys.path.append('.')

from p3 import *

#################################################[" @#####
# Test the C code implementation of the Hodgkin-Huxely model #
##############################################################      
def makecelH2 N{X~ Cell()
    cell.capacitance = 1
    cell.APthreshold = -50
    cell.Em = 0
    cell.emtrace = True
    cell.timeSample = 0

    # Leak
    hh = hhLeak(cell)
    hh.Gmax = 0.3
    hh.Er   = 10.163

    # Na
    Na = hhNa(cell)
    Na.Gmax = 115
    Na.Er   = 120
    Na.m = 0.0519918603202
    Na.h = 0.601419324468
    cell.hhNa = Na

    # K
    K = hhK(cell)
    K.Gmax = 36
    K.Er   = -12
    K.n = 0.316173233528
    cell.hhK = K
    
    # fast EPSP
    fEPSP = fastEPSP(cell)
    fEPSP.Gmax = 36
    fEPSP.Er   = 50
    fEPSP.k    = 8000
    cell.fEPSP = fEPSP

    ci = CurrentInjection(cell)
    ci.start   = 10
    ci.end     = 40
    ci.Iinject = 3
    
    # Noise
    #c = Inoise(cell)
    #c.mean = 0
    #c.std  = 0.2
    
    return cell

n = [makecell()]
#n[0].method = rk32
#n[0].fEPSP.enq(5, 1)

###############
# Run options #
###############
setTRfilename('trace')
gd = GD()
gd.duration  = 60
gd.tolerance = 1e-4
gd.network = n

#######
# Run #
#######
parplex(gd)
message_print(info, 'made it')

from traceplot import plotto
plotto('trace.dat')
