%Biosystems. 2009 Jul;97(1):35-43.
%Horcholle-Bossavit G, Quenet B.
%Neural model of frog ventilatory rhythmogenesis.
%Fig8

clear all

global beta gamma delta Em0  Eml1 maxAc 

Tsim=300;
delaiaff=1;
finaff=Tsim;
sd=2;
epsilon=0.05;
beta=1.018;             
gamma=0.05;                   
delta=2;
maxAc=2;
Em0=0.1;

fig8params
if exist('fig8new.jpg')
subplot('Position',[0.6 0.68 0.30 0.30]);
    fig1=imread('fig8new.jpg');
    imagesc(fig1);
    axis off;
end    


text(-765,80,['A'],...
    'VerticalAlignment','middle',...
    'HorizontalAlignment','left',...     
    'FontName','arial','FontWeight','normal','FontSize',16,'FontAngle','normal','Color',[0 0 0])

text(-80,200,['b'],...
    'VerticalAlignment','middle',...
    'HorizontalAlignment','left',...     
    'FontName','arial','FontWeight','normal','FontSize',16,'FontAngle','normal','Color',[0 0 0])

text(-700,200,['a'],...
    'VerticalAlignment','middle',...
    'HorizontalAlignment','left',...     
    'FontName','arial','FontWeight','normal','FontSize',16,'FontAngle','normal','Color',[0 0 0])

subplot('Position',[0.18 0.72 0.25 0.25]);
imagesc(S)
notremap=[0 0 0;1 1 1;0.5 0.5 0.5];
colormap(flipud(notremap))
set(gcf,'Color',[1 1 1])
set(gca,'FontName','arial','FontWeight','bold','FontSize',9)

subplot('Position',[0.08 0.48 0.85 0.14]);
plot(0.7*Eml1(delaiaff+1:finaff),'k', 'LineWidth', 0.5)
set(gca,'XLim', [0 finaff-delaiaff]);
set(gca,'XTick',[0 (finaff-delaiaff)/2 finaff-delaiaff])
set(gca,'YLim',[0  0.7]);
set(gca,'FontName','arial','FontWeight','bold','FontSize',10)
text(-24,0.8,['B'],...
    'VerticalAlignment','middle',...
   'HorizontalAlignment','left',...
    'FontName','arial','FontWeight','normal','FontSize',16,'FontAngle','normal','Color',[0 0 0])
hold on
line([20 300],[0.7 0.7],'LineWidth',0.5,'Color',[0.5 0.5 0.5], 'LineStyle',':')
plot(nirings((nirings(:,2)==1 & nirings(:,1)>delaiaff & nirings(:,1)<=finaff ),1)-delaiaff, nirings((nirings(:,2)==1 & nirings(:,1)>delaiaff & nirings(:,1)<=finaff ),2)-1+0.7,'diamond','MarkerEdgeColor',[0 0 0],'MarkerFaceColor',[0 0 0], 'MarkerSize', 2)
text(1,0.69,[' l1 firings '],...  
    'VerticalAlignment','middle',...
    'HorizontalAlignment','left',...
    'FontName','arial','FontWeight','bold','FontSize',9,'FontAngle','italic')
text(40,0.4,['Em'],...
    'VerticalAlignment','middle',...
   'HorizontalAlignment','left',...
    'FontName','arial','FontWeight','bold','FontSize',9,'FontAngle','italic','Color',[0 0 0])
text(54,0.3,['l1'],...
    'VerticalAlignment','middle',...
   'HorizontalAlignment','left',...
    'FontName','arial','FontWeight','bold','FontSize',8,'FontAngle','italic','Color',[0 0 0])
set(gca,'FontName','arial','FontWeight','bold','FontSize',10)
set(gca,'XTick',[])
box off
set(gcf,'Color',[1 1 1])

subplot('Position',[0.08 0.10 0.85 0.30]);
plot([0:finaff-delaiaff],0.5* actotbc(delaiaff+1:finaff+1),'LineWidth',0.5,'Color',[0 0 0], 'LineStyle','-');
hold on
plot([0:finaff-delaiaff],(0.5*actotbd(delaiaff+1:finaff+1)),'LineWidth',0.5,'Color',[0.5 0.5 0.5], 'LineStyle','-');
hold on
deb=min([actotbc(delaiaff+1:finaff+1),actotbd(delaiaff+1:finaff+1)]');
fin=max([actotbc(delaiaff+1:finaff+1),actotbd(delaiaff+1:finaff+1),]');

plot([0:finaff-delaiaff],fin+4*matactl(delaiaff+1:finaff+1),'LineWidth',0.7,'Color',[0 0 0 ], 'LineStyle','-');
set(gca,'XLim', [0 finaff-delaiaff+1],'YLim',[0 fin+4]);
labt=get(gca,'XTickLabel');
set(gca,'XTickLabel',[0 5 10 15 20 25 30])
set(gca,'YTickLabel',{0;4;0;'';1;'';''})

set(gca,'FontName','arial','FontWeight','bold','FontSize',9)
xlabel('time steps');
set(gca,'FontName','arial','FontWeight','bold','FontSize',9)
xlabel('time (s)');
text(-24,6.1,['C'],...
    'VerticalAlignment','middle',...
   'HorizontalAlignment','left',...
    'FontName','arial','FontWeight','normal','FontSize',16,'FontAngle','normal','Color',[0 0 0])
text(105,7,['OS'],...
    'VerticalAlignment','middle',...
   'HorizontalAlignment','left',...
    'FontName','arial','FontWeight','bold','FontSize',10,'FontAngle','italic','Color',[0 0 0])
text(117,6.6,['l1'],...
    'VerticalAlignment','middle',...
   'HorizontalAlignment','left',...
    'FontName','arial','FontWeight','bold','FontSize',8,'FontAngle','italic','Color',[0 0 0])
text(56,2.9,['OS'],...
    'VerticalAlignment','middle',...
   'HorizontalAlignment','left',...
    'FontName','arial','FontWeight','bold','FontSize',10,'FontAngle','italic','Color',[0 0 0])
text(68,2.5,['Bc'],...
    'VerticalAlignment','middle',...
   'HorizontalAlignment','left',...
    'FontName','arial','FontWeight','bold','FontSize',8,'FontAngle','italic','Color',[0 0 0])
text(220,2.9,['OS'],...
    'VerticalAlignment','middle',...
   'HorizontalAlignment','left',...
    'FontName','arial','FontWeight','bold','FontSize',10,'FontAngle','italic','Color',[0.5 0.5 0.5])
text(232,2.5,['Bd'],...
    'VerticalAlignment','middle',...
   'HorizontalAlignment','left',...
    'FontName','arial','FontWeight','bold','FontSize',8,'FontAngle','italic','Color',[0.5 0.5 0.5])
set(gca,'FontName','arial','FontWeight','bold','FontSize',10)

box off




