"""
 * Copyright (C) 2007 Evan Thomas
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
"""

"""
Test harness for the STDP class
"""

import sys
sys.path = ['C:\Documents and Settings\evan\My Documents\Visual Studio Projects\parplex']+sys.path
from p3 import *
from STDPsynapse import *


def makecell():
    ##############################################
    # Create a leaky intergrate and fire AH cell #
    ##############################################

    # Membrane time constant
    tau = 20
    # Base Cell constructor
    AH = Cell()
    # Rm = 1, C = tau/Rm, all conductances are relative to Rm
    AH.capacitance =  tau
    # This is the membrane potential crossing that defines an action potential
    AH.APthreshold = -60
    # Turn on membrane potential capture
    AH.emtrace = True

    # A leak conductance constructor
    leak = hhLeak(AH)
    # all conductances are relative to Rm
    leak.Gmax = 1
    # Resting membrane properties are provided by the leak
    leak.Er = -70
    
    # The leaky-integrate-and-fire action potential constructor
    AP = ActionPotential(AH)
    # Save is as a member in the cell object for future convenience
    AH.AP = AP
    
    # Action Potential square Na pulse:
    # addPulse(gMax, gTotal, Er, width, delay)
    AP.addPulse(30, 100, 55, 2, 0)
    
    # Action Potential K repolaristation using an alpha function:
    # addAlpha(gMax, gTotal, Er, k, delay)
    # where alpha(t,k) = t * k * 1e-3 * exp( 1 - t * k * 1e-3 )
    AP.addAlpha(400, 10, -90, 1200, 0)
    
    # Set the absolute refractory period
    AP.abs_refractory = 8.0
    
    # Initial membrane potential
    AH.Em = -70

    #AH.stepTrace = True

    return AH


# This test fires 10 presynaptic APs in c1.
# The post synaptic reponse decreases slightly
c1 = makecell()
c2 = makecell()
syn = STDPSynapse(c1, c2, 5, 2, 0, 5)
for i in range(10):
    c1.AP.enq(10+i*100)
    stepOn(c1,10+i*100-1e-2)

# This fires 10 post synaptic APs and 2 test
# EPSPs before and after. The second test
# EPSP is slightly larger
c3 = makecell()
c4 = makecell()
syn = STDPSynapse(c3, c4, 5, 1.5, 0, 5)
c4.STDPDepression.Plist[0].enq(10, 1)
c4.STDPDepression.Plist[0].enq(1050, 1)
for i in range(20):
    c4.AP.enq(50+i*50, 1)
    stepOn(c4,50+i*50-1e-2)


###############
# Run options #
###############
trfn = 'trace'
setTRfilename(trfn) # set trace file name
gd = GD() # This object contains global run options
gd.duration  = 1200 # Run duration
gd.tolerance = 1e-3 # Solver tolerance
gd.network = [c1, c2, c3, c4] # The list cells in the network
set_message_option('nodebug')
#gd.stepTrace_handler = stepTicker

#######
# Run #
#######
parplex(gd)
message_print(info, 'made it')

try:
    from py2mat import Matwrap
    m = Matwrap()
    m.closeOnDel = False
    m.write('cd \'' + os.getcwd() + '\'')
    m.write('figure(1);traceplot(\'%s.dat\');\n' % trfn)
except:
    pass
