"""
 * Copyright (C) 2007 Evan Thomas
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
"""

from distutils.core import setup, Extension
from glob import glob

srcfiles = [ \
    'array.c',
    'cell.c',
    'compartment.c',
    'dynamics.c',
    'dyn_py.c', 
    'dyn_hi.c', 
    'dyn_vgc.c', 
    'dyn_ca.c', 
    'gd.c',
    'hines.c',
    'intlist.c',
    'jacobian.c',
    'message.c',
    'p3.c',
    'pqueue.c',
    'random.c',
    'rdIIA.c',
    'rk32.c',
    'rw23.c',
    'solve.c',
    'stepper.c',
    'synapse.c',
    'synmsg.c' \
    ]


testfiles = glob('test_*.py')

mpi = False
if mpi:
    defmac = [('MPI', 0)]
    includes = ['C:\Program Files\MPICH2\include']
    libraries = ['C:\Program Files\MPICH2\lib\mpich2']
else:
    defmac = []
    includes = []
    libraries = []

setup(name="parplex",
      version="0.3",
      description="The parallel biophysical neural network simulator",
      author="Evan Thomas",
      author_email="evan@evan-thomas.net",
      url="http://evan-thomas.net/parplex",
      package_dir = {"parplex" : ""},
      packages = ["parplex"],
      py_modules=["p3", "parplex.units", "p3Build"],
      ext_modules=[Extension("parplex._p3", srcfiles,
                             define_macros=defmac,
                             include_dirs=includes,
                             libraries=libraries),
                   Extension("parplex.fpsp",  ['dyn_fpsp.c'],
                             define_macros=defmac,
                             include_dirs=includes,
                             libraries=libraries),
                   Extension("parplex.isrc",  ['dyn_isrc.c'],
                             define_macros=defmac,
                             include_dirs=includes,
                             libraries=libraries),
                   Extension("parplex.noise", ['dyn_noise.c'],
                             define_macros=defmac,
                             include_dirs=includes,
                             libraries=libraries),
                   Extension("parplex.wb",    ['dyn_wb.c'],
                             define_macros=defmac,
                             include_dirs=includes,
                             libraries=libraries),
                   Extension("parplex.lif",   ['dyn_lif.c'],
                             define_macros=defmac,
                             include_dirs=includes,
                             libraries=libraries),
                   Extension("parplex.pr",    ['dyn_pr.c'],
                             define_macros=defmac,
                             include_dirs=includes,
                             libraries=libraries),
                   Extension("parplex.hh",    ['dyn_hh.c'],
                             define_macros=defmac,
                             include_dirs=includes,
                             libraries=libraries),
                   Extension("parplex.spsp",  ['dyn_spsp.c'],
                             define_macros=defmac,
                             include_dirs=includes,
                             libraries=libraries)
                   ],
      scripts = ['mkdll.py'],
      headers = ['ndl.h']
      )

# python setup.py build sdist --formats=gztar
