#!/usr/bin/python
import os, sys, time
from math import pi, exp

from p3 import *

####################################################
# Implement the mutant Na channel models in Python #
####################################################

class Passive(PyDynamics):
    def __init__(self, cell, Gleak, Vleak):
        PyDynamics.__init__(self, cell)
        self.Gleak = Gleak
        self.Vleak = Vleak
        
    def current(self, t):
        Em = self.owner.Em
        return self.Gleak * (self.Vleak - Em)


cell = Cell()
cell.capacitance = 1
cell.APthreshold = -30
cell.Em = -60
cell.emtrace = True

# Leak
Gleak = 0.5
Eleak = -60
Passive(cell, Gleak, Eleak)

ci = CurrentInjection(cell)
ci.start   = 10
ci.end     = 60
ci.Iinject = 10

###############
# Run options #
###############
setTRfilename('trace')
gd = GD()
gd.duration  = 100
gd.tolerance = 1e-4
gd.network = [cell]

#######
# Run #
#######
parplex(gd)
message_print(info, 'made it')

from traceplot import plotto
plotto('trace.dat')
