/*
 * Copyright (C) 2004 Evan Thomas
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*********************************************************************
  Handle text messages.  The main C code issues informational, death
  and debug text messages.
*********************************************************************/

#define P3_MODULE
#include "ndl.h"

/* Static buffer length */
#define BL 2000


void message(msglevel m, char* fmt, ...) {
  va_list args;
  PyObject *arglist;
  char junk[BL];

  if( !gd || !gd->message_handler ) return;

  va_start(args, fmt);
  vsprintf(junk, fmt, args);
  va_end(args);

  if( strlen(junk) >= BL-1 )
    ABEND("Internal message buffer overflow", (Cell*)Py_None);
  
  arglist = Py_BuildValue("(is)", m, junk);

  mycallobject(gd->message_handler, arglist);
  
  Py_DECREF(arglist);
  
}

void debug_msg(char* fmt, ...) {
  va_list args;
  PyObject *arglist;
  char junk[BL];

  if( !gd || !gd->debug_handler ) return;

  va_start(args, fmt);
  vsprintf(junk, fmt, args);
  va_end(args);

  if( strlen(junk) == BL-1 ) 
      ABEND("Internal message buffer overflow", (Cell*)Py_None);
  
  arglist = Py_BuildValue("(s)", junk);

  mycallobject(gd->debug_handler, arglist);
  
  Py_DECREF(arglist);
  
}

void dumpCell(Cell *cell, msglevel m) {
  PyObject *arglist;

  if( !gd || !gd->dumpCell_handler ) return;
  
  arglist = Py_BuildValue("(Oi)", cell, m);

  mycallobject(gd->dumpCell_handler, arglist);
  
  Py_DECREF(arglist);
  
}
/* CHANGELOG
   EAT 23Jan03
   Allowed conditional compilation of MPI.
*/
