#!/usr/bin/python
import os, sys, time
from math import pi, exp, log

from p3 import *

#########################################################
# Test the C code implementation of the slow EPSP model #
#########################################################      

cell = Cell()
cell.capacitance = 1
cell.APthreshold = -50
cell.Em = -60
cell.emtrace = True

# Leak
hh = hhLeak(cell)
hh.Gmax = 0.6
hh.Er   = -35

# slow EPSP
s = slowEPSP(cell)
s.Gmax  = 0.5
s.Er    = -90
s.alpha = 2.8e-3
s.beta1 = log(2)/1237
s.beta2 = log(2)/1083
s.beta3 = log(2)/1824
s.dsm2 = 0
s.dsm3 = 1

########
# Kick #
########
for i in range(10):
    s.enq(i*10, 10)

###############
# Run options #
###############
setTRfilename('trace')
gd = GD()
gd.duration  = 10000
gd.tolerance = 1e-4
gd.network = [cell]

#######
# Run #
#######
parplex(gd)
message_print(info, 'made it')

from traceplot import plotto
plotto('trace.dat')
