"""
 * Copyright (C) 2004 Evan Thomas
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
"""

"""
Test throwing the ParplexRuntimeError exception
"""

import sys
from random import choice
from time import clock
from p3 import *

class Passive(PyDynamics):
    def __init__(self, cell, Gleak, Vleak):
        PyDynamics.__init__(self, cell)
        self.Gleak = Gleak
        self.Vleak = Vleak
        
    def current(self, t):
        Em = self.owner.Em
        return self.Gleak * (self.Vleak - Em)
        

def makecell():
    cell = Cell()
    cell.capacitance = 10
    cell.APthreshold = -50
    cell.Em = -60
    cell.emtrace = True

    # Leak
    Gleak = 0.5
    Eleak = -60
    Passive(cell, Gleak, Eleak)
    
    # fEPSP
    Gsyn = 30
    Esyn = 0
    cell.fepsp = fastEPSP(cell)
    cell.fepsp.Gmax = 30
    cell.fepsp.Er = 0
    cell.fepsp.k = -8000 # <<<=== unstable time constant
    cell.fepsp.enq(rand_norm(5,1), 1)
    
    return cell
    
    
def dumpcell(cell):
    """Diagnostic dump of a cell"""
    print 'Dumping %s:' % cell
    print cell.time
    for c in cell.compartments:
        print ': %s\n' % c
        for s in c.synapse:
            print '::  %s\n' % s
    for i in range(len(cell.Y)):
        print ':::   Y[%d]=%g DYDT[%d]=%g\n' % (i, cell.Y[i], i, cell.DYDT[i])
        
network = []
for i in range(1):
    network.append(makecell())
    
###############
# Run options #
###############
gd = GD()
gd.duration  = 100
gd.tolerance = 1e-4
gd.network = network

#######
# Run #
#######
start = clock()

try:
    parplex(gd)
except ParplexRuntimeError:
    e = sys.exc_info()[0]
    cell = e.currentCell
    dumpcell(cell)
    
    
set_message_option('info')
message_print(info, 'made it - elapsed time %ds' % int(clock()-start))
