"""
 * Copyright (C) 2004 Evan Thomas
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
"""

"""
Test the Hines integration method using the Antal/Emri TC model.
"""

import sys
sys.path = ['C:\Documents and Settings\evan\My Documents\Visual Studio Projects\parplex']+sys.path

from random import shuffle
from p3 import *

set_message_option('info')
duration = 200


def makeCmpt(cell, n, a):
    cmpts = []
    for i in range(n):
        cmpts.append(Compartment(cell))
        cmpts[i].capacitance = 1;
        if i>0:
            cmpts[i].connect(cmpts[i-1], a)
    return cmpts
    
def makecell():
    cell = mCell()
    cell.method = hines
    
    compartments1 = makeCmpt(cell, 3, 2)
    compartments2 = makeCmpt(cell, 3, 3)
    compartments3 = makeCmpt(cell, 3, 4)
    compartments4 = makeCmpt(cell, 3, 5)
    compartments5 = makeCmpt(cell, 3, 6)
    compartments6 = makeCmpt(cell, 3, 7)

    compartments1[-1].connect(compartments2[-1], 8)
    compartments3[ 0].connect(compartments2[-1], 9)
    compartments3[-1].connect(compartments4[-1], 10)
    compartments3[-1].connect(compartments5[-1], 11)
    compartments3[-1].connect(compartments6[ 0], 12)

    return cell


cell = makecell()
message_print(info, 'Cell with %d compartments and %d state variables.\n' % \
              (len(cell.compartments), len(cell.Y)))

###############
# Run options #
###############
gd = GD()
gd.duration  = duration
gd.tolerance = 1
gd.network = [cell]
gd.ap_handler = None
gd.trace_handler = None
gd.endWindow_handler = None
gd.stepTrace_handler = None

#######
# Run #
#######
try:
    parplex(gd)
except ParplexRuntimeError:
    (e, v) = sys.exc_info()[:2]
    cell = e.currentCell
    message_print(fatal, 'Caught ParplexRuntimeError: %s\n' % v)
    sys.exit(0)

