COMMENT

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//
// NOTICE OF COPYRIGHT AND OWNERSHIP OF SOFTWARE
//
// Copyright 2007, The University Of Pennsylvania
// 	School of Engineering & Applied Science.
//   All rights reserved.
//   For research use only; commercial use prohibited.
//   Distribution without permission of Maciej T. Lazarewicz not permitted.
//   mlazarew@seas.upenn.edu
//
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

ENDCOMMENT

NEURON {
	SUFFIX Caolmw
	USEION ca READ ica, cai WRITE cai
	RANGE alpha, tau
}
	
UNITS {	
    (mollar) = (1/liter)
	(M)      = (mollar)
	(mM)     = (millimollar)
	(mA)     = (milliamp)
	(mV)     = (millivolt)
	(mS)     = (millisiemens)
}

PARAMETER {
    alpha = 0.002 (cm2-M/mA-ms)
    tau   = 80    (ms)
}
    
ASSIGNED { ica (mA/cm2) }

INITIAL { cai = 0 }

STATE { cai (mM) }

BREAKPOINT { SOLVE states METHOD cnexp }

DERIVATIVE states { cai' = -(1000) * alpha * ica - cai/tau }
