/*
 * Decompiled with CFR 0.152.
 */
package com.bptripp.diff;

import ca.nengo.dynamics.DynamicalSystem;
import ca.nengo.dynamics.Integrator;
import ca.nengo.dynamics.impl.EulerIntegrator;
import ca.nengo.dynamics.impl.LTISystem;
import ca.nengo.io.MatlabExporter;
import ca.nengo.math.Function;
import ca.nengo.math.PDF;
import ca.nengo.math.impl.GaussianPDF;
import ca.nengo.math.impl.IndicatorPDF;
import ca.nengo.math.impl.SineFunction;
import ca.nengo.model.Ensemble;
import ca.nengo.model.Node;
import ca.nengo.model.Noise;
import ca.nengo.model.Projection;
import ca.nengo.model.SimulationException;
import ca.nengo.model.StructuralException;
import ca.nengo.model.Units;
import ca.nengo.model.impl.FunctionInput;
import ca.nengo.model.impl.NetworkImpl;
import ca.nengo.model.impl.NodeFactory;
import ca.nengo.model.impl.NoiseFactory;
import ca.nengo.model.nef.NEFEnsemble;
import ca.nengo.model.nef.NEFEnsembleFactory;
import ca.nengo.model.nef.impl.NEFEnsembleFactoryImpl;
import ca.nengo.model.neuron.impl.LIFNeuronFactory;
import ca.nengo.util.MU;
import ca.nengo.util.Probe;
import ca.nengo.util.TimeSeries;
import java.io.File;
import java.io.IOException;

public abstract class DifferentiatorNetwork
extends NetworkImpl {
    private static final long serialVersionUID = 1L;
    public static final float TAU_IO = 0.005f;
    public static float TAU_INTERNEURONS = 0.001f;
    private FunctionInput myInput;
    private NEFEnsemble myInputEnsemble;
    private NEFEnsemble myOutputEnsemble;
    private int myNInput = 2000;
    private int myNOutput = 1000;
    protected transient NEFEnsembleFactory myEnsembleFactory = new NEFEnsembleFactoryImpl();
    private Probe myInputProbe;
    private Probe myOutputProbe;
    private Probe myInputEnsembleProbe;

    public DifferentiatorNetwork() throws StructuralException {
        this.myInput = new FunctionInput("external", new Function[]{new SineFunction((float)Math.PI, 0.31830987f)}, Units.UNK);
        this.addNode((Node)this.myInput);
        this.myInputEnsemble = this.myEnsembleFactory.make("input", this.myNInput, 1, "diff_input_" + this.myNInput, false);
        this.addNode((Node)this.myInputEnsemble);
        NEFEnsembleFactoryImpl of = new NEFEnsembleFactoryImpl();
        of.setNodeFactory((NodeFactory)new LIFNeuronFactory(0.02f, 1.0E-4f, (PDF)new IndicatorPDF(200.0f, 400.0f), (PDF)new IndicatorPDF(-0.9f, 0.9f)));
        this.myOutputEnsemble = of.make("output", this.myNOutput, 1, "diff_output_" + this.myNOutput, false);
        this.addNode((Node)this.myOutputEnsemble);
        try {
            this.myInputProbe = this.getSimulator().addProbe(this.myInput.getName(), "input", true);
            this.myInputEnsembleProbe = this.getSimulator().addProbe(this.myInputEnsemble.getName(), "X", true);
            this.myOutputProbe = this.getSimulator().addProbe(this.myOutputEnsemble.getName(), "X", true);
        }
        catch (SimulationException e) {
            throw new StructuralException((Throwable)e);
        }
    }

    public void reset(boolean randomize) {
        super.reset(randomize);
        Probe[] probeArray = this.getSimulator().getProbes();
        int n = probeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Probe p = probeArray[n2];
            p.reset();
            ++n2;
        }
    }

    protected FunctionInput getInput() {
        return this.myInput;
    }

    protected NEFEnsemble getInputEnsemble() {
        return this.myInputEnsemble;
    }

    protected NEFEnsemble getOutputEnsemble() {
        return this.myOutputEnsemble;
    }

    public TimeSeries getInputData() {
        return this.myInputProbe.getData();
    }

    public TimeSeries getInputEnsembleData() {
        return this.myInputEnsembleProbe.getData();
    }

    public TimeSeries getOutputData() {
        return this.myOutputProbe.getData();
    }

    public void setInputFunction(Function input) throws StructuralException {
        this.myInput.setFunctions(new Function[]{input});
    }

    public abstract void setTau(float var1);

    public abstract void setNoise(int var1, int var2);

    public abstract void setDistortion(int var1, int var2);

    public abstract void clearErrors();

    public abstract void enableParisien(float var1) throws StructuralException;

    public abstract void disableParisien();

    protected static void enableParisien(Projection p, int n) throws StructuralException {
        p.addBias(n, TAU_INTERNEURONS, p.getTermination().getTau(), true, true);
    }

    protected static void enableParisien(Projection p, int n, boolean optimize) throws StructuralException {
        p.addBias(n, TAU_INTERNEURONS, p.getTermination().getTau(), true, optimize);
    }

    public void exportAll(File destination) throws IOException {
        MatlabExporter exporter = new MatlabExporter();
        Probe[] probes = this.getSimulator().getProbes();
        int i = 0;
        while (i < probes.length) {
            TimeSeries data = probes[i].getData();
            exporter.add(data.getName().replace(':', '_'), data);
            ++i;
        }
        Node[] nodes = this.getNodes();
        int i2 = 0;
        while (i2 < nodes.length) {
            if (nodes[i2] instanceof Ensemble && ((Ensemble)nodes[i2]).isCollectingSpikes()) {
                exporter.add(nodes[i2].getName(), ((Ensemble)nodes[i2]).getSpikePattern());
            }
            ++i2;
        }
        exporter.write(destination);
    }

    protected static Noise makeNoise(int n) {
        return DifferentiatorNetwork.makeNoise(1.0f / (float)n, 1000.0f, true);
    }

    protected static Noise makeDistortion(int n) {
        return DifferentiatorNetwork.makeNoise(1.0f / (float)(n * n), 400.0f, true);
    }

    protected static Noise makeNoise(float variance, float frequency, boolean filter) {
        DynamicalSystem noiseFilter = null;
        if (filter) {
            noiseFilter = DifferentiatorNetwork.getNoiseFilter(frequency / 2.0f);
        }
        EulerIntegrator integrator = new EulerIntegrator(5.0E-4f);
        return NoiseFactory.makeRandomNoise((float)frequency, (PDF)new GaussianPDF(0.0f, variance), (DynamicalSystem)noiseFilter, (Integrator)integrator);
    }

    private static DynamicalSystem getNoiseFilter(float frequency) {
        float w = (float)Math.PI * 2 * frequency;
        float[][] A = new float[][]{{0.0f, 1.0f}, {-w * w, -((float)Math.sqrt(2.0)) * w}};
        float[][] B = new float[][]{{0.0f}, {w * w}};
        float[][] C = new float[][]{{1.0f, 0.0f}};
        LTISystem result = new LTISystem((float[][])A, (float[][])B, (float[][])C, MU.zero((int)1, (int)1), new float[]{0.0f, 0.0f}, new Units[]{Units.UNK});
        return result;
    }
}

