/*
 * Decompiled with CFR 0.152.
 */
package com.bptripp.diff;

import ca.nengo.model.Node;
import ca.nengo.model.Noise;
import ca.nengo.model.Projection;
import ca.nengo.model.StructuralException;
import ca.nengo.model.impl.NoiseFactory;
import ca.nengo.model.nef.NEFEnsemble;
import ca.nengo.model.nef.impl.DecodedTermination;
import ca.nengo.util.MU;
import com.bptripp.diff.DifferentiatorNetwork;

public class DualTCNetwork
extends DifferentiatorNetwork {
    private static final long serialVersionUID = 1L;
    private static final String DIRECT = "direct";
    private static final String DELAYED = "delayed";
    private Projection myDirectProjection;
    private Projection myDelayedProjection;

    public DualTCNetwork(float tauPSC, float slowTauPSC, boolean correlatedError) throws StructuralException {
        this.setName("dualTC");
        float tauDifference = slowTauPSC - tauPSC;
        this.getInputEnsemble().addDecodedTermination("input", MU.I((int)1), 0.005f, false);
        this.addProjection(this.getInput().getOrigin("origin"), this.getInputEnsemble().getTermination("input"));
        NEFEnsemble output = this.getOutputEnsemble();
        output.addDecodedTermination(DIRECT, (float[][])new float[][]{{1.0f / tauDifference}}, tauPSC, false);
        output.addDecodedTermination(DELAYED, (float[][])new float[][]{{-1.0f / tauDifference}}, slowTauPSC, false);
        this.myDirectProjection = this.addProjection(this.getInputEnsemble().getOrigin("X"), output.getTermination(DIRECT));
        if (correlatedError) {
            this.myDelayedProjection = this.addProjection(this.getInputEnsemble().getOrigin("X"), output.getTermination(DELAYED));
        } else {
            int n = this.getInputEnsemble().getNodes().length;
            NEFEnsemble uncorrelated = this.myEnsembleFactory.make("input2", n, 1, "diff_input2_" + n, false);
            uncorrelated.addDecodedTermination("input", MU.I((int)1), 0.005f, false);
            this.addNode((Node)uncorrelated);
            this.addProjection(this.getInput().getOrigin("origin"), uncorrelated.getTermination("input"));
            this.myDelayedProjection = this.addProjection(uncorrelated.getOrigin("X"), output.getTermination(DELAYED));
        }
    }

    @Override
    public void clearErrors() {
        ((Noise.Noisy)this.myDirectProjection.getOrigin()).setNoise((Noise)new NoiseFactory.NoiseImplNull());
        ((Noise.Noisy)this.myDelayedProjection.getOrigin()).setNoise((Noise)new NoiseFactory.NoiseImplNull());
    }

    @Override
    public void setDistortion(int nInput, int nDiff) {
        ((Noise.Noisy)this.myDirectProjection.getOrigin()).setNoise(DualTCNetwork.makeDistortion(nInput));
        ((Noise.Noisy)this.myDelayedProjection.getOrigin()).setNoise(DualTCNetwork.makeDistortion(nInput));
    }

    @Override
    public void setNoise(int nInput, int nDiff) {
        ((Noise.Noisy)this.myDirectProjection.getOrigin()).setNoise(DualTCNetwork.makeNoise(nInput));
        ((Noise.Noisy)this.myDelayedProjection.getOrigin()).setNoise(DualTCNetwork.makeNoise(nInput));
    }

    @Override
    public void setTau(float tau) {
        try {
            this.getOutputEnsemble().getTermination(DELAYED).setTau(tau);
            float tauDifference = tau - this.getOutputEnsemble().getTermination(DIRECT).getTau();
            ((DecodedTermination)this.getOutputEnsemble().getTermination(DIRECT)).setTransform((float[][])new float[][]{{1.0f / tauDifference}});
            ((DecodedTermination)this.getOutputEnsemble().getTermination(DELAYED)).setTransform((float[][])new float[][]{{-1.0f / tauDifference}});
        }
        catch (StructuralException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void disableParisien() {
        this.myDirectProjection.removeBias();
        this.myDelayedProjection.removeBias();
    }

    @Override
    public void enableParisien(float propInhibitory) throws StructuralException {
        int n = Math.round(propInhibitory * (float)this.getOutputEnsemble().getNodes().length);
        DualTCNetwork.enableParisien(this.myDirectProjection, n);
        DualTCNetwork.enableParisien(this.myDelayedProjection, n);
    }

    public static void main(String[] args) throws StructuralException {
        new DualTCNetwork(0.005f, 0.1f, false);
    }
}

