/*
 * Decompiled with CFR 0.152.
 */
package com.bptripp.diff;

import ca.nengo.model.Node;
import ca.nengo.model.Noise;
import ca.nengo.model.Projection;
import ca.nengo.model.StructuralException;
import ca.nengo.model.impl.NoiseFactory;
import ca.nengo.model.nef.NEFEnsemble;
import ca.nengo.model.nef.impl.DecodedTermination;
import ca.nengo.util.MU;
import com.bptripp.diff.DifferentiatorNetwork;

public class InterneuronNetwork
extends DifferentiatorNetwork {
    private static final long serialVersionUID = 1L;
    private NEFEnsemble myInterneurons;
    private Projection myInputOutputProjection;
    private Projection myInputInterneuronProjection;
    private Projection myInterneuronOutputProjection;

    public InterneuronNetwork(float tauPSC, int numInterneurons) throws StructuralException {
        this.setName("interneuron");
        this.getInputEnsemble().addDecodedTermination("input", MU.I((int)1), 0.005f, false);
        this.addProjection(this.getInput().getOrigin("origin"), this.getInputEnsemble().getTermination("input"));
        this.myInterneurons = this.myEnsembleFactory.make("interneurons", numInterneurons, 1, "diff_inter_" + numInterneurons, false);
        this.myInterneurons.addDecodedTermination("input", MU.I((int)1), tauPSC, false);
        this.myInputInterneuronProjection = this.addProjection(this.getInputEnsemble().getOrigin("X"), this.myInterneurons.getTermination("input"));
        this.addNode((Node)this.myInterneurons);
        this.getOutputEnsemble().addDecodedTermination("direct", (float[][])new float[][]{{1.0f / tauPSC}}, tauPSC, false);
        this.getOutputEnsemble().addDecodedTermination("indirect", (float[][])new float[][]{{-1.0f / tauPSC}}, tauPSC, false);
        this.myInputOutputProjection = this.addProjection(this.getInputEnsemble().getOrigin("X"), this.getOutputEnsemble().getTermination("direct"));
        this.myInterneuronOutputProjection = this.addProjection(this.myInterneurons.getOrigin("X"), this.getOutputEnsemble().getTermination("indirect"));
    }

    @Override
    public void disableParisien() {
        this.myInputOutputProjection.removeBias();
        this.myInputInterneuronProjection.removeBias();
        this.myInterneuronOutputProjection.removeBias();
    }

    @Override
    public void enableParisien(float propInhibitory) throws StructuralException {
        int nOutput = Math.round(propInhibitory * (float)this.getOutputEnsemble().getNodes().length);
        int nInterneurons = Math.round(propInhibitory * (float)this.myInterneurons.getNodes().length);
        InterneuronNetwork.enableParisien(this.myInputOutputProjection, nOutput);
        InterneuronNetwork.enableParisien(this.myInputInterneuronProjection, nInterneurons);
        InterneuronNetwork.enableParisien(this.myInterneuronOutputProjection, nOutput);
    }

    @Override
    public void clearErrors() {
        try {
            ((Noise.Noisy)this.getInputEnsemble().getOrigin("X")).setNoise((Noise)new NoiseFactory.NoiseImplNull());
            ((Noise.Noisy)this.myInterneurons.getOrigin("X")).setNoise((Noise)new NoiseFactory.NoiseImplNull());
        }
        catch (StructuralException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setDistortion(int nInput, int nDiff) {
        try {
            ((Noise.Noisy)this.getInputEnsemble().getOrigin("X")).setNoise(InterneuronNetwork.makeDistortion(nInput));
            ((Noise.Noisy)this.myInterneurons.getOrigin("X")).setNoise(InterneuronNetwork.makeDistortion(nDiff));
        }
        catch (StructuralException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setNoise(int nInput, int nDiff) {
        try {
            ((Noise.Noisy)this.getInputEnsemble().getOrigin("X")).setNoise(InterneuronNetwork.makeNoise(nInput));
            ((Noise.Noisy)this.myInterneurons.getOrigin("X")).setNoise(InterneuronNetwork.makeNoise(nDiff));
        }
        catch (StructuralException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setTau(float tau) {
        try {
            this.myInterneurons.getTermination("input").setTau(tau);
            DecodedTermination direct = (DecodedTermination)this.getOutputEnsemble().getTermination("direct");
            direct.setTau(tau);
            direct.setTransform((float[][])new float[][]{{1.0f / tau}});
            DecodedTermination indirect = (DecodedTermination)this.getOutputEnsemble().getTermination("indirect");
            indirect.setTau(tau);
            indirect.setTransform((float[][])new float[][]{{-1.0f / tau}});
        }
        catch (StructuralException e) {
            throw new RuntimeException(e);
        }
    }
}

