/*
 * Decompiled with CFR 0.152.
 */
package com.bptripp.diff;

import ca.nengo.dynamics.DynamicalSystem;
import ca.nengo.math.Function;
import ca.nengo.math.PDF;
import ca.nengo.math.impl.IndicatorPDF;
import ca.nengo.model.Node;
import ca.nengo.model.Noise;
import ca.nengo.model.Projection;
import ca.nengo.model.RealOutput;
import ca.nengo.model.SimulationException;
import ca.nengo.model.SimulationMode;
import ca.nengo.model.StructuralException;
import ca.nengo.model.impl.NodeFactory;
import ca.nengo.model.impl.NoiseFactory;
import ca.nengo.model.nef.NEFEnsemble;
import ca.nengo.model.nef.NEFEnsembleFactory;
import ca.nengo.model.nef.impl.BiasOrigin;
import ca.nengo.model.nef.impl.DecodedOrigin;
import ca.nengo.model.nef.impl.DecodedTermination;
import ca.nengo.model.nef.impl.NEFEnsembleFactoryImpl;
import ca.nengo.model.neuron.impl.LIFNeuronFactory;
import ca.nengo.model.neuron.impl.SpikingNeuron;
import ca.nengo.util.MU;
import ca.nengo.util.Probe;
import ca.nengo.util.TimeSeries;
import com.bptripp.diff.DifferentiatorNetwork;
import com.bptripp.diff.SynapticDepressionDynamics;
import com.bptripp.diff.Util;

public class DepressionNetwork
extends DifferentiatorNetwork {
    private static final long serialVersionUID = 1L;
    private static final String DEPRESSING = "depressing";
    private static final String COMPENSATING = "compensating";
    private NEFEnsemble myDepressingEnsemble;
    private Probe myInputProbe;
    private Projection myDepressingProjection;
    private Projection myCompensatingProjection;

    public DepressionNetwork(int n) throws StructuralException {
        this.setName("depression");
        this.removeNode(super.getInputEnsemble().getName());
        Probe[] probeArray = this.getSimulator().getProbes();
        int n2 = probeArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Probe probe = probeArray[n3];
            if (probe.getTarget().equals(super.getInputEnsemble())) {
                try {
                    this.getSimulator().removeProbe(probe);
                }
                catch (SimulationException e) {
                    throw new RuntimeException(e);
                }
            }
            ++n3;
        }
        String name = super.getInputEnsemble().getName();
        this.myDepressingEnsemble = DepressionNetwork.getLinearFactory().make(name, n, 1, "depression_input_" + n, true);
        this.myDepressingEnsemble.addDecodedTermination("input", MU.I((int)1), 0.005f, false);
        this.addNode((Node)this.myDepressingEnsemble);
        try {
            this.myInputProbe = this.getSimulator().addProbe(this.myDepressingEnsemble.getName(), "X", true);
        }
        catch (SimulationException e) {
            throw new RuntimeException(e);
        }
        this.addProjection(this.getInput().getOrigin("origin"), this.getInputEnsemble().getTermination("input"));
        int maxPoolSize = 100;
        float tauRecovery = 0.5f;
        float proportionReleased = 0.01f;
        SynapticDepressionDynamics depressionDynamics = new SynapticDepressionDynamics(maxPoolSize, tauRecovery, proportionReleased);
        ((DecodedOrigin)this.myDepressingEnsemble.getOrigin("X")).setSTPDynamics((DynamicalSystem)depressionDynamics);
        NEFEnsemble output = this.getOutputEnsemble();
        float scale = 1.0f;
        output.addDecodedTermination(DEPRESSING, (float[][])new float[][]{{scale}}, 0.005f, false);
        output.addDecodedTermination(COMPENSATING, (float[][])new float[][]{{scale}}, 0.005f, false);
        this.setCompensation(0.1f);
        this.addProjections();
    }

    private static NEFEnsembleFactory getLinearFactory() {
        NEFEnsembleFactoryImpl result = new NEFEnsembleFactoryImpl();
        result.setNodeFactory((NodeFactory)new LIFNeuronFactory(0.02f, 5.0E-4f, (PDF)new IndicatorPDF(200.0f, 400.0f), (PDF)new IndicatorPDF(-2.5f, -1.5f)));
        return result;
    }

    private void removeProjections() throws StructuralException {
        this.removeProjection(this.getInputEnsemble().getTermination("input"));
        this.removeProjection(this.getOutputEnsemble().getTermination(DEPRESSING));
        this.removeProjection(this.getOutputEnsemble().getTermination(COMPENSATING));
    }

    private void addProjections() throws StructuralException {
        this.addProjection(this.getInput().getOrigin("origin"), this.getInputEnsemble().getTermination("input"));
        this.myDepressingProjection = this.addProjection(this.myDepressingEnsemble.getOrigin("X"), this.getOutputEnsemble().getTermination(DEPRESSING));
        this.myCompensatingProjection = this.addProjection(this.myDepressingEnsemble.getOrigin(COMPENSATING), this.getOutputEnsemble().getTermination(COMPENSATING));
    }

    @Override
    public void disableParisien() {
        this.myCompensatingProjection.removeBias();
        this.myDepressingProjection.removeBias();
    }

    @Override
    public void enableParisien(float propInhibitory) throws StructuralException {
        int n = Math.round(propInhibitory * (float)this.getOutputEnsemble().getNodes().length);
        DepressionNetwork.enableParisien(this.myCompensatingProjection, n);
        DepressionNetwork.enableParisien(this.myDepressingProjection, n, false);
        DecodedOrigin o = (DecodedOrigin)this.myDepressingEnsemble.getOrigin("X");
        BiasOrigin bo = (BiasOrigin)this.myDepressingEnsemble.getOrigin("output:depressing");
        bo.setSTPDynamics(o.getSTPDynamics());
        int i = 0;
        while (i < bo.getDecoders().length) {
            ((SynapticDepressionDynamics)bo.getSTPDynamics(i)).setTau(((SynapticDepressionDynamics)o.getSTPDynamics(i)).getTau());
            ((SynapticDepressionDynamics)bo.getSTPDynamics(i)).setProportionReleased(((SynapticDepressionDynamics)o.getSTPDynamics(i)).getProportionReleased());
            ++i;
        }
    }

    @Override
    protected NEFEnsemble getInputEnsemble() {
        return this.myDepressingEnsemble;
    }

    @Override
    public TimeSeries getInputEnsembleData() {
        return this.myInputProbe.getData();
    }

    @Override
    public void setTau(float tau) {
        Node[] neurons = this.myDepressingEnsemble.getNodes();
        try {
            DecodedOrigin o = (DecodedOrigin)this.myDepressingEnsemble.getOrigin("X");
            int i = 0;
            while (i < neurons.length) {
                SpikingNeuron neuron = (SpikingNeuron)neurons[i];
                float r0 = DepressionNetwork.getNominalRate(neuron);
                float F = 1.0f / (2.0f * tau * r0);
                float tauS = 2.0f * tau;
                SynapticDepressionDynamics d = (SynapticDepressionDynamics)o.getSTPDynamics(i);
                d.setTau(tauS);
                d.setProportionReleased(F);
                System.out.println("tauS: " + tauS + " F:" + F);
                ++i;
            }
        }
        catch (StructuralException e) {
            throw new RuntimeException(e);
        }
        try {
            this.removeProjections();
            this.setCompensation(tau);
            this.addProjections();
            float[][] scale = new float[][]{{4.4f / tau}};
            ((DecodedTermination)this.getOutputEnsemble().getTermination(DEPRESSING)).setTransform((float[][])scale);
            ((DecodedTermination)this.getOutputEnsemble().getTermination(COMPENSATING)).setTransform((float[][])scale);
        }
        catch (StructuralException e) {
            throw new RuntimeException(e);
        }
    }

    private void setCompensation(float tau) throws StructuralException {
        try {
            this.myDepressingEnsemble.removeDecodedTermination("input");
            Function f = Util.getBiasCompensation(this.myDepressingEnsemble, "X", tau * 8.0f);
            this.myDepressingEnsemble.addDecodedTermination("input", MU.I((int)1), 0.005f, false);
            this.myDepressingEnsemble.addDecodedOrigin(COMPENSATING, new Function[]{f}, "AXON");
        }
        catch (SimulationException e) {
            throw new StructuralException((Throwable)e);
        }
    }

    private static float getNominalRate(SpikingNeuron neuron) {
        SimulationMode mode = neuron.getMode();
        float rate = 0.0f;
        try {
            neuron.setMode(SimulationMode.CONSTANT_RATE);
            neuron.setRadialInput(0.0f);
            neuron.run(0.0f, 0.0f);
            rate = ((RealOutput)neuron.getOrigin("AXON").getValues()).getValues()[0];
            neuron.setMode(mode);
        }
        catch (SimulationException e) {
            throw new RuntimeException(e);
        }
        catch (StructuralException e) {
            throw new RuntimeException(e);
        }
        return rate;
    }

    @Override
    public void clearErrors() {
        try {
            ((Noise.Noisy)this.myDepressingEnsemble.getOrigin("X")).setNoise((Noise)new NoiseFactory.NoiseImplNull());
            ((Noise.Noisy)this.myDepressingEnsemble.getOrigin(COMPENSATING)).setNoise((Noise)new NoiseFactory.NoiseImplNull());
        }
        catch (StructuralException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setDistortion(int nInput, int nDiff) {
        try {
            ((Noise.Noisy)this.myDepressingEnsemble.getOrigin("X")).setNoise(DepressionNetwork.makeDistortion(nInput));
            ((Noise.Noisy)this.myDepressingEnsemble.getOrigin(COMPENSATING)).setNoise(DepressionNetwork.makeDistortion(nInput));
        }
        catch (StructuralException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setNoise(int nInput, int nDiff) {
        try {
            ((Noise.Noisy)this.myDepressingEnsemble.getOrigin("X")).setNoise(DepressionNetwork.makeNoise(nInput));
            ((Noise.Noisy)this.myDepressingEnsemble.getOrigin(COMPENSATING)).setNoise(DepressionNetwork.makeNoise(nInput));
        }
        catch (StructuralException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        try {
            DepressionNetwork n = new DepressionNetwork(500);
            n.setTau(0.5f);
        }
        catch (StructuralException e) {
            e.printStackTrace();
        }
    }
}

