/*
 * Decompiled with CFR 0.152.
 */
package com.bptripp.diff;

import ca.nengo.dynamics.DynamicalSystem;
import ca.nengo.dynamics.impl.AbstractDynamicalSystem;
import ca.nengo.dynamics.impl.EulerIntegrator;
import ca.nengo.math.impl.PostfixFunction;
import ca.nengo.model.Units;
import ca.nengo.plot.Plotter;
import ca.nengo.util.MU;
import ca.nengo.util.TimeSeries;
import ca.nengo.util.impl.TimeSeries1DImpl;

public class SynapticDepressionDynamics
extends AbstractDynamicalSystem {
    private static final long serialVersionUID = 1L;
    private int myMaxPoolSize;
    private float myTau;
    private float myProportionReleased;

    public SynapticDepressionDynamics(int maxPoolSize, float tau, float proportionReleased) {
        super(new float[1]);
        this.myMaxPoolSize = maxPoolSize;
        this.myTau = tau;
        this.myProportionReleased = proportionReleased;
    }

    public float[] f(float t, float[] u) {
        float S = this.getState()[0];
        return new float[]{(1.0f - S) / this.myTau - this.myProportionReleased * S * u[0]};
    }

    public float[] g(float t, float[] u) {
        return new float[]{(float)Math.round((float)this.myMaxPoolSize * this.getState()[0]) / (float)this.myMaxPoolSize};
    }

    public int getInputDimension() {
        return 1;
    }

    public int getOutputDimension() {
        return 1;
    }

    public float getTau() {
        return this.myTau;
    }

    public void setTau(float tau) {
        this.myTau = tau;
    }

    public float getProportionReleased() {
        return this.myProportionReleased;
    }

    public void setProportionReleased(float proportion) {
        this.myProportionReleased = proportion;
    }

    public static void main(String[] args) {
        SynapticDepressionDynamics dynamics = new SynapticDepressionDynamics(100, 0.5f, 0.01f);
        EulerIntegrator integrator = new EulerIntegrator(0.001f);
        float[] times = MU.makeVector((float)0.0f, (float)0.001f, (float)5.0f);
        PostfixFunction f = new PostfixFunction("200 + 100*sin(2*pi*x0)", 1);
        float[] values = f.multiMap(MU.transpose((float[][])new float[][]{times}));
        TimeSeries1DImpl input = new TimeSeries1DImpl(times, values, Units.UNK);
        TimeSeries output = integrator.integrate((DynamicalSystem)dynamics, (TimeSeries)input);
        Plotter.plot((TimeSeries)input, (String)"input");
        Plotter.plot((TimeSeries)output, (String)"output");
        Plotter.plot((float[])MU.prodElementwise((float[])values, (float[])MU.transpose((float[][])output.getValues())[0]), (String)"product");
    }
}

