function out = RunSimulation(SIMPARAMS)
% set the path to the simulation files
addpath(pwd, [pwd '/Simulation']);

% these are currently redundent parameters that may be required again when
% I put the cortical pulse code back into the simulation 
SIMPARAMS.CTX_state = [1 1 0 0 0 0 0 0];
SIMPARAMS.initCTX = rand(2);

% check the parameter types before calling the c++ funciton
checkStriatumInputs(SIMPARAMS);

% Run the simulation - using original version: as per NN model 
% Run the simulation - using version striatum_RK2_B: no scaling of synaptic input by 1/ts
[out.t, out.Vms, out.Vfs, out.STms, out.STfs, out.VMS, out.UMS, out.VFS, out.UFS, out.VFSGAP, out.MSGLU_AMPA, out.MSGLU_NMDA, out.MSGABA, out.MSSEQ, out.FSGLU, out.FSGABA, out.FSSEQ, out.RecordChan_MS] = ...
    striatum_RK2(SIMPARAMS.sim.tstart,SIMPARAMS.sim.tfinal,...
    SIMPARAMS.sim.dt, ...
    SIMPARAMS.physiology.MSparams,SIMPARAMS.physiology.FSparams,...
    SIMPARAMS.physiology.Eglu, SIMPARAMS.physiology.Egaba, SIMPARAMS.physiology.ts_glu_AMPA, SIMPARAMS.physiology.ts_glu_NMDA, SIMPARAMS.physiology.ts_gaba, SIMPARAMS.physiology.tau_fsgap, ...
    SIMPARAMS.sim.MSspikebuffer, SIMPARAMS.sim.FSspikebuffer, ...
    SIMPARAMS.sim.initVms,SIMPARAMS.sim.initUms,...
    SIMPARAMS.sim.initVfs,SIMPARAMS.sim.initUfs,SIMPARAMS.sim.initVgapfs,...    
    SIMPARAMS.sim.SpikeEventQue_MS,SIMPARAMS.sim.SpikeEventQue_FS, ...
    SIMPARAMS.sim.SpikeEventQue_MS,SIMPARAMS.sim.SpikeEventQue_FS, ...
    SIMPARAMS.initCTX, ...
    SIMPARAMS.sim.Iinj_MS,SIMPARAMS.sim.Iinj_FS,...
    SIMPARAMS.net.Cctms, SIMPARAMS.net.Cctms_b, SIMPARAMS.net.Cctms_d, SIMPARAMS.net.Cctms_w, ...
    SIMPARAMS.net.Cmsms, SIMPARAMS.net.Cmsms_b, SIMPARAMS.net.Cmsms_d, SIMPARAMS.net.Cmsms_w, ...
    SIMPARAMS.net.Cfsms, SIMPARAMS.net.Cfsms_b, SIMPARAMS.net.Cfsms_d, SIMPARAMS.net.Cfsms_w, ...
    SIMPARAMS.net.Cctfs, SIMPARAMS.net.Cctfs_b, SIMPARAMS.net.Cctfs_d, SIMPARAMS.net.Cctfs_w,  ...
    SIMPARAMS.net.Cfsfs, SIMPARAMS.net.Cfsfs_b, SIMPARAMS.net.Cfsfs_d, SIMPARAMS.net.Cfsfs_w, ...
    SIMPARAMS.net.Cgapfs, SIMPARAMS.net.Cgapfs_b, SIMPARAMS.net.Cgapfs_w, SIMPARAMS.net.Pgapfs, ...
    SIMPARAMS.CTX_state, ...
    SIMPARAMS.net.CHAN1_MS, SIMPARAMS.net.CHAN1_FS, SIMPARAMS.net.CHAN2_MS, SIMPARAMS.net.CHAN2_FS, ...
    SIMPARAMS.input.CTX.N_MSSEG, SIMPARAMS.input.CTX.r_MSSEG, SIMPARAMS.input.CTX.alpha_MSSEG, ...
    SIMPARAMS.input.CTX.N_FSSEG, SIMPARAMS.input.CTX.r_FSSEG, SIMPARAMS.input.CTX.alpha_FSSEG, ...
    SIMPARAMS.physiology.glu_ratio, SIMPARAMS.physiology.DA, ...
    SIMPARAMS.sim.RecordChan_MS, ...
    SIMPARAMS.input.PULSE.P, SIMPARAMS.input.PULSE.Nctx_ms, SIMPARAMS.input.PULSE.Nctx_fs, SIMPARAMS.input.PULSE.ts_spks, ...
    SIMPARAMS.input.Selection.Pt, SIMPARAMS.input.Selection.Pch, SIMPARAMS.input.Selection.Phz, ...
    SIMPARAMS.sim.RANDSEED, ...
    SIMPARAMS.sim.logfname);

% trim off the access numm entries
out.STms = out.STms(find(out.STms(:,2)>0), :);
out.STfs = out.STfs(find(out.STfs(:,2)>0), :);

