function mhconmatvalues20100928

%Based on Hooks B M, Hires S A, Zhang Y-X, Huber D, Petreanu L, Svoboda K,
%Shepherd G M G (2010 - submitted) "Laminar analysis of excitatory local 
%circuits in vibrissal motor and sensory cortical areas".
%
%Stores the values for connectivity matrices
%There are three cortical regions involved in vibrissal sensation and 
%movement (vM1, vS1, and S2) for which we computed connectivity
%matrices.  For each region there is a neuron-based and a layer-based
%connectivity matrix.
%
%Assigns the variables to the workspace
%Plots each connectivity matrix in a separate figure


connectivitymatrix.vM1.neuron=[NaN       NaN       NaN       NaN       NaN       NaN       NaN       NaN       NaN       NaN       NaN       NaN       NaN;
   -0.0304   -0.0934   -0.0308   -0.0387   -0.0279   -0.0042   -0.0077   -0.0042   -0.0039   -0.0028   -0.0060   -0.0034   -0.0121;
   -0.1727   -0.1112   -0.0970   -0.0416   -0.0326   -0.0103   -0.0073   -0.0055   -0.0054   -0.0013   -0.0020   -0.0031   -0.0031;
   -0.1981   -0.1989   -0.0937   -0.0477   -0.0352   -0.0181   -0.0115   -0.0061   -0.0094   -0.0037   -0.0021   -0.0031   -0.0123;
   -0.2879   -0.2171   -0.0961   -0.0433   -0.0307   -0.0244   -0.0250   -0.0142   -0.0206   -0.0031   -0.0044   -0.0043   -0.0047;
   -0.2666   -0.2893   -0.1143   -0.0481   -0.0507   -0.0407   -0.0569   -0.0381   -0.0258   -0.0059   -0.0030   -0.0046   -0.0034;
   -0.1527   -0.1608   -0.1037   -0.0530   -0.0747   -0.0679   -0.1015   -0.0742   -0.0559   -0.0074   -0.0080   -0.0031   -0.0020;
   -0.0705   -0.0586   -0.0443   -0.0358   -0.0403   -0.0567   -0.0705   -0.0564   -0.0642   -0.0257   -0.0114   -0.0056   -0.0054;
   -0.0889   -0.0416   -0.0219   -0.0218   -0.0235   -0.0255   -0.0334   -0.0382   -0.0447   -0.0248   -0.0301   -0.0186   -0.0173;
   -0.0080   -0.0131   -0.0155   -0.0140   -0.0204   -0.0175   -0.0210   -0.0316   -0.0359   -0.0223   -0.0193   -0.0115   -0.0054;
   -0.0039    0.0013   -0.0088   -0.0060   -0.0048   -0.0046   -0.0118   -0.0141   -0.0270   -0.0173   -0.0140   -0.0180   -0.0147;
    0.0002   -0.0030   -0.0003   -0.0043   -0.0018   -0.0036   -0.0040   -0.0087   -0.0226   -0.0230   -0.0152   -0.0168   -0.0164;
    0.0003   -0.0000   -0.0012   -0.0002   -0.0026   -0.0027   -0.0045   -0.0084   -0.0354   -0.0249   -0.0163   -0.0143   -0.0188;
   -0.0034   -0.0044   -0.0029    0.0013   -0.0020   -0.0017   -0.0054   -0.0049   -0.0171   -0.0148   -0.0122   -0.0117   -0.0138;];

connectivitymatrix.vM1.layer=1.0e+005*[-0.4861   -0.6708   -0.3636   -0.0331;
   -3.7225   -3.2168   -1.1721   -0.2561;
   -4.8596   -3.8855   -5.9974   -0.9269;
   -0.0685   -0.1716   -1.2409   -2.0142;];

connectivitymatrix.vS1.neuron=[NaN       NaN       NaN       NaN       NaN       NaN       NaN       NaN       NaN       NaN       NaN       NaN       NaN;
   -0.1270   -0.1306   -0.0827   -0.0422   -0.0318   -0.0490   -0.0446   -0.0319   -0.0063   -0.0028   -0.0011   -0.0016   -0.0009;
   -0.0566   -0.0702   -0.1222   -0.1200   -0.1202   -0.1591   -0.0764   -0.0307   -0.0218   -0.0089   -0.0026   -0.0023   -0.0042;
   -0.0676   -0.1042   -0.0891   -0.0884   -0.1184   -0.1304   -0.0431   -0.0389   -0.0213   -0.0051   -0.0020   -0.0033   -0.0024;
   -0.0051   -0.0311   -0.0174   -0.0435   -0.0226   -0.0505   -0.0131   -0.0120   -0.0075   -0.0061   -0.0018   -0.0025   -0.0012;
   -0.0083   -0.0146   -0.0232   -0.0170   -0.0197   -0.0143   -0.0142   -0.0187   -0.0179   -0.0078   -0.0048   -0.0020   -0.0015;
   -0.0196   -0.0220   -0.0159   -0.0164   -0.0134   -0.0270   -0.0165   -0.0159   -0.0106   -0.0046   -0.0053   -0.0046   -0.0013;
   -0.1436   -0.2153   -0.1286   -0.0467   -0.0276   -0.0451   -0.0385   -0.0454   -0.0180   -0.0107   -0.0112   -0.0107   -0.0058;
   -0.0308   -0.1210   -0.1165   -0.1472   -0.0629   -0.0469   -0.0428   -0.0376   -0.0241   -0.0118   -0.0105   -0.0067   -0.0035;
   -0.0212   -0.0488   -0.0714   -0.0498   -0.0442   -0.0384   -0.0281   -0.0271   -0.0351   -0.0197   -0.0203   -0.0143   -0.0123;
   -0.0051   -0.0040   -0.0086   -0.0203   -0.0116   -0.0125   -0.0168   -0.0226   -0.0154   -0.0138   -0.0212   -0.0155   -0.0133;
    0.0015   -0.0126    0.0011   -0.0057   -0.0087   -0.0332   -0.0149   -0.0160   -0.0211   -0.0193   -0.0133   -0.0255   -0.0122;
   -0.0036   -0.0081   -0.0096    0.0030    0.0015   -0.0011   -0.0078   -0.0162   -0.0052   -0.0092   -0.0094   -0.0250   -0.0149;
   -0.0030   -0.0033   -0.0035   -0.0030   -0.0038   -0.0015   -0.0022   -0.0042   -0.0033   -0.0019   -0.0035   -0.0078   -0.0152;];

connectivitymatrix.vS1.layer=1.0e+005*[-0.1803   -0.3532   -0.1350   -0.0794   -0.0701   -0.0154;
   -0.3444   -2.1938   -4.6320   -0.9099   -0.5106   -0.1237;
   -0.0436   -0.4269   -0.8707   -0.2070   -0.3143   -0.1608;
   -0.0468   -0.6434   -0.2865   -0.0959   -0.1290   -0.0904;
   -0.2455   -1.5502   -1.5988   -0.2029   -0.4798   -0.5012;
   -0.0296   -0.2624   -0.5109   -0.1061   -0.4726   -1.0880;];

connectivitymatrix.S2.neuron=[NaN       NaN       NaN       NaN       NaN       NaN       NaN       NaN       NaN       NaN       NaN       NaN       NaN;
   -0.0591   -0.1308   -0.1832   -0.0557   -0.0650   -0.0477   -0.0544   -0.0248   -0.0092   -0.0057   -0.0058   -0.0039   -0.0136;
   -0.1604   -0.1631   -0.1704   -0.1391   -0.1210   -0.0944   -0.0793   -0.0399   -0.0163   -0.0059   -0.0042   -0.0030   -0.0045;
   -0.0781   -0.1021   -0.1465   -0.1358   -0.1634   -0.1264   -0.1001   -0.0916   -0.0343   -0.0134   -0.0137   -0.0125   -0.0074;
   -0.1078   -0.1754   -0.2208   -0.1234   -0.2358   -0.1397   -0.1476   -0.1118   -0.0525   -0.0202   -0.0125   -0.0068   -0.0062;
   -0.0334   -0.0347   -0.0651   -0.0685   -0.0614   -0.0814   -0.0490   -0.0600   -0.0489   -0.0232   -0.0160   -0.0102   -0.0047;
   -0.1553   -0.1627   -0.0973   -0.0516   -0.0871   -0.1659   -0.1604   -0.0853   -0.0585   -0.0415   -0.0332   -0.0294   -0.0157;
   -0.1920   -0.3733   -0.2269   -0.1106   -0.0683   -0.1014   -0.2215   -0.1143   -0.0643   -0.0251   -0.0272   -0.0240   -0.0073;
   -0.0774   -0.3233   -0.4035   -0.1430   -0.0730   -0.0619   -0.1745   -0.1421   -0.0618   -0.0424   -0.0451   -0.0238   -0.0061;
   -0.0364   -0.1039   -0.1911   -0.0969   -0.0637   -0.0518   -0.1674   -0.1168   -0.0499   -0.0439   -0.0653   -0.0415   -0.0140;
   -0.0225   -0.1137   -0.0527   -0.0238   -0.0378   -0.0594   -0.0298   -0.0779   -0.0778   -0.0387   -0.0505   -0.0436   -0.0228;
   -0.0109   -0.0018   -0.0086   -0.0151   -0.0167   -0.0321   -0.0384   -0.0747   -0.1022   -0.0605   -0.0283   -0.0223   -0.0279;
   -0.0112   -0.0113   -0.0148   -0.0091   -0.0137   -0.0240   -0.0641   -0.0736   -0.0705   -0.0430   -0.0318   -0.0383   -0.0258;
   -0.0087   -0.0112   -0.0094   -0.0062   -0.0119   -0.0137   -0.0252   -0.0217   -0.0256   -0.0318   -0.0212   -0.0149   -0.0219;];

connectivitymatrix.S2.layer=1.0e+005*[-1.3149   -0.9112   -1.1729   -0.4420   -0.2175   -0.2535;
   -0.9569   -1.1056   -2.1124   -0.6964   -0.6252   -0.4760;
   -0.7033   -0.9021   -1.9951   -0.7609   -0.9807   -0.8880;
   -0.7991   -0.2735   -0.5836   -0.7011   -0.7227   -0.8317;
   -3.7910   -4.6571   -2.8148   -2.0091   -3.3479   -4.4772;
   -0.2924   -0.2949   -0.8099   -1.0271   -4.0796   -7.1397;];

figure, imagesc([0 1],[0 1],connectivitymatrix.vM1.neuron),colormap(flipud(jet(256))),colorbar,title('connectivitymatrix.vM1.neuron');
% daspect([1 1 1]);
hold on;
set(gca,'XTick',[0 0.5 1],'YTick',[0 0.5 1]);
xlabel('Presynaptic distance (normalized)');
ylabel('Postsynaptic distance (normalized)');
figure, imagesc([0 1],[0 1],connectivitymatrix.vM1.layer),colormap(flipud(jet(256))),colorbar,title('connectivitymatrix.vM1.layer');
% daspect([1 1 1]);
hold on;
set(gca,'XTick',[0 0.5 1],'YTick',[0 0.5 1]);
xlabel('Presynaptic distance (normalized)');
ylabel('Postsynaptic distance (normalized)');

figure, imagesc([0 1],[0 1],connectivitymatrix.vS1.neuron),colormap(flipud(jet(256))),colorbar,title('connectivitymatrix.vS1.neuron');
% daspect([1 1 1]);
hold on;
set(gca,'XTick',[0 0.5 1],'YTick',[0 0.5 1]);
xlabel('Presynaptic distance (normalized)');
ylabel('Postsynaptic distance (normalized)');
figure, imagesc([0 1],[0 1],connectivitymatrix.vS1.layer),colormap(flipud(jet(256))),colorbar,title('connectivitymatrix.vS1.layer');
% daspect([1 1 1]);
hold on;
set(gca,'XTick',[0 0.5 1],'YTick',[0 0.5 1]);
xlabel('Presynaptic distance (normalized)');
ylabel('Postsynaptic distance (normalized)');

figure, imagesc([0 1],[0 1],connectivitymatrix.S2.neuron),colormap(flipud(jet(256))),colorbar,title('connectivitymatrix.S2.neuron');
% daspect([1 1 1]);
hold on;
set(gca,'XTick',[0 0.5 1],'YTick',[0 0.5 1]);
xlabel('Presynaptic distance (normalized)');
ylabel('Postsynaptic distance (normalized)');
figure, imagesc([0 1],[0 1],connectivitymatrix.S2.layer),colormap(flipud(jet(256))),colorbar,title('connectivitymatrix.S2.layer');
% daspect([1 1 1]);
hold on;
set(gca,'XTick',[0 0.5 1],'YTick',[0 0.5 1]);
xlabel('Presynaptic distance (normalized)');
ylabel('Postsynaptic distance (normalized)');

assignin('base', 'connectivitymatrix', connectivitymatrix);
