/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;

public class StocMeshMorphMol {
    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("Usage: java -jar StocAveMesh.jar <Input File> <Mesh File> <Output File Prefix> [specie,specie,...]");
            System.out.println("args.length = " + args.length);
            System.exit(1);
        } else {
            try {
                String[] dendriteCytosolVols;
                String inFilePath = args[0];
                String meshFilePath = args[1];
                String outFilePath = args[2];
                String[] outputSpecies = args.length == 4 ? args[3].split(",") : new String[]{};
                int dendriteMembraneSubVol = 0;
                int dendriteCytosolSubVol = 0;
                int headSubVol = 0;
                int neckSubVol = 0;
                int psdSubVol = 0;
                System.out.println("Analyzing Data, please wait ...");
                BufferedReader in = new BufferedReader(new FileReader(inFilePath));
                String line = in.readLine();
                String[] strs = line.split(" ");
                String dendriteCytosols = "";
                int firstVolPointer = 1;
                int i = 1;
                while (i < strs.length) {
                    if (strs[i].indexOf("_0_") > 0 && i > 1) {
                        firstVolPointer = i;
                        break;
                    }
                    if (strs[i].indexOf("_dendrite") > 0 && strs[i].indexOf("_submembrane") > 0) {
                        ++dendriteMembraneSubVol;
                    }
                    if (strs[i].indexOf("_dendrite") > 0 && strs[i].indexOf("_cytosol") > 0) {
                        dendriteCytosols = String.valueOf(dendriteCytosols) + i + ",";
                        ++dendriteCytosolSubVol;
                    }
                    if (strs[i].indexOf("_head_") > 0) {
                        ++headSubVol;
                    }
                    if (strs[i].indexOf("_neck_") > 0) {
                        ++neckSubVol;
                    }
                    if (strs[i].indexOf("_PSD_") > 0) {
                        ++psdSubVol;
                    }
                    ++i;
                }
                int nSubVol = firstVolPointer > 1 ? firstVolPointer - 1 : strs.length - 1;
                int nPara = (strs.length - 1) / nSubVol;
                System.out.println("Total number of Spieces: " + nPara);
                System.out.println("Total number of subvolumes: " + nSubVol);
                int dendriateSubVol = dendriteMembraneSubVol + dendriteCytosolSubVol;
                if (dendriteCytosols.length() > 0) {
                    dendriteCytosols = dendriteCytosols.substring(0, dendriteCytosols.length() - 1);
                    dendriteCytosolVols = dendriteCytosols.split(",");
                } else {
                    dendriteCytosolVols = new String[]{};
                }
                System.out.println("Dendrite Membrane Subvolume #: " + dendriteMembraneSubVol);
                System.out.println("Dendrite Cytosol Subvolume #: " + dendriteCytosolSubVol);
                System.out.println("Total Dendrite Subvolume #: " + dendriateSubVol);
                System.out.println("Neck Subvolume #: " + neckSubVol);
                System.out.println("Head Subvolume #: " + headSubVol);
                System.out.println("PSD Subvolume #: " + psdSubVol);
                System.out.print("\nSpecies: ");
                String[] labels = new String[nPara];
                int i2 = 0;
                while (i2 < nPara) {
                    labels[i2] = strs[i2 * nSubVol + 1].substring(strs[i2 * nSubVol + 1].lastIndexOf("Spc_") + 4);
                    System.out.print(String.valueOf(labels[i2]) + " ");
                    ++i2;
                }
                in.close();
                System.out.println("\n\nProcessing Mesh Data, please wait ...");
                double[] volumes = new double[nSubVol];
                int meshCounter = 0;
                BufferedReader inMesh = new BufferedReader(new FileReader(meshFilePath));
                String meshLine = inMesh.readLine();
                while ((meshLine = inMesh.readLine()) != null) {
                    String[] tokens = meshLine.split(" +");
                    volumes[meshCounter] = new Double(tokens[13]);
                    ++meshCounter;
                }
                if (meshCounter != nSubVol) {
                    System.out.println("\nMesh file does not match the output data!\n");
                    System.exit(1);
                }
                double dend_volume = volumes[0];
                double neck_volume = 0.0;
                if (neckSubVol > 0) {
                    neck_volume = volumes[dendriateSubVol];
                }
                double head1_volume = volumes[dendriateSubVol + neckSubVol];
                double head2_volume = volumes[dendriateSubVol + neckSubVol + 1];
                double psd_volume = volumes[dendriateSubVol + neckSubVol + headSubVol];
                System.out.println("Dendrite Subvolume Size: " + dend_volume);
                if (neckSubVol > 0) {
                    System.out.println("Neck Subvolume Size: " + neck_volume);
                }
                System.out.println("Head Subvolume 1 Size: " + head1_volume);
                System.out.println("Head Subvolume 2 Size: " + head2_volume);
                System.out.println("PSD Subvolume Size: " + psd_volume);
                inMesh.close();
                System.out.println("\n\nProcessing Data, please wait ...");
                int i3 = 0;
                while (i3 < nPara) {
                    if (StocMeshMorphMol.checkOutputspecie(labels[i3], outputSpecies)) {
                        System.out.println("Processing specie: " + labels[i3]);
                        PrintWriter out = new PrintWriter(new FileWriter(String.valueOf(outFilePath) + "_" + labels[i3] + ".txt"));
                        in = new BufferedReader(new FileReader(inFilePath));
                        out.print("Time ");
                        out.print("S_" + labels[i3] + "_DendAve ");
                        out.print("S_" + labels[i3] + "_DendSTDEV ");
                        out.print("S_" + labels[i3] + "_DendMemAve ");
                        out.print("S_" + labels[i3] + "_DendMemSTDEV ");
                        out.print("S_" + labels[i3] + "_DendCytAve ");
                        out.print("S_" + labels[i3] + "_DendCytSTDEV ");
                        out.print("S_" + labels[i3] + "_NeckAve ");
                        out.print("S_" + labels[i3] + "_NeckSTDEV ");
                        out.print("S_" + labels[i3] + "_HeadAve ");
                        out.print("S_" + labels[i3] + "_HeadSTDEV ");
                        out.print("S_" + labels[i3] + "_PSDAve ");
                        out.print("S_" + labels[i3] + "_PSDSTDEV ");
                        out.print("S_" + labels[i3] + "_Ave ");
                        out.println("");
                        line = in.readLine();
                        while ((line = in.readLine()) != null) {
                            String[] tokens = line.split(" ");
                            String newLine = tokens[0];
                            double[] values = new double[nSubVol];
                            double[] sizes = new double[nSubVol];
                            int counter = 0;
                            int pointer = i3 * nSubVol + 1;
                            double[] dendriteMembraneValues = new double[dendriteMembraneSubVol];
                            double[] dendriteCytosolValues = new double[dendriteCytosolSubVol];
                            double[] dendriteValues = new double[dendriateSubVol];
                            double ave = 0.0;
                            double memAve = 0.0;
                            double cytAve = 0.0;
                            int memPointer = 0;
                            int cytPointer = 0;
                            int j = 0;
                            while (j < dendriateSubVol) {
                                dendriteValues[j] = new Double(tokens[pointer + j]);
                                ave += dendriteValues[j];
                                values[counter] = dendriteValues[j];
                                sizes[counter] = dend_volume;
                                ++counter;
                                if (StocMeshMorphMol.checkConVol(pointer - i3 * nSubVol + j, dendriteCytosolVols)) {
                                    dendriteCytosolValues[cytPointer] = dendriteValues[j];
                                    ++cytPointer;
                                    cytAve += dendriteValues[j];
                                } else {
                                    dendriteMembraneValues[memPointer] = dendriteValues[j];
                                    ++memPointer;
                                    memAve += dendriteValues[j];
                                }
                                ++j;
                            }
                            newLine = dendriateSubVol > 1 ? String.valueOf(newLine) + " " + StocMeshMorphMol.calConcentration(ave, dend_volume) + " " + StocMeshMorphMol.stdev(dendriteValues, ave) + " " + StocMeshMorphMol.calConcentration(memAve /= (double)dendriteMembraneSubVol, dend_volume) + " " + StocMeshMorphMol.stdev(dendriteMembraneValues, memAve) + " " + StocMeshMorphMol.calConcentration(cytAve /= (double)dendriteCytosolSubVol, dend_volume) + " " + StocMeshMorphMol.stdev(dendriteCytosolValues, cytAve) + " " : String.valueOf(newLine) + " " + StocMeshMorphMol.calConcentration(ave /= (double)dendriateSubVol, dend_volume) + " 0.0 " + " " + StocMeshMorphMol.calConcentration(ave, dend_volume) + " 0.0 0.0 0.0 ";
                            pointer += dendriateSubVol;
                            if (neckSubVol > 0) {
                                double[] neckValues = new double[neckSubVol];
                                ave = 0.0;
                                int j2 = 0;
                                while (j2 < neckSubVol) {
                                    neckValues[j2] = new Double(tokens[pointer + j2]);
                                    ave += neckValues[j2];
                                    values[counter] = neckValues[j2];
                                    sizes[counter] = neck_volume;
                                    ++counter;
                                    ++j2;
                                }
                                newLine = neckSubVol > 1 ? String.valueOf(newLine) + StocMeshMorphMol.calConcentration(ave, neck_volume) + " " + StocMeshMorphMol.stdev(neckValues, ave) + " " : String.valueOf(newLine) + StocMeshMorphMol.calConcentration(ave /= (double)neckSubVol, neck_volume) + " 0.0 ";
                                pointer += neckSubVol;
                            }
                            double[] headValues = new double[headSubVol];
                            double[] headVsizes = new double[headSubVol];
                            ave = 0.0;
                            memAve = 0.0;
                            cytAve = 0.0;
                            memPointer = 0;
                            cytPointer = 0;
                            int j3 = 0;
                            while (j3 < headSubVol) {
                                headValues[j3] = new Double(tokens[pointer + j3]);
                                if (j3 == 0) {
                                    headVsizes[j3] = head1_volume;
                                    sizes[counter] = head1_volume;
                                } else {
                                    headVsizes[j3] = head2_volume;
                                    sizes[counter] = head2_volume;
                                }
                                values[counter] = headValues[j3];
                                ++counter;
                                ++j3;
                            }
                            ave = StocMeshMorphMol.average(headValues, headVsizes);
                            double ave_con = StocMeshMorphMol.average_con(headValues, headVsizes);
                            newLine = headSubVol > 1 ? String.valueOf(newLine) + ave_con + " " + StocMeshMorphMol.stdev(headValues, ave) + " " : String.valueOf(newLine) + ave_con + " 0.0 ";
                            pointer += headSubVol;
                            double[] psdValues = new double[psdSubVol];
                            ave = 0.0;
                            int j4 = 0;
                            while (j4 < psdSubVol) {
                                psdValues[j4] = new Double(tokens[pointer + j4]);
                                ave += psdValues[j4];
                                values[counter] = psdValues[j4];
                                sizes[counter] = psd_volume;
                                ++counter;
                                ++j4;
                            }
                            newLine = psdSubVol > 1 ? String.valueOf(newLine) + StocMeshMorphMol.calConcentration(ave, psd_volume) + " " + StocMeshMorphMol.stdev(psdValues, ave) + " " : String.valueOf(newLine) + StocMeshMorphMol.calConcentration(ave /= (double)psdSubVol, psd_volume) + " 0.0 ";
                            newLine = String.valueOf(newLine) + StocMeshMorphMol.average_con(values, sizes);
                            out.println(newLine);
                        }
                        in.close();
                        out.close();
                    }
                    ++i3;
                }
                System.out.println("Done.");
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
            }
        }
    }

    private static boolean checkConVol(int pointer, String[] connectorSubVols) {
        if (connectorSubVols.length == 0) {
            return false;
        }
        int i = 0;
        while (i < connectorSubVols.length) {
            if (pointer == new Integer(connectorSubVols[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean checkOutputspecie(String specie, String[] outputspecies) {
        if (outputspecies.length == 0) {
            return true;
        }
        int i = 0;
        while (i < outputspecies.length) {
            if (specie.equalsIgnoreCase(outputspecies[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static double stdev(double[] values, double mean) {
        if (values.length < 2) {
            return 0.0;
        }
        double s = 0.0;
        int i = 0;
        while (i < values.length) {
            s += (values[i] - mean) * (values[i] - mean);
            ++i;
        }
        return Math.sqrt(s / (double)(values.length - 1));
    }

    private static double average(double[] values, double[] sizes) {
        int n = values.length;
        double sum = 0.0;
        double total_volume = 0.0;
        int i = 0;
        while (i < n) {
            sum += values[i] * sizes[i];
            total_volume += sizes[i];
            ++i;
        }
        return sum / total_volume;
    }

    private static double average_con(double[] values, double[] sizes) {
        int n = values.length;
        double sum = 0.0;
        double total_volume = 0.0;
        int i = 0;
        while (i < n) {
            sum += StocMeshMorphMol.calConcentration(values[i], sizes[i]) * sizes[i];
            total_volume += sizes[i];
            ++i;
        }
        return sum / total_volume;
    }

    private static double calConcentration(double mN, double volume) {
        return mN / (0.6023 * volume);
    }
}

