COMMENT
a steady-state synaptic current with conductance density defined by
        i = g * (v - e)      i(mA/cm2), g(mho/cm2);
        where
         g = 0 for t < onset or t >= offset and
         g = gss for t >= onset and t < offset

this has the property that the maximum value is gss and occurs at
 onset <= t < offset
ENDCOMMENT

INDEPENDENT {t FROM 0 TO 1 WITH 1 (ms)}
NEURON {
        SUFFIX synss
        RANGE onset, offset, gss, e, i, g
	GLOBAL mult
        NONSPECIFIC_CURRENT i
}
UNITS {
        (mA) = (milliamp)
        (mV) = (millivolt)
}
PARAMETER {
        onset=0 (ms)
        offset=0 (ms)
        gss=0   (mho/cm2)
        e=0     (mV)
        v       (mV)
	mult=0
}
ASSIGNED { i (mA/cm2)  g (mho/cm2)}

BREAKPOINT {
        g = gss * alpha(t)*mult
        i = g*(v - e)
}

FUNCTION alpha(x) {
        if (x < onset || x >= offset) {
                alpha = 0
        }else{
                alpha = 1
        }
}
