COMMENT

   **************************************************
   File generated by: neuroConstruct v1.3.8 
   **************************************************

   This file holds the implementation in NEURON of the Cell Mechanism:
   Ca_mit_conc_ChannelML (Type: Ion concentration, Model: ChannelML based process)

   with parameters: 
   /channelml/@units = SI Units 
   /channelml/notes = A channel from Bhalla, U.S.and Bower, J.M. Exploring parameter space in detailed single neuron models:     simulations of the mitral and granule cells ... 
   /channelml/ion/@name = ca 
   /channelml/ion/@charge = 2 
   /channelml/ion/@role = SignallingSubstance 
   /channelml/ion/notes = Signifies that the ion is involved in a process which alters its concentration 
   /channelml/ion_concentration/@name = Ca_mit_conc_ChannelML 
   /channelml/ion_concentration/status/@value = stable 
   /channelml/ion_concentration/status/contributor/name = Simon O'Connor 
   /channelml/ion_concentration/notes = An expontially decaying pool of calcium 
   /channelml/ion_concentration/publication/fullTitle = Bhalla, U.S.and Bower, J.M. Exploring parameter space in detailed single neuron models:     simulations of the mitral and granule cells of the olfacto ... 
   /channelml/ion_concentration/publication/pubmedRef = http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?cmd=Retrieve&amp;db=PubMed&amp;list_uids=7688798&amp;dopt=Abstract 
   /channelml/ion_concentration/ion_species = ca 
   /channelml/ion_concentration/decaying_pool_model/resting_conc = 5.2e-6 
   /channelml/ion_concentration/decaying_pool_model/decay_constant = 0.01 
   /channelml/ion_concentration/decaying_pool_model/pool_volume_info/shell_thickness = 0.00001 

// File from which this was generated: /home/Simon/nC_projects/Rat_Mitral_Cell_Gap_Network_copy4/cellMechanisms/Ca_mit_conc_ChannelML/CaPool.xml

// XSL file with mapping to simulator: /home/Simon/nC_projects/Rat_Mitral_Cell_Gap_Network_copy4/cellMechanisms/Ca_mit_conc_ChannelML/ChannelML_v1.8.0_NEURONmod.xsl

ENDCOMMENT


?  This is a NEURON mod file generated from a ChannelML file

?  Unit system of original ChannelML file: SI Units

COMMENT
    A channel from Bhalla, U.S.and Bower, J.M. Exploring parameter space in detailed single neuron models:
    simulations of the mitral and granule cells of the olfactory bulb
ENDCOMMENT

    

? Creating ion concentration

TITLE Channel: Ca_mit_conc_ChannelML

COMMENT
    An expontially decaying pool of calcium
ENDCOMMENT


UNITS {
    (mV) = (millivolt)
    (mA) = (milliamp)
    (um) = (micrometer)
    (l) = (liter)
    (molar) = (1/liter)
    (mM) = (millimolar)
}

    
NEURON {
    SUFFIX Ca_mit_conc_ChannelML
    USEION ca READ ica WRITE cai VALENCE 2
    
    RANGE cai
    
    RANGE rest_conc
    
    
    RANGE tau
    
    
    GLOBAL total_current
    
    
    RANGE thickness, F
    
    GLOBAL volume, surf_area
    
    
}

ASSIGNED {

    ica (mA/cm2)
    diam (um)
}

INITIAL {
    
        
    LOCAL shell_inner_diam

    shell_inner_diam = diam - (2*thickness)
    
    volume = (diam*diam*diam)*3.14159/6 - (shell_inner_diam*shell_inner_diam*shell_inner_diam)*3.14159/6
    
    surf_area = (diam*diam)*3.14159
    
    cai = rest_conc

}

PARAMETER {

    total_current
    rest_conc = 0.0000052 (mM)
          
    
    tau = 10 (ms)
   
    F = 96494 (C)
    
    thickness = 10 (um)   
                
    volume
    surf_area
    
    
}

STATE {

    cai (mM)

}

BREAKPOINT {

    SOLVE conc METHOD derivimplicit
    

}

DERIVATIVE conc {
    
    LOCAL thickness_cm, surf_area_cm2, volume_cm3 ? Note, normally dimensions are in um, but curr dens is in mA/cm2, etc
    
    thickness_cm = thickness *(1e-4)
    surf_area_cm2 = surf_area * 1e-8
    volume_cm3 = volume * 1e-12
    
    total_current = ica * surf_area_cm2


    cai' =  ((-1 * total_current)/(2 * F * volume_cm3)) - ((cai - rest_conc)/tau)
    

}

